#ifndef __ADDRBOOK_H
#define __ADDRBOOK_H

typedef struct ADDR_REC
{
    struct ADDR_REC *next;
    struct ADDR_REC *prev;

    char quickkey[36];
    char comment[71];
    char to_field[36];
    unsigned short zone,net,node,point;
    char inet[100];
    char subject[72];
    char first_line[100];
}
ADDR_REC;

typedef struct MAIL_LINK_REC
{
    struct MAIL_LINK_REC *next;
    unsigned addrnum;
}
MAIL_LINK_REC;

typedef struct MAIL_REC
{
    struct MAIL_REC *next;
    struct MAIL_REC *prev;

    char quickkey[36];
    char comment[71];
    char subject[72];
    char blind;
    MAIL_LINK_REC *maillist;
}
MAIL_REC;

extern ADDR_REC tempaddr;
extern MAIL_REC tempmail;

int adopt_address(char place, int email);
int address_book(ADDR_REC *addr_out);

int get_quickkey(char maillist, char *key);

#endif
