#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK ''
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "shell.h"
#include "entermsg.h"
#include "writemsg.h"
#include "readarea.h"
#include "readmail.h"
#include "scrsaver.h"
#include "readsets.h"
#include "screen.h"
#include "keyb.h"
#include "general.h"
#include "pgp.h"
#include "files.h"
#include "vars.h"

FILE *Ftag;

#define AreaBufSize 4096

char *fbuf;
unsigned buf_start,buf_end;

unsigned anum;
int atype;                     // Area flags
char net_crash,net_direct,net_immediate,net_hold,net_killsent,net_fattach,net_freq;
char intags;


char InCarbon,InCross;

char usesig,usetag,usefile,userot13,clearspaces,pgpflags,add_addrbook;
char crossp,carbon,blindc;
int right_pos;
char import_file[256];

static unsigned edit_corner;

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != '\0')
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

char area_tagged(unsigned area)
{
    if ((buf_start > area) || (buf_end<area))
    {
        fseek(Ftag,area-1,SEEK_SET);
        buf_start = area;
        buf_end = area-1+fread(fbuf,1,AreaBufSize,Ftag);
    }
    return fbuf[area-buf_start];
}

void set_tag(unsigned area, char tag)
{
    if ((buf_start <= area) && (buf_end >= area))
        fbuf[area-buf_start] = tag;

    fseek(Ftag,area-1,SEEK_SET);
    fwrite(&tag,1,1,Ftag);
}

void draw_line_em(int dypos, unsigned darea)
{
    char str[81];
    int num,slen,maxlen,max2;

    tbar(4,dypos,scrwidth-3,dypos,color[col_area_number]);
    if ((intags) && (area_tagged(darea)))
#ifdef __linux__
        writechr(4,dypos,ACS_BULLET,color[col_area_tagged]);
#else
        writechr(4,dypos,'',color[col_area_tagged]);
#endif
    strcpy(str, pkt->get_area_number(pkt, darea)); slen = strlen(str);
    cwritexy(10-slen,dypos,str,color[col_area_number]);

    if (fmt == format_qwk)
        cwritexy(11,dypos,"QWK",color[col_area_type]); else
    if ((fmt == format_hippo) && (!pkt->hippoinf))
        cwritexy(11,dypos,"Hippo",color[col_area_type]);
    else {
        num = pkt->area_type(pkt, darea);
        if (((num & TYPE_ECHO) > 0) && ((num & TYPE_NET) > 0))
            if (num & TYPE_INET)
                cwritexy(11,dypos,"EMail",color[col_area_type]);
            else
                cwritexy(11,dypos,"Net",color[col_area_type]);
        else
        if (num & TYPE_ECHO)
            if (num & TYPE_INET)
                cwritexy(11,dypos,"News",color[col_area_type]);
            else
                cwritexy(11,dypos,"Echo",color[col_area_type]);
        else
            if (fmt == format_omen)
                cwritexy(11,dypos,"OMEN",color[col_area_type]);
            else
                cwritexy(11,dypos,"Local",color[col_area_type]);
    }

    tran(strcpy(str,pkt->get_area_name(pkt, darea)));
    maxlen = scrwidth-36;
    if (maxlen < 60) str[maxlen] = 0; else maxlen = 60;
    cwritexy(17,dypos,str,color[col_area_name]);

    tran(strcpy(str,pkt->get_area_tag(pkt, darea)));
    max2 = scrwidth-65;
    if (max2 < 80) str[max2] = 0;
    cwritexy(18+maxlen,dypos,str,color[col_area_tagname]);
}

void area_list_em(char tagareas, int *pypos, unsigned *pupy)
{
    char quit,ch;

    unsigned num,ypos,upy;

    ypos = *pypos; upy = *pupy;
    intags = tagareas;
    quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch(ch) {
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$':
                            shell_dos(); break;
                        case 'G':
                            /* Home */
                            if (ypos+upy > 1) {
                                draw_line_em(ypos+5,ypos+upy);
                                ypos = 1;
                                if (upy > 0)
                                {
                                    upy = 0;
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line_em(num+5,num);
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'O':
                            /* End */
                            if (ypos+upy < pkt->areas)
                            {
                                draw_line_em(ypos+5,ypos+upy);
                                if (upy+(scrsize-7) > pkt->areas)
                                    ypos = pkt->areas-upy;
                                else
                                    ypos = scrsize-7;

                                if (pkt->areas-ypos > upy) {
                                    upy = pkt->areas-ypos;
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line_em(num+5,num+upy);
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'Q':
                            /* PgDn */
                            if (ypos+upy < pkt->areas) {
                                draw_line_em(ypos+5,ypos+upy);
                                if (ypos >= scrsize-7) {
                                    upy += scrsize-8;
                                    if (pkt->areas < ypos+upy)
                                        upy = pkt->areas-(scrsize-7);
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line_em(num+5,num+upy);
                                } else {
                                    if (upy+(scrsize-7) > pkt->areas)
                                        ypos = pkt->areas-upy;
                                    else
                                        ypos = scrsize-7;
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'I':
                            if (ypos+upy > 1) {
                                /* PgUp */
                                draw_line_em(ypos+5,ypos+upy);
                                if (ypos > 1)
                                {
                                    ypos = 1;
                                }
                                else
                                {
                                    if (upy < scrsize-8) upy = 0; else upy -= scrsize-8;
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line_em(num+5,num+upy);
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'H':
                            if (ypos+upy > 1) {
                                draw_line_em(ypos+5,ypos+upy);
                                if (ypos == 1) {
                                    upy--;
                                    scroll_down(4,6,scrwidth-3,scrsize-2);
                                    draw_line_em(ypos+5,ypos+upy);
                                } else ypos--;
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'P':
                            if (ypos+upy < pkt->areas) {
                                draw_line_em(ypos+5,ypos+upy);
                                if (ypos == scrsize-7) {
                                    upy++;
                                    scroll_up(4,6,scrwidth-3,scrsize-2);
                                    draw_line_em(ypos+5,ypos+upy);
                                } else ypos++;
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                    }
                    break;
                case ' ':
                    if (tagareas) {
                        set_tag(ypos+upy,!area_tagged(ypos+upy));
                        draw_line_em(ypos+5,ypos+upy);
                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                    }
                    break;
                case 13: quit = 1; break;
                case 27: quit = 1; ypos = 0; break;
            }
        } else give_timeslice();
    }
    intags = 0;
    *pypos = ypos; *pupy = upy;
}

char select_cross_areas(void)
{
    unsigned num,max;

    char tmp[256];

    int ypos;
    unsigned upy;

    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],"Crosspost; which area(s)");
    sprintf(tmp," %s ",lang[157]);
    cmiddle(scrsize-1,tmp,color[col_area_title]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    max = scrwidth-36; if (max > 60) max = 60;
    cwritexy(18+max,4,lang[100],color[col_area_help]);

    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    max = scrsize-7;
    if (pkt->areas < max) max = pkt->areas;
    for(num=1; num<=max; num++) draw_line_em(num+5,num);

    ypos = 1; upy = 0;
    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    if ((fbuf = (char *) malloc(AreaBufSize)) == NULL) return 0;
    sprintf(tmp, "%satagged.dat", setup.workpath);
    if ((Ftag = FileOpen(tmp, "w+b")) == NULL)
    {
        free(fbuf);
        return 0;
    }
    memset(fbuf,0,AreaBufSize);

    for(num=1; num<=pkt->areas / AreaBufSize; num++)
        fwrite(fbuf,1,AreaBufSize,Ftag);
    fwrite(fbuf,1,pkt->areas % AreaBufSize,Ftag);

    area_list_em(1,&ypos,&upy);
    if (ypos == 0)
    {
        free(fbuf);
        fclose(Ftag);
        sprintf(tmp, "%satagged.dat", setup.workpath); FileRemove(tmp);
        return 0;
    }
    return 1;
}

void do_keys_em(void)
{
    char ch;

    unsigned short cx,cy;
    char *oldscr;
    int slen;

    if (key_found == keys[0])
    {
        if ((atype & TYPE_NOTAGS) > 0)
        {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[158])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[158],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return;
        }
        usetag = !usetag;
        if (usetag) ch = ' '; else ch = CHECK;
        writechr(scrwidth/2-edit_corner+1,16,ch,color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[1])
    {
        usesig = !usesig;
        if (usesig) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,17,ch,color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[2])
    {
        crossp = !crossp;
        carbon = 0;
        blindc = 0;
        if (crossp) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,18,ch,color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,19,' ',color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,20,' ',color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[3])
    {
        if (((atype & TYPE_ECHO) > 0) && ((atype & TYPE_NET) == 0))
        {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[159])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[159],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return;
        }
        blindc = 0;
        crossp = 0;
        carbon = !carbon;
        if (carbon) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,18,' ',color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,19,ch,color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,20,' ',color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[4])
    {
        if (((atype & TYPE_ECHO) > 0) && ((atype & TYPE_NET) == 0))
        {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[159])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[159],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return;
        }
        carbon = 0;
        blindc = !blindc;
        crossp = 0;
        if (blindc) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,18,' ',color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,19,' ',color[col_emsg_hilight]);
        writechr(scrwidth/2-edit_corner+1,20,ch,color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[5])
    {
        userot13 = !userot13;
        if (userot13) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,21,ch,color[col_emsg_hilight]);
        return;
    }

    if (key_found == keys[6])
    {
        add_addrbook = !add_addrbook;
        if (add_addrbook) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-edit_corner+1,22,ch,color[col_emsg_hilight]);
        return;
    }
}

char edit_msg(void)
{
    int _keys[4],ch;
    unsigned disabled,slen;

    slen = get_max_langtext_len(160,163);
    edit_corner = get_max_langtext_len(146,152);
    if (slen > edit_corner) edit_corner = slen;
    if (strlen(lang[164])+2 > edit_corner) edit_corner = strlen(lang[164])+2;
    edit_corner /= 2;

    draw_shaded_box(scrwidth/2-edit_corner-2,6,scrwidth/2+edit_corner+2,23,color[col_emsg_frame],color[col_emsg_title],NULL);
    highwrite_locol = color[col_emsg_text];
    highwrite_hicol = color[col_emsg_hilight];
    _keys[0] = toupper(highwrite(scrwidth/2-slen/2,8,lang[160],NULL));
    _keys[1] = toupper(highwrite(scrwidth/2-slen/2,9,lang[161],NULL));
    _keys[2] = toupper(highwrite(scrwidth/2-slen/2,10,lang[162],NULL));
    _keys[3] = toupper(highwrite(scrwidth/2-slen/2,11,lang[163],NULL));
    slen = strlen(lang[164]);
    cmiddle(13,lang[164],color[col_emsg_text]);
    writechr(scrwidth/2+slen/2+2,13,(char) _keys[0],color[col_emsg_hilight]);

    draw_hline(scrwidth/2-edit_corner-2,scrwidth/2+edit_corner+2,15,color[col_emsg_frame]);

    keyb_keys = 7;
    if (atype & TYPE_NOTAGS)
    {
        highwrite_locol = color[col_emsg_disabled];
        highwrite_hicol = color[col_emsg_disabled];
    }
    else
    {
        highwrite_locol = color[col_emsg_text];
        highwrite_hicol = color[col_emsg_hilight];
    }

    keys[0] = toupper(highwrite(scrwidth/2-edit_corner,16,lang[147],&keypos[0]));
    if (!usetag) writechr(scrwidth/2-edit_corner+1,16,CHECK,color[col_emsg_hilight]);

    highwrite_locol = color[col_emsg_text];
    highwrite_hicol = color[col_emsg_hilight];

    keys[1] = toupper(highwrite(scrwidth/2-edit_corner,17,lang[146],&keypos[1]));
    if (usesig) writechr(scrwidth/2-edit_corner+1,17,CHECK,color[col_emsg_hilight]);

    keys[2] = toupper(highwrite(scrwidth/2-edit_corner,18,lang[150],&keypos[2]));
    if (crossp) writechr(scrwidth/2-edit_corner+1,18,CHECK,color[col_emsg_hilight]);

    if ((atype & TYPE_ECHO) && ((atype & TYPE_NET) == 0))
    {
        highwrite_locol = color[col_emsg_disabled];
        highwrite_hicol = color[col_emsg_disabled];
    }
    else
    {
        highwrite_locol = color[col_emsg_text];
        highwrite_hicol = color[col_emsg_hilight];
    }

    keys[3] = toupper(highwrite(scrwidth/2-edit_corner,19,lang[151],&keypos[3]));
    if (carbon) writechr(scrwidth/2-edit_corner+1,19,CHECK,color[col_emsg_hilight]);

    keys[4] = toupper(highwrite(scrwidth/2-edit_corner,20,lang[152],&keypos[4]));
    if (blindc) writechr(scrwidth/2-edit_corner+1,20,CHECK,color[col_emsg_hilight]);

    highwrite_locol = color[col_emsg_text];
    highwrite_hicol = color[col_emsg_hilight];

    keys[5] = toupper(highwrite(scrwidth/2-edit_corner,21,lang[148],&keypos[5]));
    if (userot13) writechr(scrwidth/2-edit_corner+1,21,CHECK,color[col_emsg_hilight]);

    keys[6] = toupper(highwrite(scrwidth/2-edit_corner,22,lang[280],&keypos[6]));
    if (add_addrbook) writechr(scrwidth/2-edit_corner+1,22,CHECK,color[col_emsg_hilight]);

    highwrite_locol = color[col_box_text];
    highwrite_hicol = color[col_box_hilight];

    disabled = 0;
    cursorsize(c_height-3,c_height-2);
    gotoxy(scrwidth/2+slen/2+2,13);

    for (;;)
    {
        ch = toupper(sk_getch());
        if (ch == 0)
        {
            key_found = find_key(sk_getch());
            do_keys_em();
            continue;
        }
        if ((ch == _keys[0]) || (ch == 13))
        {
            nocursor();
            return 1;
        }
        if (ch == _keys[1])
        {
            nocursor();
            return 2;
        }
        if (ch == _keys[2])
        {
            nocursor();
            return 3;
        }
        if (ch == _keys[3])
        {
            nocursor();
            return 4;
        }
    }
}

void enter_msg(char quit_after)
{
    unsigned short ox,oy;
    char *oldscr;

    int ypos;
    unsigned upy;

    unsigned max,num,oldorig,maxlen;

    char pvt;

    oldorig = origarea;
    replyanother = 0;
    save_scr(&ox,&oy,&oldscr);

    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    maxlen = scrwidth-36; if (maxlen > 60) maxlen = 60;
    cwritexy(18+maxlen,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    max = scrsize-7;
    if (pkt->areas < max) max = pkt->areas;
    for(num=1; num<=max; num++) draw_line_em(num+5,num);

    ypos = 1; upy = 0;
    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

_arealist:
    area_list_em(0,&ypos,&upy);
    while (ypos > 0)
    {
        origarea = ypos+upy;
        read_setup(pkt->get_area_tag(pkt, ypos+upy));

        read_table(1,inbound,opt.intable);
        read_table(0,outbound,opt.outtable);

        if (!try_open_reply()) goto _arealist;
        num = pkt->area_type(pkt, ypos+upy);
        pvt = num&TYPE_NOPUB ? 1 : 0;

        if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
            write_msg(0,pkt->get_area_tag(pkt, ypos+upy),pkt->get_area_name(pkt, ypos+upy),NULL,pvt,0,0);
        else
            write_msg(0,pkt->get_area_tag(pkt, ypos+upy),"All",NULL,pvt,0,0);

        if (quit_after) break;
        area_list_em(0,&ypos,&upy);
    }
    old_scr(ox,oy,&oldscr);
    origarea = oldorig;
}

void convert(char *fname, unsigned char *bound)
{
#define BUFSIZE 512

    unsigned char buffer[BUFSIZE],last;
    FILE *F;

    unsigned num;
    long lnum;

    fpos_t fsize;
    size_t readed;

    if ((F = FileOpen(fname,"r+b")) == NULL) return;
    fseek(F,0,SEEK_END);
    fgetpos(F,&fsize);

    last = 0;
    if (fsize > BUFSIZE)
    {
        for (lnum=0; lnum<fsize/BUFSIZE; lnum++)
        {
            fseek(F,lnum*BUFSIZE,SEEK_SET);
            readed = fread(buffer,1,BUFSIZE,F);
            for (num=0; num<readed; num++)
            {
                buffer[num] = bound[buffer[num]];
            }
            fseek(F,lnum*BUFSIZE,SEEK_SET);
            fwrite(buffer,1,readed,F);
        }
    }

    lnum = fsize / BUFSIZE;
    fseek(F,lnum*BUFSIZE,SEEK_SET);
    readed = fread(buffer,1,fsize % BUFSIZE,F);
    for (num=0; num<readed; num++)
    {
        buffer[num] = bound[buffer[num]];
    }

    fseek(F,lnum*BUFSIZE,SEEK_SET);
    fwrite(buffer,1,readed,F);
    fclose(F);
}

char move_area(unsigned *anum, char *parea) {
    unsigned short cx,cy;
    char *oldscr;

    unsigned area,max,num;

    int ypos;
    unsigned upy;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    max = scrwidth-36; if (max > 60) max = 60;
    cwritexy(18+max,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    ypos = 1; upy = origarea-1;
    max = scrsize-7;
    if (pkt->areas-upy < max) max = pkt->areas-upy;
    for (num=1; num<=max; num++)
        draw_line_em(num+5,num+upy);

    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    area_list_em(0,&ypos,&upy);
    area = ypos+upy;
    if ((ypos == 0) || (area == oldarea)) {
        old_scr(cx,cy,&oldscr);
        return 0;
    }

    replyanother = (area != origarea);

    read_setup(pkt->get_area_tag(pkt, area));
    read_table(0,outbound,opt.outtable);

    old_scr(cx,cy,&oldscr);
    *anum = area;

    strcpy(parea, pkt->get_area_tag(pkt, area));

    return 1;
}

char do_keys(char ypos, char endy, char *parea, char has_quoting)
{
    unsigned short cx,cy;
    char *oldscr;

    char tmp[81],ch;
    int info,slen;

    if ((key_found == keys[0]) && (!InCarbon) && (!InCross))
    {
        return move_area(&anum,parea);
    }
    else if (key_found == keys[1])
    {
        save_scr(&cx,&cy,&oldscr);
        draw_shaded_box(20,12,scrwidth-22,17,color[col_box_frame],color[col_box_title],lang[165]);
        sprintf(tmp," %s ",lang[166]);
        cmiddle(17,tmp,color[col_box_title]);
        cmiddle(14,lang[167],color[col_box_hilight]);

        key_xpos = 0; key_xovr = 0;
        info = get_string(22,15,255,scrwidth-45,import_file,128,color[col_box_hilight],color[col_box_text],color[col_box_scroll]);
        key_found = keys[1];
        old_scr(cx,cy,&oldscr);

        if ((info == 5) || (import_file[0] == 0))
            usefile = 0;
        else
            if (exists(import_file))
                usefile = 1;
            else {
                usefile = 0;
                save_scr(&cx,&cy,&oldscr);
                slen = strlen(lang[168])/2;
                draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
                cmiddle(14,lang[168],color[col_warn_hilight]);
                try_key(2);
                old_scr(cx,cy,&oldscr);
                return 0;
            }
        if (usefile) {
            tbar(scrwidth/2-37,ypos-1,scrwidth/2+38,ypos-1,color[col_emsg_disabled]);
            cwritexy(scrwidth/2-38,ypos-1,lang[133],color[col_emsg_hilight]);
            ch = import_file[70]; import_file[70] = 0;
            cwritexy(scrwidth/2-31,ypos-1,import_file,color[col_emsg_text]);
            import_file[70] = ch;
            ch = CHECK;
        } else {
            tbar(scrwidth/2-37,ypos-1,scrwidth/2+38,ypos-1,color[col_emsg_disabled]);
            cwritexy(scrwidth/2-38,ypos-1,lang[133],color[col_emsg_disabled]);
            cwritexy(scrwidth/2-37+strlen(lang[133]),ypos-1,lang[134],color[col_emsg_disabled]);
            ch = ' ';
        }
        writechr(scrwidth/2-36,ypos+1,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[2])
    {
        usesig = !usesig;
        if (usesig) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,ypos+2,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[3])
    {
        if ((atype & TYPE_NOTAGS) > 0)
        {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[158])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[158],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        usetag = !usetag;
        if (usetag) ch = ' '; else ch = CHECK;
        writechr(scrwidth/2-36,ypos+3,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[4])
    {
        if (InCarbon)
        {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[169])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[169],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        if (InCross) {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[170])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[170],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        crossp = !crossp;
        carbon = 0;
        blindc = 0;
        if (crossp) ch = CHECK; else ch = ' ';
        writechr(right_pos+1,ypos+1,ch,color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+2,' ',color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+3,' ',color[col_emsg_hilight]);
    }
    else if (key_found == keys[5])
    {
        if (InCarbon) {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[171])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[171],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        if (InCross) {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[172])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[172],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        if (((atype & TYPE_ECHO) > 0) && ((atype & TYPE_NET) == 0)) {
            save_scr(&cx,&cy,&oldscr);
            slen = strlen(lang[159])/2;
            draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[159],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        blindc = 0;
        crossp = 0;
        carbon = !carbon;
        if (carbon) ch = CHECK; else ch = ' ';
        writechr(right_pos+1,ypos+1,' ',color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+2,ch,color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+3,' ',color[col_emsg_hilight]);
    }
    else if (key_found == keys[6])
    {
        if (InCarbon) {
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(scrwidth/2-23,12,scrwidth/2+21,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[171],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        if (InCross) {
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(scrwidth/2-23,12,scrwidth/2+21,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[172],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        if (((atype & TYPE_ECHO) > 0) && ((atype & TYPE_NET) == 0)) {
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(scrwidth/2-23,12,scrwidth/2+21,16,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(14,lang[159],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
        carbon = 0;
        blindc = !blindc;
        crossp = 0;
        if (blindc) ch = CHECK; else ch = ' ';
        writechr(right_pos+1,ypos+1,' ',color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+2,' ',color[col_emsg_hilight]);
        writechr(right_pos+1,ypos+3,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[7])
    {
        userot13 = !userot13;
        if (userot13) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,ypos+4,ch,color[col_emsg_hilight]);
    }
    else if ((key_found == keys[8]) && (has_quoting))
    {
        clearspaces = !clearspaces;
        if (clearspaces) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,ypos+6,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[9])
    {
        pgpflags = pgp_options(pgpflags,has_quoting,atype);
        if (pgpflags) ch = CHECK; else ch = ' ';
        writechr(right_pos+1,ypos+4,ch,color[col_emsg_hilight]);
    }
    else if (key_found == keys[10])
    {
        add_addrbook = !add_addrbook;
        if (add_addrbook) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,ypos+5,ch,color[col_emsg_hilight]);
    }
    else if ((key_found == keys[12]) && (pkt->allow_crash))
    {
        net_crash = !net_crash;
        if (net_crash) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,endy+1,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[13]) && (pkt->allow_direct))
    {
        net_direct = !net_direct;
        if (net_direct) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,endy+2,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[14]) && (pkt->allow_immediate))
    {
        net_immediate = !net_immediate;
        if (net_immediate) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-36,endy+3,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[15]) && (pkt->allow_fattach))
    {
        net_fattach = !net_fattach;
        if (net_fattach)
        {
            ch = CHECK;
            cwritexy(scrwidth/2-38,10,lang[129],color[col_emsg_hilight]);
            net_freq = 0;
            writechr(scrwidth/2+16,endy+2,' ',color[col_emsg_hilight]);
        } else {
            ch = ' ';
            cwritexy(scrwidth/2-38,10,lang[130],color[col_emsg_hilight]);
        }
        writechr(scrwidth/2+16,endy+1,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[16]) && (pkt->allow_net_freq))
    {
        net_freq = !net_freq;
        if (net_freq) {
            ch = CHECK;
            cwritexy(scrwidth/2-38,10,lang[129],color[col_emsg_hilight]);
            net_fattach = 0;
            writechr(scrwidth/2+16,endy+1,' ',color[col_emsg_hilight]);
        } else {
            ch = ' ';
            cwritexy(scrwidth/2-38,10,lang[130],color[col_emsg_hilight]);
        }
        writechr(scrwidth/2+16,endy+2,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[17]) && (pkt->allow_hold))
    {
        net_hold = !net_hold;
        if (net_hold) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-4,endy+1,ch,color[col_emsg_hilight]);
        return 0;
    }
    if ((key_found == keys[18]) && (pkt->allow_killsent))
    {
        net_killsent = !net_killsent;
        if (net_killsent) ch = CHECK; else ch = ' ';
        writechr(scrwidth/2-4,endy+2,ch,color[col_emsg_hilight]);
        return 0;
    }

    return 0;
}

char ask_edit(void)
{
    char tmp[81];
    int ch,slen;

    cursorsize(c_height-3,c_height-2);
    slen = strlen(lang[173]);
    draw_shaded_box(scrwidth/2-slen/2-2-(slen & 1),12,scrwidth/2+slen/2+3,16,color[col_info_frame],color[col_info_title],NULL);
    sprintf(tmp,"%s  ",lang[173]);
    cmiddle(14,tmp,color[col_info_hilight]);
    writechr(scrwidth/2+slen/2+1,14,lang[174][0],color[col_info_text]);
    gotoxy(scrwidth/2+slen/2+1,14);
    for (;;) {
        ch = toupper(sk_getch());
        if ((ch == 13) || (ch == lang[174][0])) {
            nocursor();
            return 1;
        }
        if ((ch == 27) || (ch == lang[174][1])) {
            nocursor();
            return 0;
        }
    }
}
