/* Folder saver for Linux (or any other platform with just changing paths etc.) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

char *_fgets(char *buf, size_t n, FILE *fp)
{
    char *strp;

    if (fgets(buf,n,fp) == NULL) return NULL;
    strp = strchr(buf, '\r');
    if (strp != NULL) *strp = '\0';

    return buf;
}

int main(void)
{
    FILE *hin, *hout;
    char str[100];
    int lines;

    /* unpack "folder" */
    system("unzip ~/.skyreader/download/folder.000");

    /* open files */
    hin = fopen("~/.skyreader/extsave.txt", "rb");
    if (hin == NULL) return 1;
    hout = fopen("folder.hd", "a+t");
    if (hout == NULL) return 1;
    lines = 0; while (_fgets(str, sizeof(str), hin) != NULL) lines++;
    lines -= 4;
    fseek(hin, 0, SEEK_SET);

    /* write headers */
    fprintf(hout, "Command: Message\n");
    fprintf(hout, "%s\n", _fgets(str, sizeof(str), hin));
    fprintf(hout, "%s\n", _fgets(str, sizeof(str), hin));
    fprintf(hout, "%s\n", _fgets(str, sizeof(str), hin));
    fprintf(hout, "%s\n", _fgets(str, sizeof(str), hin));
    fprintf(hout, "Lines: %d\n", lines);

    /* write rest of lines */
    for (; lines > 0; lines--)
        fprintf(hout, "%s\n", _fgets(str, sizeof(str), hin));

    /* close */
    fclose(hin);
    fclose(hout);

    /* pack "folder" */
    system("zip -D ~/.skyreader/download/folder.000 folder.hd");
    remove("folder.hd");

    return 0;
}
