#ifdef __OS2__
#  define INCL_DOSPROCESS
#  define INCL_WINSWITCHLIST
#  define INCL_DOSFILEMGR
#  define INCL_DOSMISC
#  include <os2.h>
#  include "dqps.h"
#elif defined (__NT__)
#  include <windows.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#ifndef __linux__
#  include <process.h>
#else
#  include <sys/times.h>
#endif

#if !defined (__NT__) && !defined (__OS2__) && !defined (__linux__)
#  include <i86.h>
#endif

#include "version.h"
#include "scrsaver.h"
#include "general.h"
#include "keyb.h"
#include "vars.h"
#include "files.h"
#include "readarea.h"
#include "screen.h"
#include "shell.h"
#include "taglines.h"

#ifdef __linux__
char *strupr(char *str)
{
    register char *pstr;

    pstr = str;
    while (*pstr != '\0')
    {
        *pstr = toupper(*pstr);
        pstr++;
    }

    return str;
}

char *strlwr(char *str)
{
    register char *pstr;

    pstr = str;
    while (*pstr != '\0')
    {
        *pstr = tolower(*pstr);
        pstr++;
    }

    return str;
}

/*unsigned long LinuxGetUptime(void)
{
    FILE *F;
    char str[100],*strp;
    unsigned long num;

    F = FileOpen("/proc/uptime","r+b");
    if (F == NULL) return 0;

    num = 0;
    if (_fgets(str,sizeof(str),F) != NULL)
    {
        strp = strchr(str,'.');
        if (strp != NULL) *strp = '\0';

        if (sscanf(str,"%lu",&num) != 1) num = 0;
    }
    fclose(F);
    return num*1000;
}*/

int get_processes(void)
{
    DIR *dirp;
    struct dirent *direntp;
    char *strp;
    int procs;

    dirp = opendir("/proc");
    if (dirp == NULL) return 0;

    procs = 0;
    for (;;)
    {
        direntp = readdir(dirp);
        if (direntp == NULL) break;

        strp = direntp->d_name;
        while (*strp >= '0' && *strp <= '9') strp++;
        if (*strp == '\0') procs++;
    }
    closedir(dirp);

    return procs;
}
#endif

#ifdef __linux__
void try_key(int secs)
{
    clock_t oldtim,tim;
    int ch;
    struct tms buf;

    oldtim = times(&buf);
    for (;;)
    {
        tim = times(&buf);
        if (tim-oldtim >= CLOCKS_PER_SEC)
        {
            secs -= (tim-oldtim)/CLOCKS_PER_SEC;
            oldtim = tim;
            if (secs <= 0) break;
        }
        if (sk_kbhit())
        {
            ch = sk_getch();
            if (ch == 0) sk_getch();
            break;
        }
        give_timeslice();
    }
}
#else
void try_key(int secs)
{
    time_t oldtim,tim;
    int ch;

    oldtim = time(NULL);
    for (;;)
    {
        tim = time(NULL);
        if (tim != oldtim)
        {
            oldtim = tim;
            if (--secs == 0) break;
        }
        if (sk_kbhit())
        {
            ch = sk_getch();
            if (ch == 0) sk_getch();
            break;
        }
        give_timeslice();
    }
}
#endif

char *dtstr(char *str, time_t tim)
{
    struct tm *ti;

    ti = localtime(&tim);
    strcpy(str,"00     00  00:00");
    str[0] = (char) (ti->tm_mday/10 + '0');
    str[1] = (char) (ti->tm_mday%10 + '0');
    memcpy(str+3,month[ti->tm_mon],3);
    str[7] = (char) ((ti->tm_year%100)/10 + '0');
    str[8] = (char) ((ti->tm_year%10) + '0');

    str[11] = (char) (ti->tm_hour/10 + '0');
    str[12] = (char) (ti->tm_hour%10 + '0');
    str[14] = (char) (ti->tm_min/10 + '0');
    str[15] = (char) (ti->tm_min%10 + '0');
    return str;
}
char highwrite_hicol,highwrite_locol;

int highwrite(int x, int y, char *str, int *keypos)
{
    int xp,highlight,result;
    int nro;

    highlight = 0;
    xp = x;

    if (keypos != NULL) *keypos = 0;
    result = 0;
    nro = 0;
    while (str[nro] != '\0')
    {
        if (highlight == 1)
        {
            writechr(xp,y,str[nro],highwrite_hicol);
            if (keypos != NULL) *keypos = xp - x + 1;
            xp++;
            result = str[nro];
            highlight = 0;
        }
        else
        {
            if (str[nro] == '~')
            {
                highlight = 1;
            }
            else
            {
                writechr(xp,y,str[nro],highwrite_locol);
                xp++;
            }
        }
        nro++;
    }
    return result;
}

#ifdef __OS2__
int get_threads(void)
{
    PULONG DQPS_Buffer;
    int threads;

    DosAllocMem((PPVOID) &DQPS_Buffer, 0x10000, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_TILE);
    if (dosQProcStatus(DQPS_Buffer, 0xffff)) {
        /*we have an error!*/
        return 0;
    }

    threads = ((struct qsPtrRec_s *) DQPS_Buffer)->pGlobalRec->cThrds;
    DosFreeMem(DQPS_Buffer);

    return threads;
}

int get_processes(void)
{
    int count = 0;
    int size;
    PULONG DQPS_Buffer;
    struct qsPrec_s *pProcRecord;

    DosAllocMem((PPVOID) &DQPS_Buffer, 0x10000, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_TILE);
    if (dosQProcStatus(DQPS_Buffer, 0xffff)) {
        /*we have an error!*/
        return 0;
    }

    pProcRecord = ((qsPtrRec_s*)DQPS_Buffer)->pProcRec;
    while(pProcRecord->RecType == 1){
        size = sizeof(struct qsPrec_s);
        size += pProcRecord->cTCB * sizeof(struct qsTrec_s) ;
        size += pProcRecord->c16Sem * sizeof(short) ;
        size += pProcRecord->cLib * sizeof(short) ;
        size += pProcRecord->cShrMem * sizeof(short) ;
        pProcRecord = (struct qsPrec_s*) ( (char*)pProcRecord + size ) ;
        count++ ;
    }
    DosFreeMem(DQPS_Buffer);
    return count;
}
#endif

char *conv_macros(char *src, char *dest)
{
    size_t slen,num,n2,n3,mslen;
    int inmacro,dblplot;
    char mstr[81],tag[21],*pstr,tmp[256],*plot,result[256],ch,cmd,fillch;
#if defined (__OS2__) || defined (__NT__) || defined (__linux__)
    unsigned long temp = 0;
    int uptime_asked;
#ifdef __linux__
    struct tms buf;
#endif
#endif

    time_t _tim;
    struct tm *tim;

    dest[0] = 0;
    inmacro = 0;

#if defined (__OS2__) || defined (__NT__) || defined (__linux__)
    uptime_asked = 0;
#endif

    _tim = time(NULL);
    tim = localtime(&_tim);
    mslen = 0;

    /* Parse string */
    for (num=0; num<strlen(src); num++)
    {
        if (!inmacro)
        {
            /* Not yet inside macro */
            if (src[num] != '@')
            {
                slen = strlen(dest); dest[slen] = src[num]; dest[slen+1] = 0;
            }
            else
            {
                inmacro = 1;
                mstr[0] = 0; mslen = 0;
            }
        }
        else
        {
            /* Inside macro */
            if ((src[num] == ' ') || (src[num] == 13) || (src[num] == 10))
            {
                /* Oh no, found space or new line,
                 this wasn't a macro at all. :( */
                slen = strlen(dest); dest[slen] = '@'; dest[slen+1] = 0;
                strcat(dest,mstr);
                slen = strlen(dest); dest[slen] = src[num]; dest[slen+1] = 0;
                mstr[0] = 0; mslen = 0; inmacro = 0;
            }
            else
            {
                if (src[num] != '@')
                {
                    /* Haven't found end-of-macro character yet.. */
                    mstr[mslen++] = src[num]; mstr[mslen] = '\0';
                }
                else
                {
                    /* Ahh, finally a real macro! */
                    strcpy(tmp,mstr);
                    strupr(mstr);

                    /* Find special 'commands' */
                    dblplot = 0;
                    if ((plot = strchr(mstr,'.')) == NULL)
                    {
                        if ((plot = strchr(mstr,':')) != NULL) dblplot = 1;
                    }

                    if (plot != NULL)
                    {
                        *plot = 0;
                        plot++;
                    }

                    if ((mstr[0] == 'A') && (mstr[1] == 'T') && (mstr[2] == 0))
                    {
                        /* Area tag */
                        memcpy(tag,areatag,8); tag[8] = 0;

                        n2 = 0;
                        do {
                            if ((tag[n2] == '.') || (tag[n2] == ',') || (tag[n2] == ' '))
                                tag[n2] = '_';
                            else
                                tag[n2] = (char) toupper(tag[n2]);
                            n2++;
                        } while (tag[n2] != 0);
                        strcpy(result,tag);
                    }
                    else if (strcmp(mstr,"LAT") == 0)
                    {
                        /* Long area tag */
                        memcpy(tag,areatag,20); tag[20] = 0;

                        n2 = 0;
                        do
                        {
                            if ((tag[n2] == '.') || (tag[n2] == ',') || (tag[n2] == ' '))
                                tag[n2] = '_';
                            n2++;
                        }
                        while (tag[n2] != 0);
                        strcpy(result,tag);
                    }
                    else if (strcmp(mstr,"AREA") == 0) strcpy(result,areaname);
                    else if (strcmp(mstr,"RAREA") == 0) strcpy(result,pkt->get_area_name(pkt, pkt->gettag(pkt, reply.area)));
                    else if (strcmp(mstr,"FROM") == 0) strcpy(result,msg.mfrom);
                    else if (strcmp(mstr,"FFROM") == 0)
                    {
                        pstr = strchr(msg.mfrom,' ');
                        if (pstr == NULL)
                            strcpy(result,msg.mfrom);
                        else
                        {
                            ch = *pstr; *pstr = 0;
                            strcpy(result,msg.mfrom);
                            *pstr = ch;
                        }
                    } else if (strcmp(mstr,"LFROM") == 0)
                    {
                        pstr = strrchr(msg.mfrom,' ');
                        if (pstr == NULL)
                            strcpy(result,msg.mfrom);
                        else
                            strcpy(result,pstr);
                    }
                    else if (strcmp(mstr,"TO") == 0) strcpy(result,msg.mto);
                    else if (strcmp(mstr,"FTO") == 0)
                    {
                        pstr = strchr(msg.mto,' ');
                        if (pstr == NULL)
                        {
                            strcpy(result,msg.mto);
                        }
                        else
                        {
                            ch = *pstr; *pstr = 0;
                            strcpy(result,msg.mto);
                            *pstr = ch;
                        }
                    }
                    else if (strcmp(mstr,"LTO") == 0)
                    {
                        pstr = strrchr(msg.mto,' ');
                        if (pstr == NULL)
                            strcpy(result,msg.mto);
                        else
                            strcpy(result,pstr);
                    }
                    else if (strcmp(mstr,"FLAG_READ") == 0) strcpy(result,xti.flags&XTI_HAS_READ ? "Yes" : "No");
                    else if (strcmp(mstr,"FLAG_SAVED") == 0) strcpy(result,xti.flags&XTI_HAS_SAVED ? "Yes" : "No");
                    else if (strcmp(mstr,"FLAG_REPLIED") == 0) strcpy(result,xti.flags&XTI_HAS_REPLIED ? "Yes" : "No");
                    else if (strcmp(mstr,"FLAG_PRINTED") == 0) strcpy(result,xti.flags&XTI_HAS_PRINTED ? "Yes" : "No");
                    else if (strcmp(mstr,"MARK_SAVE") == 0) strcpy(result,xti.marks&XTI_MARK_SAVE ? "Save" : "");
                    else if (strcmp(mstr,"MARK_REPLY") == 0) strcpy(result,xti.marks&XTI_MARK_REPLY ? "Reply" : "");
                    else if (strcmp(mstr,"MARK_PRINT") == 0) strcpy(result,xti.marks&XTI_MARK_PRINT ? "Print" : "");
                    else if (strcmp(mstr,"MARK_DEL") == 0) strcpy(result,xti.marks&XTI_MARK_DELETE ? "Del" : "");
                    else if (strcmp(mstr,"MSGNUM") == 0) sprintf(result,"%lu",msg.mnum);
                    else if (strcmp(mstr,"SUBJ") == 0) strcpy(result,msg.subj);
                    else if (strcmp(mstr,"DATE") == 0) strcpy(result,msg.date);
                    else if (strcmp(mstr,"RFROM") == 0) strcpy(result,reply.mfrom);
                    else if (strcmp(mstr,"RFFROM") == 0)
                    {
                        pstr = strchr(reply.mfrom,' ');
                        if (pstr == NULL)
                        {
                            strcpy(result,reply.mfrom);
                        }
                        else
                        {
                            ch = *pstr; *pstr = 0;
                            strcpy(result,reply.mfrom);
                            *pstr = ch;
                        }
                    }
                    else if (strcmp(mstr,"RLFROM") == 0)
                    {
                        pstr = strrchr(reply.mfrom,' ');
                        if (pstr == NULL)
                            strcpy(result,reply.mfrom);
                        else
                            strcpy(result,pstr);
                    }
                    else if ((strcmp(mstr,"RTO") == 0) || ((mstr[0] == 'N') && (mstr[1] == 0))) strcpy(result,reply.mto);
                    else if ((strcmp(mstr,"RFTO") == 0) || ((mstr[0] == 'F') && (mstr[1] == 'N') && (mstr[2] == 0)))
                    {
                        pstr = strchr(reply.mto,' ');
                        if (pstr == NULL)
                        {
                            strcpy(result,reply.mto);
                        }
                        else
                        {
                            ch = *pstr; *pstr = 0;
                            strcpy(result,reply.mto);
                            *pstr = ch;
                        }
                    }
                    else if ((strcmp(mstr,"RLTO") == 0) || ((mstr[0] == 'L') && (mstr[1] == 'N') && (mstr[2] == 0)))
                    {
                        pstr = strrchr(reply.mto,' ');
                        if (pstr == NULL)
                            strcpy(result,reply.mto);
                        else
                            strcpy(result,pstr+1);
                    }
                    else if (strcmp(mstr,"RSUBJ") == 0) strcpy(result,reply.subj);
                    else if (strcmp(mstr,"RDATE") == 0) strcpy(result,reply.date);
                    else if ((mstr[0] == 'D') && (mstr[1] == 0)) sprintf(result,"%02d %s %02d",tim->tm_mday,month[tim->tm_mon],tim->tm_year % 100);
                    else if ((mstr[0] == 'D') && (mstr[1] == 'D') && (mstr[2] == 0)) sprintf(result,"%02i",tim->tm_mday+1);
                    else if ((mstr[0] == 'D') && (mstr[1] == 'M') && (mstr[2] == 0)) strcpy(result,month[tim->tm_mon]);
                    else if ((mstr[0] == 'D') && (mstr[1] == 'Y') && (mstr[2] == 0)) sprintf(result,"%02i",tim->tm_year % 100);
                    else if ((mstr[0] == 'T') && (mstr[1] == 0)) sprintf(result,"%02d:%02d:%02d",tim->tm_hour+1,tim->tm_min+1,tim->tm_sec+1);
                    else if (strcmp(mstr,"FORMAT") == 0)
                    {
                        switch (fmt)
                        {
                            case format_bw: strcpy(result,"BW"); break;
                            case format_qwk: strcpy(result,"QWK"); break;
                            case format_hippo: strcpy(result,"Hippo"); break;
                            case format_omen: strcpy(result,"OMEN"); break;
                            case format_soup: strcpy(result,"SOUP"); break;
                        }
                    }
                    else if (strcmp(mstr,"VER") == 0) strcpy(result,version);
                    else if (strcmp(mstr,"OS") == 0) strcpy(result,OPSYSTEM);
                    else if (strcmp(mstr,"BBS") == 0) strcpy(result,pkt->board_name);
                    else if (strcmp(mstr,"SYSOP") == 0) strcpy(result,pkt->sysop_name);
                    else if (strcmp(mstr,"CR") == 0) strcpy(result,"\r\n");
                    else if (strcmp(mstr,"TAG") == 0) strcpy(result,tagline);
                    else if (strcmp(mstr,"GETTAG") == 0)
                    {
                        if (plot != NULL)
                        {
                            strcpy(tmp,opt.tagfile);
                            strcpy(opt.tagfile,plot);
                        }
                        make_tagline(0);
                        if (plot != NULL)
                        {
                            plot = NULL;
                            strcpy(opt.tagfile,tmp);
                        }
                        result[0] = 0;
                    }
                    else if (strcmp(mstr,"LONGOS") == 0) strcpy(result,LONGOS);
                    else if (strcmp(mstr,"PID") == 0) sprintf(result,"%d",getpid());
#ifdef __OS2__
                    else if (strcmp(mstr,"TASKS") == 0) sprintf(result,"%d",WinQuerySwitchList(0,0,0));
                    else if (strcmp(mstr,"THREADS") == 0) sprintf(result,"%d",get_threads());
                    else if (strcmp(mstr,"PROCS") == 0) sprintf(result,"%d",get_processes());
#elif defined (__linux__)
                    else if (strcmp(mstr,"PROCS") == 0) sprintf(result,"%d",get_processes());
#endif
#if defined (__OS2__) || defined (__NT__) || defined  (__linux__)
                    else if (strcmp(mstr,"UPTIME_DAYS") == 0)
                    {
                        if (!uptime_asked)
                        {
#ifdef __OS2__
                            DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&temp,4);
#elif defined (__NT__)
                            temp = GetTickCount();
#elif defined (__linux__)
                            temp = times(&buf);
#else
#  error hm.
#endif
                            uptime_asked = 1;
                        }
                        sprintf(result,"%lu",(temp/(1000*3600*24))%365);
                    }
                    else if (strcmp(mstr,"UPTIME_HOURS") == 0)
                    {
                        if (!uptime_asked)
                        {
#ifdef __OS2__
                            DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&temp,4);
#elif defined (__NT__)
                            temp = GetTickCount();
#elif defined (__linux__)
                            temp = times(&buf);
#else
#  error hm.
#endif
                            uptime_asked = 1;
                        }
                        sprintf(result,"%lu",(temp/(1000*3600))%24);
                    }
                    else if (strcmp(mstr,"UPTIME_MINS") == 0)
                    {
                        if (!uptime_asked)
                        {
#ifdef __OS2__
                            DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&temp,4);
#elif defined (__NT__)
                            temp = GetTickCount();
#elif defined (__linux__)
                            temp = times(&buf);
#else
#  error hm.
#endif
                            uptime_asked = 1;
                        }
                        sprintf(result,"%lu",(temp/(1000*60))%60);
                    }
                    else if (strcmp(mstr,"UPTIME_SECS") == 0)
                    {
                        if (!uptime_asked)
                        {
#ifdef __OS2__
                            DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&temp,4);
#elif defined (__NT__)
                            temp = GetTickCount();
#elif defined (__linux__)
                            temp = times(&buf);
#else
#  error hm.
#endif
                            uptime_asked = 1;
                        }
                        sprintf(result,"%lu",(temp/(1000))%60);
                    }
#endif
                    else sprintf(result,"@%s@",tmp); /* Macro not found */

                    /* Add result to dest string */
                    if (plot == NULL)
                    {
                        strcat(dest,result);
                    }
                    else
                    {
                        pstr = strchr(plot,'\'');
                        if (pstr != NULL)
                        {
                            *pstr++ = '\0';
                            fillch = *pstr;
                        }
                        else
                        {
                            fillch = ' ';
                        }

                        /* Process special 'commands' */
                        if ((pstr = strchr(plot,':')) != NULL)
                        {
                            /* Print offset */
                            *pstr++ = '\0';
                            n2 = atol(pstr);
                            cmd = *(pstr-2);
                        }
                        else
                        {
                            n2 = 0;
                            cmd = *(plot+strlen(plot)-1);
                        }

                        switch (toupper(cmd))
                        {
                            case 'C':
                                /* Center justify */
                                n3 = atol(plot);
                                if (n3 > 0)
                                {
                                    result[n3] = 0;
                                    slen = strlen(result+n2);
                                    if (n3 > slen)
                                    {
                                        memmove(result+(n3-slen)/2,result+n2,slen+1);
                                        if ((n3-slen)/2 > 0)
                                        {
                                            result[(n3-slen)/2-1] = ' ';
                                            memset(result,fillch,(n3-slen)/2-1);
                                        }
                                        if ((n3-slen)/2+((n3-slen) & 1) > 0)
                                        {
                                            result[(n3-slen)/2+slen] = ' ';
                                            memset(result+(n3-slen)/2+slen+1,fillch,(n3-slen)/2+((n3-slen) & 1)-1);
                                        }
                                    }
                                }
                                strcat(dest,result);
                                break;
                            case 'R':
                                /* Right justify */
                                n3 = atol(plot);
                                if (n3 > 0)
                                {
                                    result[n3] = 0;
                                    slen = strlen(result+n2);
                                    if (n3 > slen)
                                    {
                                        memmove(result+n3-slen,result+n2,slen+1);
                                        result[n3-slen-1] = ' ';
                                        memset(result,fillch,n3-slen-1);
                                    }
                                }
                                strcat(dest,result);
                                break;
                            default:
                                /* Left justify */
                                n3 = atol(plot);

                                slen = strlen(result);
                                if (n2 > 0)
                                {
                                    memmove(result,result+n2,slen-n2+1);
                                    slen -= n2;
                                }
                                if (n3 > 0)
                                {
                                    if (dblplot)
                                    {
                                        result[n3+n2] = 0;
                                        if (n3 > slen)
                                        {
                                            result[slen] = ' ';
                                            memset(result+slen+1,fillch,n3-slen-1);
                                        }
                                    }
                                    result[n3+n2] = 0;
                                }
                                strcat(dest,result);
                                break;
                        }
                    }
                    inmacro = 0;
                    mstr[0] = '\0'; mslen = 0;
                }
            }
        }
    }

    if (inmacro)
    {
        slen = strlen(dest); dest[slen] = '@'; dest[slen+1] = 0;
        strcat(dest,mstr);
    }
    return dest;
}

void str2addr(char *addrstr, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point) {
    char *pstr;

    pstr = strchr(addrstr,':');
    if (pstr != NULL) *pstr = ' ';
    pstr = strchr(addrstr,'/');
    if (pstr != NULL) *pstr = ' ';
    pstr = strchr(addrstr,'.');
    if (pstr != NULL) *pstr = ' ';

    *zone = 0; *net = 0; *node = 0; *point = 0;
    sscanf(addrstr,"%hu %hu %hu %hu",zone,net,node,point);
}

char *adder(char *path) {
    unsigned num;
    char tmp[256];

    for (num=0; num<=999; num++) {
        sprintf(tmp,"%s%03i",path,num);
        if (!exists(tmp)) {
            strcpy(path,tmp);
            return path;
        }
    }
    tclrscr();
    printf("Sorry! You have all 1000 files used for packet: %s\n",path);
    printf("Delete some of them and try again. Press enter.\n");
    if (sk_getch() == 0) sk_getch();
    exit(1);
    return path;
}

char ask_mkdir(char *dir)
{
    unsigned short cx,cy;
    char *oldscr;

    char ch,ok;

    ok = 2;
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(5,5,scrwidth-4,11,color[col_warn_frame],color[col_warn_title],"Path not found");
    ch = dir[scrwidth-12]; dir[scrwidth-12] = 0;
    cmiddle(7,dir,color[col_warn_text]);
    dir[scrwidth-12] = ch;
    cmiddle(9,"Create it? (Y/n)",color[col_warn_hilight]);
    while (ok == 2)
    {
        if (sk_kbhit())
        {
            ch = (char) toupper(sk_getch());
            if ((ch == 13) || (ch == 'Y'))
                if (!mkpath(dir))
                {
                    draw_shaded_box(scrwidth/2-13,13,scrwidth/2+13,17,color[col_warn_frame],color[col_warn_title],NULL);
                    cmiddle(15,"Could not create path!",color[col_warn_hilight]);
                    if (sk_getch() == 0) sk_getch();
                    ok = 0;
                }
                else ok = 1;
            else
                if (ch == 'N') ok = 0;
        }
        else
            give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
    return ok;
}

#ifndef __linux__
void beep(void)
{
#ifdef __OS2__
    DosBeep(650,100);
    DosBeep(800,100);
#elif !defined (__NT__)
    sound(650);
    delay(100);
    sound(800);
    delay(100);
    nosound();
#endif
}
#endif

long basicreal2long(long invalue)
{
    long temp;
    int negative,expon;
    
    if (invalue & 0x00800000)
        negative = 1;
    else
        negative = 0;
    
    expon = (invalue >> 24) & 0xff;
    temp = (invalue & 0x007fffff) | 0x00800000;
    expon -= 152;
    if (expon == 0) return 0;
    
    if (expon < 0)
        temp >>= abs(expon);
    else
        temp <<= expon;
    
    if (negative)
        return -temp;
    else
        return temp;
}

long long2basicreal(long invalue)
{
    int negative;
    long expon;
    
    if (invalue == 0) return 0;
    
    if (invalue < 0) {
        negative = 1;
        invalue = labs(invalue);
    } else
        negative = 0;
    expon = 152;
    if (invalue < 0x007fffff)
        while ((invalue & 0x00800000) == 0)
        {
            invalue <<= 1;
            expon--;
        }
    else
        while (invalue & 0xff000000)
        {
            invalue >>= 1;
            expon++;
        }
    invalue &= 0x007fffff;
    if (negative)
        invalue |= 0x00800000;
    return invalue + (expon << 24);
}

char get_max_langtext_len(int start, int end)
{
    int num,max,slen;

    max = 0;
    for (num=start; num<=end; num++)
    {
        slen = strlen(lang[num]);
        if (slen > max) max = slen;
    }

    return (char) max;
}

char find_key(int ch)
{
    int num;

    if ((ch >= 16) && (ch <= 25))
    {
        for (num=0; num<keyb_keys; num++)
            if (table[ch-16] == keys[num])
                return (char) keys[num];
    }
    else if ((ch >= 30) && (ch <= 38))
    {
        for (num=0; num<keyb_keys; num++)
            if (table[ch-20] == keys[num])
                return (char) keys[num];
    }
    else if ((ch >= 44) && (ch <= 50))
    {
        for (num=0; num<keyb_keys; num++)
            if (table[ch-25] == keys[num])
                return (char) keys[num];
    }
    else if (ch >= 120 && ch <= 129)
    {
        if (ch == 129) ch = '0'; else ch -= 120+'1';
        for (num=0; num<keyb_keys; num++)
            if (ch == keys[num])
                return (char) keys[num];
    }
    if (ch == 36) shell_dos();
    return 0;
}

void err_box(char *text)
{
    unsigned short cx,cy;
    char *oldscr;
    int slen;

    slen = strlen(text);
    if (slen == 0) return;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,14,color[col_warn_frame],color[col_warn_title],"Error!");
    cmiddle(12,text,color[col_warn_hilight]);
    if (sk_getch() == 0) sk_getch();
    old_scr(cx,cy,&oldscr);
#ifdef __linux__
    gotoxy(1,scrsize);
#endif
}

void note_box(char *text)
{
    unsigned short cx,cy;
    char *oldscr;
    int slen;

    slen = strlen(text);
    if (slen == 0) return;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,14,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(12,text,color[col_info_hilight]);
    try_key(2);
    old_scr(cx,cy,&oldscr);
#ifdef __linux__
    gotoxy(1,scrsize);
#endif
}

static int carr[10], carrs;

int ask_choice(char *txt, int def)
{
    unsigned short cx,cy;
    char *oldscr, *text, *start;
    int slen, n;

    carrs = 0;

    start = text = (char *) malloc(strlen(txt));
    if (text == NULL) return def;

    while (*txt != '\0')
    {
        if (*txt == '~')
        {
            if (txt[1] < '0' || txt[1] > '9' || txt[2] == '\0') break;
            carr[txt[1]-'0'] = toupper(txt[2]);
            carrs++;
            txt += 2;
        }
        else
            *text++ = *txt++;
    }
    *text = '\0'; text = start;

    if (carrs == 0) return def;

    slen = strlen(text);
    if (slen == 0) return def;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,14,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(12,text,color[col_info_hilight]);
    for (;;)
    {
        char ch;

        ch = toupper(sk_getch());
        if (ch == 0)
            sk_getch();
        else
        {
            for (n = 0; n < carrs; n++)
                if (ch  == carr[n]) break;

            if (n < carrs) break;
        }
    }
    old_scr(cx,cy,&oldscr);
#ifdef __linux__
    gotoxy(1,scrsize);
#endif

    free(text);

    return n;
}
