#if 1
#include <windows.h>

static HANDLE HInput = INVALID_HANDLE_VALUE;

static unsigned long key_hit = 0xFFFFFFFFUL;
static char KbdOldChar;

void KbdInit(void)
{
    HInput = GetStdHandle(STD_INPUT_HANDLE);
    SetConsoleMode(HInput,FALSE);
    KbdOldChar = 0;
}

void KbdDeInit(void)
{
    HInput = INVALID_HANDLE_VALUE;
}

int sk_kbhit(void)
{
    int iKey = 0;
    INPUT_RECORD irBuffer;
    DWORD pcRead;
    
    if (key_hit != 0xFFFFFFFFUL)
    {
        return (int)key_hit;
    }
    
    memset(&irBuffer, 0, sizeof irBuffer);
    
    if (WaitForSingleObject(HInput, 0L) == 0)
    {
        ReadConsoleInput(HInput, &irBuffer, 1, &pcRead);
        if (irBuffer.EventType == KEY_EVENT &&
            irBuffer.Event.KeyEvent.bKeyDown != 0 &&
            irBuffer.Event.KeyEvent.wRepeatCount <= 1)
        {
            WORD vk, vs, uc;
            BOOL fShift, fAlt, fCtrl;
            
            vk = irBuffer.Event.KeyEvent.wVirtualKeyCode;
            vs = irBuffer.Event.KeyEvent.wVirtualScanCode;
            uc = irBuffer.Event.KeyEvent.uChar.AsciiChar;
            
            fShift = (irBuffer.Event.KeyEvent.dwControlKeyState & SHIFT_PRESSED) > 0;
            fAlt = (irBuffer.Event.KeyEvent.dwControlKeyState & LEFT_ALT_PRESSED) > 0;
            fCtrl = (irBuffer.Event.KeyEvent.dwControlKeyState & (RIGHT_CTRL_PRESSED + LEFT_CTRL_PRESSED)) > 0;
            
            if (uc == 0 || uc == 224)
            {					/* function keys */
                switch (vk)
                {
                    case 0x1b:
                        iKey = 27; /* shift-esc */
                        break;
                    case 0x1c: /* little enter */
                        iKey = 13;
                        break;
                    case 0x21:	   /* PgUp */
                        if (fCtrl)
                        {
                            vs = 0x84;	/* Ctrl+PgUp */
                        }
                        break;
                        
                    case 0x22:	   /* PgDn */
                        if (fCtrl)
                        {
                            vs = 0x76;	/* Ctrl+PgDn */
                        }
                        break;
                        
                    case 0x23:	   /* End */
                        if (fCtrl)
                        {
                            vs = 0x75;	/* Ctrl+End */
                        }
                        break;
                        
                    case 0x24:	   /* Home */
                        if (fCtrl)
                        {
                            vs = 0x77;	/* Ctrl+Home */
                        }
                        break;
                        
                    case 0x25:	   /* Left Arrow */
                        if (fCtrl)
                        {
                            vs = 0x73;	/* Ctrl+Left Arrow */
                        }
                        break;
                        
                    case 0x26:	   /* Up Arrow */
                        if (fCtrl)
                        {
                            vs = 0x8d;	/* Ctrl+Up Arrow */
                        }
                        break;
                        
                    case 0x27:	   /* Right Arrow */
                        if (fCtrl)
                        {
                            vs = 0x74;	/* Ctrl+Right Arrow */
                        }
                        break;
                        
                    case 0x28:	   /* Down Arrow */
                        if (fCtrl)
                        {
                            vs = 0x91;	/* Ctrl+Down Arrow */
                        }
                        break;
                        
                    case 0x70:	   /* F-Keys */
                    case 0x71:
                    case 0x72:
                    case 0x73:
                    case 0x74:
                    case 0x75:
                    case 0x76:
                    case 0x77:
                    case 0x78:
                    case 0x79:
                        if (fAlt)
                        {
                            vs += 0x2d;  /* Alt+F-Key */
                        }
                        else if (fShift)
                        {
                            vs += 0x19;  /* Shift+F-Key */
                        }
                        break;
                }
                
                if (vk > 0x20 && vk < 0x92)  /* If it's OK use scan code */
                {
                    iKey = vs << 8;
                }
            }
            else
            {
                if (fAlt)		/* Alt+Key */
                {
                    iKey = vs << 8;
                }
                else if (fCtrl) /* Ctrl+Key */
                {
                    iKey = vk & 0xbf;
                }
                else
                {
                    iKey = uc;
                }
            }
        }
    }
    
    if (iKey != 0)
    {
        key_hit = iKey;
    }
    
    return (int)iKey;
}

int nt_getch(void)
{
    int iKey;

    if (KbdOldChar)
    {
        iKey = KbdOldChar;
        KbdOldChar = 0;
        return iKey;
    }

    while (key_hit == 0xFFFFFFFFUL)
    {
        sk_kbhit();
    }
    KbdOldChar = (key_hit >> 8) & 0xff;
    iKey = key_hit & 0xff;
    key_hit = 0xFFFFFFFFUL;
    return (int)iKey;
}
#else

#include <conio.h>

int sk_kbhit(void)
{
    return kbhit();
}

int nt_getch(void)
{
    return getch();
}

void KbdInit(void)
{
}

void KbdDeInit(void)
{
}
#endif
