#include <stdio.h>
#include <string.h>

#include "pkt_obj.h"
#include "general.h"
#include "screen.h"
#include "scrsaver.h"
#include "shell.h"
#include "files.h"
#include "keyb.h"
#include "readmail.h"
#include "vars.h"

#define READ_BUF_SIZE 2048

void freq(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char buf[256],fname[256],info;
    char freqs[130];
    int len,slen,num,max,frequests,n;

    FILE *Freq;


    save_scr(&cx,&cy,&oldscr);
    if ((pkt->allow_freq) && (pkt->max_freqs > 0))
    {
        if (!try_open_reply())
        {
            old_scr(cx,cy,&oldscr);
            return;
        }
        memset(freqs,0,10*13);
        sprintf(fname,"%s%s.req",setup.replypath,pktname);
#ifdef __linux__
        if (search_ign_file(fname) != NULL)
#endif
        {
            Freq = FileOpen(fname,"rb");
            if (Freq != NULL)
            {
                fread(freqs,1,10*13,Freq);
                fclose(Freq);
            }
        }
        len = strlen(lang[176])+11;
        slen = strlen(lang[175]);
        if (slen < len) slen = len;
        slen /= 2;

        max = pkt->max_freqs;
        if (max > 10) max = 10;

        draw_shaded_box(scrwidth/2-slen-3,scrsize/2-6,scrwidth/2+slen+3,scrsize/2-5+max,color[col_box_frame],color[col_box_title],NULL);
        sprintf(buf," %s ",lang[175]);
        cmiddle(scrsize/2-5+max,buf,color[col_box_title]);

        n = 0;
        for (num=1; num<=max; num++)
        {
            sprintf(buf,lang[176],num);
            cwritexy(scrwidth/2-len/2,scrsize/2-6+num,buf,color[col_box_text]);
            if (freqs[(num-1)*13] != '\0')
                cwritexy(scrwidth/2+len/2-11-(slen & 1),scrsize/2-6+num,(char *) &freqs[(num-1)*13],color[col_box_hilight]);
            else if (n == 0) n = num;
        }
        num = n == 0 ? 1 : n;

        while (num > 0)
        {
            info = get_string(scrwidth/2+len/2-11-(slen & 1),scrsize/2-6+num,12,12,(char *) &freqs[(num-1)*13],13,color[col_box_hilight],color[col_box_text],color[col_box_scroll]);
            switch (info)
            {
                case 0:
                case 1:
                    if (num < max) num++; else num = 1;
                    break;
                case 2:
                    if (num == 1) num = max; else num--;
                    break;
                case 3:
                    frequests = 0;
                    for (num=1; num<=max; num++)
                        if (freqs[(num-1)*13] != 0)
                        {
                            if ((num > 1) && (num != frequests))
                                strcpy((char *) &freqs[frequests*13],(char *) &freqs[(num-1)*13]);
                            frequests++;
                        }

                    if (frequests == 0)
                        remove(fname);
                    else
                        if ((Freq = FileOpen(fname,"wb")) != NULL)
                        {
                            fwrite(freqs,1,frequests*13,Freq);
                            fclose(Freq);
                        }
                    num = 0;
                    break;
                case 5:
                    num = 0;
                    break;
            }
        }
    }
    else
    {
        slen = strlen(lang[177])/2;
        draw_shaded_box(scrwidth/2-slen-2,scrsize/2-2,scrwidth/2+slen+2,scrsize/2+2,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(scrsize/2,lang[177],color[col_warn_hilight]);
        try_key(2);
    }
    old_scr(cx,cy,&oldscr);
}

static char ansitab[8] = {0,4,2,6,1,5,3,7};

int write_ansi(char *buf, int col, int ypos)
{
    char ansi,ansistr[256],c;
    unsigned num,params,xp;
    int paramarr[50], ansipos;
    char *sstr,*pstr;

    ansi = 0; xp = 1; ansipos = 0;
    while (*buf != 0)
    {
        if (ansi)
        {
            c = *buf;
            ansistr[ansipos] = *buf;
            ansipos++;
            if (ansipos == 1) {
                if (c != '[') ansi = 0;
                buf++;
                continue;
            }
            if (((c >= '0') && (c <= '9')) || (c == '?') || (c == ';') || (c == '=')) {
                buf++;
                continue;
            }

            memmove(ansistr,ansistr+1,ansipos-2); ansistr[ansipos-2] = 0;
            params = 0;
            pstr = ansistr;
            sstr = (char *) 1;
            while ((sstr != NULL) && (params < 50))
            {
                if ((sstr = strchr(pstr,';')) != NULL)
                    *sstr = 0;
                if  ((*pstr == '=') || (*pstr == '?')) pstr++;
                if (sscanf(pstr,"%d",&paramarr[params]) == 1) params++;
                pstr = sstr+1;
            }

            switch (c)
            {
                case 'C':
                    if (params == 0) num = 1; else num = paramarr[0];
                    if (xp+num > scrwidth) xp = scrwidth; else xp += num;
                    break;
                case 'm':
                    for (num=0; num<params; num++)
                    {
                        switch (paramarr[num])
                        {
                            case 0:
                                col = 7;
                                break;
                            case 1:
                                col |= 8;
                                break;
                            case 5:
                                col |= 128;
                                break;
                            case 7:
                                col = 7 << 4;
                                break;
                            case 8:
                                col = 0;
                                break;
                            case 30:
                            case 31:
                            case 32:
                            case 33:
                            case 34:
                            case 35:
                            case 36:
                            case 37:
                                col &= 248;
                                col |= ansitab[paramarr[num]-30];
                                break;
                            case 40:
                            case 41:
                            case 42:
                            case 43:
                            case 44:
                            case 45:
                            case 46:
                            case 47:
                                col &= 15+128;
                                col |= ansitab[paramarr[num]-40] << 4;
                                break;
                        }
                    }
                    break;
            }
            ansi = 0; ansipos = 0;
        }
        else
        {
            if (*buf == 27)
                ansi = 1;
            else
            {
                writechr(xp,ypos+1,*buf,(char) col);
                xp++;
                if (xp > scrwidth) break;
            }
        }
        buf++;
    }
    return col;
}

void show_file(char newfiles, char *name)
{
    unsigned short cx,cy;
    char *oldscr;

    char fname[256],buf[256],quit,ch,ansifile;
    unsigned xpos,slen,col;
    unsigned ypos,num,old_len,oldwidth;

    old_len = pkt->txt_length; oldwidth = scrwidth;
    pkt->txt_length = 255; 
    save_scr(&cx,&cy,&oldscr); scrwidth = 255;
    quit = 0;
    if (newfiles)
    {
        switch (fmt)
        {
            case format_bw:
                sprintf(buf, "%snewfiles.*", setup.workpath);
                strcpy(fname, setup.workpath);
                if (findfile(buf, fname+strlen(fname)) == NULL)
                    goto __notfound;
                break;
            case format_hippo:
            case format_qwk:
                strcat(strcpy(fname,setup.workpath),"newfiles.dat");
                break;
            case format_omen:
                sprintf(fname,"%snfile%s.bbs",setup.workpath,omentag);
                break;
        }

#ifdef __linux__
        search_ign_file(fname);
#endif
        if (!pkt->init_replytext(pkt, fname))
        {
        __notfound:
            pkt->txt_length = old_len;
            scrwidth = oldwidth;
            slen = strlen(lang[178])/2;
            draw_shaded_box(scrwidth/2-slen-2,7,scrwidth/2+slen+2,11,color[col_info_frame],color[col_info_title],NULL);
            cmiddle(9,lang[178],color[col_info_hilight]);
            try_key(2);
            freq();
            quit = 1;
        }
    }
    else
    {
#ifdef __linux__
        search_ign_file(name);
#endif
        if (!pkt->init_replytext(pkt, name))
        {
            scrwidth = oldwidth;
            pkt->txt_length = old_len;
            slen = strlen(lang[179])/2;
            draw_shaded_box(scrwidth/2-slen-2,7,scrwidth/2+slen+2,11,color[col_info_frame],color[col_info_title],NULL);
            cmiddle(9,lang[179],color[col_info_hilight]);
            try_key(2);
            quit = 1;
        }
        strcpy(fname,name);
    }
    scrwidth = oldwidth;
    pkt->txt_length = old_len;

    if (!quit)
    {
        showclock = 0;
        tclrscr();
        tbar(1,1,scrwidth,1,(1<<4)+15);
        tbar(1,scrsize,scrwidth,scrsize,(1<<4)+15);
        fname[scrwidth] = 0;
        xpos = 0; ypos = 1;
        cwritexy(1,1,fname,(1<<4)+15);
        cwritexy(1,scrsize,"Row:       Col:",(1<<4)+7);
        if (newfiles)
        {
            cwritexy(scrwidth-22,scrsize,"<     > Request files",(1<<4)+7);
            cwritexy(scrwidth-21,scrsize,"Alt-R",(1<<4)+15);
        }
        sprintf(buf,"%4d",ypos);
        cwritexy(6,scrsize,buf,(1<<4)+15);
        sprintf(buf,"%3d",xpos+1);
        cwritexy(17,scrsize,buf,(1<<4)+15);
        col = 7;
        ansifile = newfiles && pkt->ansi_newfiles;

        if (ansifile)
        {
            for (ypos=1; ypos<scrsize-1; ypos++)
            {
                pkt->read_replyline(pkt, buf,ypos);
                col = write_ansi(buf,col,ypos);
                if (ypos == pkt->txt_lines) break;
            }
        }
        else
        {
            for (ypos=1; ypos<scrsize-1; ypos++)
            {
                pkt->read_replyline(pkt, buf,ypos);
                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                cwritexy(1,ypos+1,buf+xpos,7);
                if (ypos == pkt->txt_lines) break;
            }
        }
        ypos = 1; quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = sk_getch();
                switch (ch)
                {
                    case 27:
                        quit = 1;
                        break;
                    case 0:
                        ch = sk_getch();
                        switch (ch)
                        {
                            case '$':
                                shell_dos(); break;
                            case 19:
                                if (newfiles) freq();
                                break;
                            case 'M':
                                /* Right */
                                if ((!ansifile) && (xpos < 255-scrwidth))
                                {
                                    xpos += 8;
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    for (num=0; num<scrsize-2; num++)
                                    {
                                        pkt->read_replyline(pkt, buf,ypos+num);
                                        if (strlen(buf) > xpos)
                                        {
                                            if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                            cwritexy(1,num+2,buf+xpos,7);
                                        }
                                        if (num+1 == pkt->txt_lines) break;
                                    }
                                    sprintf(buf,"%3i",xpos+1);
                                    cwritexy(17,scrsize,buf,(1<<4)+15);
                                }
                                break;
                            case 'K':
                                /* Left */
                                if ((!ansifile) && (xpos > 0))
                                {
                                    xpos -= 8;
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    for (num=0; num<scrsize-2; num++)
                                    {
                                        pkt->read_replyline(pkt, buf,ypos+num);
                                        if (strlen(buf) > xpos)
                                        {
                                            if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                            cwritexy(1,num+2,buf+xpos,7);
                                        }
                                        if (num+1 == pkt->txt_lines) break;
                                    }
                                    sprintf(buf,"%3i",xpos+1);
                                    cwritexy(17,scrsize,buf,(1<<4)+15);
                                }
                                break;
                            case 'P':
                                /* Down */
                                if (ypos < pkt->txt_lines)
                                {
                                    ypos++;
                                    scroll_up(1,2,scrwidth,scrsize-1);
                                    tbar(1,scrsize-1,scrwidth,scrsize-1,7);
                                    if (ypos+scrsize-3 <= pkt->txt_lines)
                                    {
                                        pkt->read_replyline(pkt, buf,ypos+scrsize-3);
                                        if (ansifile)
                                            col = write_ansi(buf,col,scrsize-2);
                                        else
                                            if (strlen(buf) > xpos)
                                            {
                                                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                                cwritexy(1,scrsize-1,buf+xpos,7);
                                            }
                                    }
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                            case 'H':
                                /* Up */
                                if (ypos > 1)
                                {
                                    ypos--;
                                    scroll_down(1,2,scrwidth,scrsize-1);
                                    tbar(1,2,scrwidth,2,7);
                                    pkt->read_replyline(pkt, buf,ypos);
                                    if (ansifile)
                                        col = write_ansi(buf,col,1);
                                    else
                                        if (strlen(buf) > xpos) {
                                            if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                            cwritexy(1,2,buf+xpos,7);
                                        }
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                            case 'G':
                                if (ypos > 1)
                                {
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    for (ypos=1; ypos<scrsize-1; ypos++) {
                                        pkt->read_replyline(pkt, buf,ypos);
                                        if (ansifile)
                                            col = write_ansi(buf,col,ypos);
                                        else
                                            if (strlen(buf) > xpos) {
                                                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                                cwritexy(1,ypos+1,buf+xpos,7);
                                            }
                                        if (ypos == pkt->txt_lines) break;
                                    }
                                    ypos = 1;
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                            case 'I':
                                if (ypos > 1) {
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    if (ypos <= scrsize-3)
                                        ypos = 1;
                                    else
                                        ypos -= scrsize-3;

                                    for (num=0; num<scrsize-2; num++) {
                                        pkt->read_replyline(pkt, buf,ypos+num);
                                        if (ansifile)
                                            col = write_ansi(buf,col,num+1);
                                        else
                                            if (strlen(buf) > xpos) {
                                                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                                cwritexy(1,num+2,buf+xpos,7);
                                            }
                                        if (num+1 == pkt->txt_lines) break;
                                    }
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                            case 'Q':
                                if (ypos+scrsize-3 < pkt->txt_lines) {
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    ypos += scrsize-3;
                                    for (num=0; num<scrsize-2; num++) {
                                        pkt->read_replyline(pkt, buf,ypos+num);
                                        if (ansifile)
                                            col = write_ansi(buf,col,num+1);
                                        else
                                            if (strlen(buf) > xpos)
                                            {
                                                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                                cwritexy(1,num+2,buf+xpos,7);
                                            }
                                        if (num+1 == pkt->txt_lines) break;
                                    }
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                            case 'O':
                                if (ypos+scrsize-3 < pkt->txt_lines)
                                {
                                    tbar(1,2,scrwidth,scrsize-1,7);
                                    ypos = pkt->txt_lines-(scrsize-2)+1;
                                    for (num=0; num<scrsize-2; num++)
                                    {
                                        pkt->read_replyline(pkt, buf,ypos+num);
                                        if (ansifile)
                                            col = write_ansi(buf,col,num+1);
                                        else
                                            if (strlen(buf) > xpos)
                                            {
                                                if (scrwidth+xpos < 255) buf[scrwidth+xpos] = 0;
                                                cwritexy(1,num+2,buf+xpos,7);
                                            }
                                        if (num+1 == pkt->txt_lines) break;
                                    }
                                }
                                sprintf(buf,"%4i",ypos);
                                cwritexy(6,scrsize,buf,(1<<4)+15);
                                break;
                        }
                        break;
                }
            } else give_timeslice();
        }
        pkt->deinit_replytext(pkt);
        showclock = 1;
    }
    old_scr(cx,cy,&oldscr);
}
