#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "screen.h"
#include "vars.h"
#include "keyb.h"
#include "list.h"
#include "openmail.h"
#include "general.h"
#include "scrolbox.h"
#include "files.h"
#include "scrsaver.h"
#include "readmail.h"
#include "shell.h"

#ifndef __linux__
#  define ACS_VLINE 179
#  define CHECK ''
#else
#  define CHECK 'x'
#endif

PACKET_REC *first_frec;
PACKET_REC *last_frec;
PACKET_REC *frec;

static unsigned current_frec,frecs;

int get_frec(unsigned pos)
{
    if (pos == 1)
    {
        current_frec = 1;
        frec = first_frec;
    }

    if (pos == frecs)
    {
        current_frec = frecs;
        frec = last_frec;
    }

    while (current_frec < pos)
    {
        frec = frec->next;
        if (frec == NULL)
        {
            current_frec = frecs;
            frec = last_frec;
            return 0;
        }
        current_frec++;
    }

    while (current_frec > pos)
    {
        frec = frec->prev;
        if (frec == NULL)
        {
            current_frec = frecs;
            frec = last_frec;
            return 0;
        }
        current_frec--;
    }

    return 1;
}

void draw_line(unsigned ypos, unsigned pos)
{
    char col;
    char tmp[256],shname[7];
#ifdef LONG_NAMES
    char ch;
#endif

    tbar(1,scrsize,80,scrsize,color[col_background]);
    tbar(4,ypos,77,ypos,color[col_pkt_filename]);

    if (get_frec(pos) == 0) return;

    if (frec->infrec > 0)
    {
        fseek(Finf,(frec->infrec-1)*sizeof(pkt_type),SEEK_SET);
        fread(&packet,sizeof(pkt_type),1,Finf);
        if (packet.open)
        {
            col = color[col_pkt_opened];
        }
        else
        {
            col = color[col_pkt_filename];
        }
    }
    else
    {
        col = color[col_pkt_filename];
    }

#ifdef LONG_NAMES
    ch = frec->name[8]; frec->name[8] = '\0';
    cwritexy(5,ypos,frec->name,col);
    frec->name[8] = ch;

    ch = frec->ext[3]; frec->ext[3] = '\0';
    cwritexy(14,ypos,frec->ext,col);
    frec->ext[3] = ch;
#else
    cwritexy(5,ypos,frec->name,col);
    cwritexy(14,ypos,frec->ext,col);
#endif
    cwritexy(20,ypos,dtstr(tmp,frec->time),color[col_pkt_date]);
    writechr(47,ypos,ACS_VLINE,color[col_pkt_frame]);

    if (frec->size == (unsigned long) -1)
    {
        /* .size == -1 == Directory */
        cwritexy(41,ypos,"<DIR>",color[col_pkt_size]);
    }
    else
    {
        sprintf(tmp,"%10lu",frec->size);
        cwritexy(36,ypos,tmp,color[col_pkt_size]);
    }

    if (frec->infrec < 1)
    {
        /* No information available about file */
#ifdef __linux__
        for (ch=49; ch<=53; ch++) writechr(ch,ypos,ACS_HLINE,color[col_pkt_unknown]);
        for (ch=55; ch<=59; ch++) writechr(ch,ypos,ACS_HLINE,color[col_pkt_unknown]);
        for (ch=61; ch<=64; ch++) writechr(ch,ypos,ACS_HLINE,color[col_pkt_unknown]);
        for (ch=67; ch<=71; ch++) writechr(ch,ypos,ACS_HLINE,color[col_pkt_unknown]);
        for (ch=73; ch<=76; ch++) writechr(ch,ypos,ACS_HLINE,color[col_pkt_unknown]);
#else
        cwritexy(49,ypos,"     ",color[col_pkt_unknown]);
#endif
    }
    else
    {
        sprintf(tmp,"%5u",packet.total);
        cwritexy(49,ypos,tmp,color[col_pkt_total]);
        sprintf(tmp,"%5u",packet.personal);
        cwritexy(55,ypos,tmp,color[col_pkt_personal]);
        sprintf(tmp,"%3d%%",packet.unread);
        cwritexy(61,ypos,tmp,color[col_pkt_read]);
        switch (packet.fmt)
        {
            case format_qwk: strcpy(shname,"QWK  "); break;
            case format_bw: strcpy(shname,"Bwave"); break;
            case format_hippo: strcpy(shname,"Hippo"); break;
            case format_omen: strcpy(shname,"OMEN "); break;
            case format_soup: strcpy(shname,"SOUP "); break;
        }
        cwritexy(67,ypos,shname,color[col_pkt_format]);
        if (frec->replypkt)
            cwritexy(73,ypos,"Yes",color[col_pkt_ulpacket]);
        else
            cwritexy(73,ypos,"No ",color[col_pkt_ulpacket]);

        cwritexy(1,scrsize,packet.pkt_note,color[col_background]);
    }
}

int check_filemask(char *fname)
{
    char *strp;

    /* If extension is 000..999, it's ok. */
    strp = strrchr(fname,'.');
    if (strp != NULL)
    {
        if (isdigit(*(strp+1)) && isdigit(*(strp+2)) && isdigit(*(strp+3))) return 1;
    }

    return compare_filenames(fname,setup.msgpktmask);
}

int list_comp(PACKET_REC *prev, struct stat *statbuf, char *fname)
{
    int comp;
    char *ext,name[256],nul = '\0';

    switch (setup.packetsort)
    {
        case PKTSORT_DATE:
            if (ISDIR(statbuf))
            {
                if (prev->next == NULL || prev->next->size == (unsigned long) -1) goto __name;
            }
            else
            {
                if (prev->size != (unsigned long) -1 && prev->time >= *ST_MTIME(statbuf) &&
                    (prev->next == NULL || prev->next->time < *ST_MTIME(statbuf) ||
                     prev->next->size == (unsigned long) -1))
                {
                    return 1;
                }
            }
            break;
        case PKTSORT_NAME:
        __name:
            if (ISDIR(statbuf))
            {
                if (prev->next != NULL && prev->next->size != (unsigned long) -1) return 0;
                if (prev->size != (unsigned long) -1)
                {
                    comp = 1;
                }
                else
                {
                    strcpy(name,prev->name);
                    if (prev->ext[0] != '\0') sprintf(name+strlen(name),".%s",prev->ext);
                    comp = stricmp(name, fname);
                }
            }
            else
            {
                if (prev->size == (unsigned long) -1) return 0;
                strcpy(name,prev->name);
                if (prev->ext[0] != '\0') sprintf(name+strlen(name),".%s",prev->ext);
                comp = stricmp(name, fname);
                if (comp == 0) goto __ext;
            }
            if (prev->next != NULL)
            {
                strcpy(name,prev->next->name);
                if (prev->next->ext[0] != '\0') sprintf(name+strlen(name),".%s",prev->next->ext);
            }
            if (comp < 0 && (prev->next == NULL || (!ISDIR(statbuf) && prev->next->size == (unsigned long) -1) ||
                             stricmp(name, fname) > 0)) return 1;
            break;
        case PKTSORT_EXT:
        __ext:
            if (ISDIR(statbuf))
            {
                if (prev->next == NULL || prev->next->size == (unsigned long) -1) goto __name;
            }
            else
            {
                if (prev->size == (unsigned long) -1) return 0;

                ext = strrchr(fname,'.');
                if (ext == NULL) ext = &nul; else ext++;

                comp = stricmp(ext, prev->ext);
                if (comp <= 0 && (prev->next == NULL || prev->next->size == (unsigned long) -1 ||
                                  stricmp(ext, prev->next->ext) > 0)) return 1;
                if (comp == 0)
                {
                    comp = stricmp(prev->name, fname);
                    if (comp < 0 && (prev->next == NULL || prev->next->size == (unsigned long) -1 ||
                                     stricmp(prev->next->name, fname) > 0)) return 1;
                }
            }
            break;
    }
    return 0;
}

int add_list(struct stat *statbuf, char *fname)
{
    PACKET_REC *prev,*next;

    prev = first_frec;
    next = NULL;
    while (prev != NULL)
    {
        if (list_comp(prev,statbuf,fname))
        {
            next = prev->next;
            break;
        }
        prev = prev->next;
    }

    frec = (PACKET_REC *) malloc(sizeof(PACKET_REC));

    if (frec == NULL)
    {
        /* Not enough memory */
        return 0;
    }

    if (prev == NULL)
    {
        if (first_frec == NULL)
        {
            /* First record */
            first_frec = frec;
            last_frec = frec;
        }
        else
        {
            if (!list_comp(first_frec,statbuf,fname))
            {
                /* Place record to first */
                next = first_frec;
                first_frec->prev = frec;
                first_frec = frec;
            }
            else
            {
                /* Place record to last */
                prev = last_frec;
                last_frec->next = frec;
                last_frec = frec;
            }
        }
    }
    else
    {
        if (next == NULL)
        {
            /* Place record to last */
            prev = last_frec;
            last_frec->next = frec;
            last_frec = frec;
        }
        else
        {
            next->prev = frec;
            prev->next = frec;
        }
    }

    memset(frec,0,sizeof(PACKET_REC));
    frec->prev = prev;
    frec->next = next;

    return 1;
}

/* Search files from download path */
int get_files(void)
{
    char *strp,tmp[256];

    DIR *dirp;
    struct stat *statbuf;

    strcpy(tmp, downpath); tmp[strlen(tmp)-1] = '\0';
    dirp = OpenDir(tmp);

    first_frec = NULL;
    last_frec = NULL;
    frec = NULL;

    frecs = 0;
    for (;;)
    {
        struct dirent *d;
        if (dirp == NULL) break;

        d = readdir(dirp);
        if (d == NULL) break;

        if (d->d_name[0] != '.' || d->d_name[1] != '\0')
        {
            /* Not a '.' directory */
            sprintf(tmp, "%s%s", downpath, d->d_name);
            if (FileStat(tmp, &statbuf) == 0)
            {
                if (ISDIR(statbuf) || check_filemask(d->d_name))
                {
                    /* OK to display file.. */
                    if (!add_list(statbuf,d->d_name))
                    {
                        /* Not enough memory */
                        return frecs;
                    }

                    if (d->d_name[0] != '.' || d->d_name[1] != '.' || d->d_name[2] != '\0')
                    {
                        /* Not a '..' directory, so get extension */
                        strp = strrchr(d->d_name,'.');
                        if (strp != NULL)
                        {
                            strcpy(frec->ext,strp+1);
                            *strp = '\0';
                        }
                    }
                    strcpy(frec->name,d->d_name);

                    frec->time = *ST_MTIME(statbuf);
                    if (ISDIR(statbuf))
                    {
                        /* Subdir, size = -1 */
                        frec->size = (unsigned long) -1;
                    }
                    else
                    {
                        /* File, save size */
                        frec->size = ST_SIZE(statbuf);
                    }
                    frec->infrec = 0;
                    frecs++;
                }
            }
            free(statbuf);
        }
    }

    /* Get opened packets */
    /*fseek(Finf,0,SEEK_END);
    n2 = ftell(Finf) / sizeof(pkt_type);
    fseek(Finf,0,SEEK_SET);
    for (num=1; num<=n2; num++)
    {
        if (fread(&packet,1,sizeof(pkt_type),Finf))
        {
            if (packet.open)
            {
                if ((pstr = strrchr(packet.fname,'.')) == NULL)
                {
                    strcpy(frecs[pos].name,packet.fname);
                    frecs[pos].ext[0] = 0;
                }
                else
                {
                    strcpy(frecs[pos].ext,pstr+1);
                    spos = (pstr-packet.fname);
                    packet.fname[spos] = 0;
                    strcpy(frecs[pos].name,packet.fname);
                }
                frecs[pos].time = packet.time;
                frecs[pos].size = packet.size;
                frecs[pos].infrec = -1;

                sprintf(tmp,"%s%s.___",setup.packetpath,frecs[pos].name);
                if ((F = FileOpen(tmp,"rb")) != NULL)
                {
                    fseek(F,0,SEEK_END);
                    n3 = ftell(F) / sizeof(packet_index);
                    fseek(F,0,SEEK_SET);
                    for (n4=1; n4<=n3; n4++)
                    {
                        fread(&pktidx,sizeof(packet_index),1,F);
                        if (packet.pktnumber == pktidx.packet)
                        {
                            pos++;
                            break;
                        }
                    }
                    fclose(F);
                }
            }
        }
    }*/

    current_frec = 1;
    frec = first_frec;

    return frecs;
}

/* Get information about mail packets */
void get_files_info(void)
{
    unsigned inf_pos;
    int found,writeit;
    char str[256],ext[4];
    long fsize;

    fseek(Finf,0,SEEK_SET);

    inf_pos = 0;
    while (fread(&packet,sizeof(pkt_type),1,Finf))
    {
        inf_pos++;
        found = 0;
        writeit = 0;

        frec = first_frec;
        while (frec != NULL)
        {
            if (frec->ext[0] == '\0')
            {
                /* No extension */
                strcpy(str,frec->name);
            }
            else
            {
                sprintf(str,"%s.%s",frec->name,frec->ext);
            }

            /* Names match? */
            if (stricmp(packet.fname,str) == 0)
            {
                /* Sizes match? */
                if (packet.size == frec->size)
                {
                    /* Found! */
                    if (packet.open && frec->infrec == 0)
                    {
                        packet.open = 0;
                        writeit = 1;
                    }
                    frec->infrec = inf_pos;

                    /* Check if reply packet exists */
                    if (packet.fmt != format_omen)
                    {
                        /* Not OMEN packet */
                        switch (packet.fmt)
                        {
                            case format_qwk: strcpy(ext,"rep"); break;
                            case format_bw: strcpy(ext,"new"); break;
                            case format_hippo: strcpy(ext,"hra"); break;
                            case format_soup: strcpy(ext,"rep"); break;
                        }
                        sprintf(str,"%s%s.%s",setup.uppath,packet.replypkt,ext);
                    }
                    else
                    {
                        /* OMEN packet */
                        sprintf(str,"%sreturn%c%c.*",setup.uppath,packet.fname[4],packet.fname[5]);
                    }

                    frec->replypkt = exists(str) > 0;
                    found = 1;
                }
                break;
            }
            frec = frec->next;
        }

        if (!found)
        {
            /* Not found, mark file as deleted */
            packet.fname[0] = '\0';
            writeit = 1;
        }

        if (writeit)
        {
            /* File record should be updated.. */
            fseek(Finf,sizeof(pkt_type)*(inf_pos-1),SEEK_SET);
            fwrite(&packet,sizeof(pkt_type),1,Finf);
            fseek(Finf,sizeof(pkt_type)*inf_pos,SEEK_SET);
        }
    }

    fflush(Finf);

    /* Get file size */
    fseek(Finf,0,SEEK_END);
    fsize = ftell(Finf);

    found = 0;
    inf_pos = 1;

    /* Totally FileRemove 'deleted' records from packet.inf */
    for (;;)
    {
        fseek(Finf,(inf_pos-1)*sizeof(pkt_type),SEEK_SET);
        if (!fread(&packet,sizeof(pkt_type),1,Finf)) break;

        if (packet.fname[0] == '\0')
        {
            /* Record marked as deleted */
            found = 1;
            delete_space(Finf,(inf_pos-1)*sizeof(pkt_type),sizeof(pkt_type),fsize);
            fsize -= sizeof(pkt_type);
            if (fsize < 0) fsize = 0;
            ftrunc(Finf,fsize);

            /* Update 'frec' list */
            frec = first_frec;
            while (frec != NULL)
            {
                if (frec->infrec > inf_pos) frec->infrec--;
                frec = frec->next;
            }

            /* End of file now.. */
            if (fsize <= (long) ((inf_pos-1)*sizeof(pkt_type))) break;
        }
        else
        {
            inf_pos++;
        }
    }

    current_frec = 1;
    frec = first_frec;
}

int delete_packet(SCROLL_BOX *scrbox)
{
    unsigned short ox,oy;
    char *oldscr;
    unsigned long num,fsize;

    int st,ch;
    int isreply,mail,reply,len;
    char replypkt[13],tmp[256],tmp2[256];

    FILE *F;

    if (get_frec(scrbox->ypos+scrbox->upy) == 0) return 0;

    if (frec->size == (unsigned long) -1)
    {
        err_box(lang[275]);
        return 0;
    }

    mail = 1; reply = 0;
    if (frec->infrec > 0)
    {
        fseek(Finf,(frec->infrec-1)*sizeof(pkt_type),SEEK_SET);
        fread(&packet,sizeof(pkt_type),1,Finf);
    }
    else
    {
        sprintf(packet.fname,"%s.%s",frec->name,frec->ext);
    }

    save_scr(&ox,&oy,&oldscr);
    if (packet.fmt == format_omen) len = 12; else len = strlen(packet.fname);
    draw_shaded_box(32-(len >> 1),10,58+(len >> 1)+(len & 1),15,
                    color[col_info_frame],color[col_info_title],lang[29]);
    st = 35-(len >> 1);

    cwritexy(st,12,"[ ]",color[col_info_text]);
    writechr(st+1,12,CHECK,color[col_info_hilight]);

    highwrite_hicol = color[col_info_hilight];
    highwrite_locol = color[col_info_text];
    keys[0] = toupper(highwrite(st+4,12,lang[30],&keypos[0]));
    cwritexy(st+strlen(lang[30])+4,12,packet.fname,color[col_info_hilight]);

    strncpy(replypkt,packet.fname,len-3); replypkt[len-3] = 0;
    if (frec->infrec > 0)
    {
        switch (packet.fmt)
        {
            case format_qwk: strcpy(ext,"rep"); strcat(replypkt,"rep"); break;
            case format_bw: strcpy(ext,"new"); strcat(replypkt,"new"); break;
            case format_hippo: strcpy(ext,"hra"); strcat(replypkt,"hra"); break;
            case format_soup: strcpy(ext,"rep"); strcat(replypkt,"rep"); break;
            case format_omen:
                ext[0] = 0;
                sprintf(replypkt,"return%c%c.*",packet.fname[4],packet.fname[5]);
                sprintf(tmp, "%s%s", setup.uppath, replypkt);
                if (findfile(tmp, tmp2) != NULL)
                {
                    strcpy(replypkt, tmp2);
                }
                break;
        }
    }

    if ((frec->infrec < 1) || (!exists(strcat(strcpy(tmp,setup.uppath),replypkt)))) {
        isreply = 0;
        highwrite_hicol = color[col_info_disabled];
        highwrite_locol = highwrite_hicol;
    } else {
        isreply = 1;
        highwrite_hicol = color[col_info_hilight];
        highwrite_locol = color[col_info_text];
    }
    cwritexy(st,13,"[ ]",highwrite_locol);
    keys[1] = toupper(highwrite(st+4,13,lang[31],&keypos[1]));

    if (frec->infrec > 0)
        cwritexy(st+strlen(lang[31])+4,13,replypkt,highwrite_hicol);
    else
        cwritexy(st+strlen(lang[31])+4,13,"(none)",color[col_info_disabled]);

    highwrite_hicol = color[col_box_hilight];
    highwrite_locol = color[col_box_text];

    keyb_keys = 2;
    do {
        ch = toupper(sk_getch());
        if (ch == 0) ch = find_key(sk_getch());

        if (ch == keys[0]) {
            mail = !mail;
            if (mail)
                writechr(st+1,12,CHECK,color[col_info_hilight]);
            else
                writechr(st+1,12,' ',color[col_info_hilight]);
            continue;
        }
        if (ch == keys[1]) {
            if (isreply) {
                reply = !reply;
                if (reply)
                    writechr(st+1,13,CHECK,color[col_info_hilight]);
                else
                    writechr(st+1,13,' ',color[col_info_hilight]);
            }
            continue;
        }
    } while ((ch != 13) && (ch != 27));
    old_scr(ox,oy,&oldscr);

    if (ch == 13) {
        if (reply)
        {
            /* Remove reply packet */
            sprintf(tmp,"%s%s",setup.uppath,replypkt);
            FileRemove(tmp);

            frec->replypkt = 0;
        }

        if (mail)
        {
            if ((frec->infrec == 0) || (!packet.open))
            {
                /* Remove mail packet */
                sprintf(tmp,"%s%s",downpath,packet.fname);
                FileRemove(tmp);
            }
            else
            {
                /* Remove opened mail packet */
                sprintf(tmp,"%s%s.___",setup.packetpath,frec->name);

                F = FileOpen(tmp,"r+b");
                if (F != NULL)
                {
                    fseek(F,0,SEEK_END);
                    fsize = ftell(F);
                    fseek(F,0,SEEK_SET);
                    num = 0;
                    while ((num*sizeof(pktidx) < fsize) && (fread(&pktidx,sizeof(packet_index),1,F)))
                    {
                        if (packet.pktnumber == pktidx.packet)
                        {
                            /* Found, FileRemove file */
                            sprintf(tmp,"%s%s",setup.packetpath,pktidx.idxname);
                            FileRemove(tmp);

                            /* Remove record */
                            delete_space(F,num*sizeof(pktidx),sizeof(pktidx),fsize);
                            fseek(F,num*sizeof(pktidx),SEEK_SET);
                            fsize -= sizeof(pktidx);
                        }
                        else
                        {
                            num++;
                        }
                    }
                    ftrunc(F,fsize);
                    fclose(F);
                }
            }

            /* Update frecs */
            if (frec == last_frec) last_frec = frec->prev;
            if (frec == first_frec) first_frec = frec->next;
            if (frec->prev != NULL) frec->prev->next = frec->next;
            if (frec->next != NULL) frec->next->prev = frec->prev;

            free(frec);
            frecs--;

            frec = first_frec;
            current_frec = 1;
        }
        return mail;
    }

    return 0;
}

void deinit_frecs(void)
{
    while (first_frec != NULL)
    {
        frec = first_frec->next;
        free(first_frec);
        first_frec = frec;
    }
}

void open_mailpacket(char *openpkt)
{
    unsigned short ox,oy;
    char *oldscr;

    char str[256],tmp[256],*pstr,ch;
    size_t slen;

    FILE *Frestart;

    SCROLL_BOX scrbox;
    unsigned pos;

    /* Check if work\~restart.sky exists */
    strcat(strcpy(tmp,setup.workpath),"~RESTART.SKY");
    strcat(strcpy(str,setup.workpath),"~RESTART.SK~");
    if (exists(tmp))
    {
        /* Exists.. Already in use by another process? */
        if (FileRename(tmp,str) == 0)
        {
            /* Nope */
            FileRename(str,tmp);
        }
        else
        {
            /* Someone is already using this work path! */
            save_scr(&ox,&oy,&oldscr);
            slen = strlen(lang[33]);
            if (strlen(lang[32]) > slen) slen = strlen(lang[32]);
            draw_shaded_box(scrwidth/2-slen/2-2,5,scrwidth/2+slen/2+2,11,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(7,lang[33],color[col_warn_text]);
            cmiddle(9,lang[32],color[col_warn_hilight]);
            if (sk_getch() == 0) sk_getch();
            old_scr(ox,oy,&oldscr);
            return;
        }
    }

    /* Check if reply path is already in use */
    sprintf(tmp,"%s*.UPL",setup.replypath);
    if (findfile(tmp, str) != NULL)
    {
        /* .UPL file found.. */
        strcat(strcpy(tmp,setup.replypath),str);
        strcat(strcpy(str,setup.replypath),"SKYREAD.$$~");
        if (exists(tmp))
        {
            /* Already in use by another process? */
            if (FileRename(tmp,str) == 0)
            {
                /* Nope. */
                FileRename(str,tmp);
            }
            else
            {
                /* Someone is already using this reply path! */
                save_scr(&ox,&oy,&oldscr);
                slen = strlen(lang[34]);
                if (strlen(lang[32]) > slen) slen = strlen(lang[32]);
                draw_shaded_box(scrwidth/2-slen/2-2,5,scrwidth/2+slen/2+2,11,color[col_warn_frame],color[col_warn_title],NULL);
                cmiddle(7,lang[34],color[col_warn_text]);
                cmiddle(9,lang[32],color[col_warn_hilight]);
                if (sk_getch() == 0) sk_getch();
                old_scr(ox,oy,&oldscr);
                return;
            }
        }
    }

    mailpktname[0] = '\0';

    /* Try to open work\~RESTART.SKY */
    sprintf(str,"%s~RESTART.SKY",setup.workpath);
    Frestart = FileOpen(str,"rb");
    if (Frestart != NULL)
    {
        /* Found */
        if (fread(mailpktname,13,1,Frestart))
        {
            fread(&arcfmt,1,1,Frestart);
            fread(&replyopen,1,1,Frestart);
            fread(&replymgr,1,1,Frestart);
            fread(&packet,sizeof(packet),1,Frestart);
        }
        fclose(Frestart);
    }

    save_scr(&ox,&oy,&oldscr);

    strcpy(downpath,setup.downpath);

    if (mailpktname[0] != 0)
    {
        /* Old mail packet found from work path, open it? */
        slen = get_max_langtext_len(35,36);
        draw_shaded_box(scrwidth/2-slen/2-2,6,scrwidth/2+slen/2+2,11,color[col_info_frame],color[col_info_title],NULL);
        cmiddle(8,lang[35],color[col_info_text]);
        cmiddle(9,lang[36],color[col_info_hilight]);

        do {
            ch = (char) toupper(sk_getch());
        } while (!((ch == toupper(lang[37][0])) || (ch == toupper(lang[37][1])) || (ch == 13)));

        if (ch != toupper(lang[37][1]))
        {
            /* Open data\packets.inf file */
            sprintf(str,"%spackets.inf",setup.datapath);
            Finf = FileOpen(str,"r+b");
            if (Finf == NULL)
            {
                /* Doesn't exist, create it */
                Finf = FileOpen(str,"w+b");
                if (Finf == NULL)
                {
                    err_box("Could not create packets.inf!");
                    return;
                }
            }

            /* Open old packet */
            old_scr(ox,oy,&oldscr);
            strncpy(pktname,mailpktname,8); pktname[strlen(mailpktname)-4] = 0;
            read_mailpacket(1);

            fclose(Finf);
            return;
        }
    }

    replyopen = 0;

    if (openpkt[0] != 0)
    {
        /* Immediately open mail packet */
        strcpy(mailpktname,openpkt);
        memset(&packet,0,sizeof(pkt_type));

        read_mailpacket(0);
        return;
    }

    /* Open data\packets.inf file */
    sprintf(str,"%spackets.inf",setup.datapath);
    Finf = FileOpen(str,"r+b");
    if (Finf == NULL)
    {
        /* Doesn't exist, create it. */
        Finf = FileOpen(str,"w+b");
        if (Finf == NULL)
        {
            err_box("Could not create packets.inf!");
            return;
        }
    }

    draw_shaded_box(3,3,78,scrsize-2,color[col_pkt_frame],color[col_pkt_title],lang[9]);
    sprintf(tmp, " %s ", lang[321]);
    cmiddle(scrsize-2, tmp, color[col_pkt_title]);

    cwritexy(5,4,lang[10],color[col_pkt_help]);
    draw_hline(3,78,5,color[col_pkt_frame]);
scan_again:

    tbar(4,6,77,scrsize-3,color[col_pkt_frame]);
    tbar(1,scrsize,80,scrsize,color[col_background]);

    /* Search mail packets from download path */
    get_files();

    if (frecs == 0)
    {
        /* No mail packets found */
        fclose(Finf);

        slen = strlen(lang[38]);
        draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,12,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(11,lang[38],color[col_warn_hilight]);
        try_key(2);

        old_scr(ox,oy,&oldscr);
        return;
    }

    if (stricmp(downpath,setup.downpath) == 0)
    {
        /* Get information about mail packets */
        get_files_info();
    }

    memset(&scrbox,0,sizeof(scrbox));
    scrbox.ypos = 1;
    scrbox.upy = 0;
    scrbox.xstart = 4;
    scrbox.xend = 77;
    scrbox.ystart = 6;
    scrbox.yend = scrsize-3;
    scrbox.lines = &frecs;

    add_key(0,'S',(SCROLL_FUNC) delete_packet,&scrbox);

    scrbox.scrollbar_color = color[col_pkt_selectbar];
    scrbox.background_color = color[col_pkt_filename];
    scrbox.draw_func = (DRAW_FUNC) draw_line;

    pos = scroll_box(&scrbox);
    deinit_scroll_box(&scrbox);

    if (pos > 0)
    {
        if (get_frec(pos) == 0) return;

        if (frec->size == (unsigned long) -1)
        {
            /* Jump to directory */
            pstr = frec->name;
            if (pstr[0] == '.' && pstr[1] == '.' && pstr[2] == 0)
            {
                /* Jump to previous directory (..) */

                /* Remove last slash */
                slen = strlen(downpath)-1;
                downpath[slen] = '\0';

                pstr = strrchr(downpath,SLASH);
                if (pstr != NULL)
                {
                    *(pstr+1) = 0;
                }
                else
                {
                    /* This was the main directory */
                    downpath[slen] = SLASH;
                }
            }
            else
            {
                /* Normal directory */
                sprintf(downpath+strlen(downpath),"%s"SSLASH,pstr);
            }

            deinit_frecs();
            goto scan_again;
        }

        /* Mail packet selected */

        sprintf(mailpktname,"%s.%s",frec->name,frec->ext);

        if (frec->infrec < 1)
        {
            /* No information about packet */
            memset(&packet,0,sizeof(pkt_type));
        }
        else
        {
            /* Read packet information */
            fseek(Finf,(frec->infrec-1)*sizeof(pkt_type),SEEK_SET);
            fread(&packet,sizeof(pkt_type),1,Finf);
        }
    }

    deinit_frecs();
    old_scr(ox,oy,&oldscr);

    fclose(Finf);

    if (pos > 0) read_mailpacket(0);
}
