#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "screen.h"
#include "files.h"
#include "general.h"
#include "shell.h"
#include "keyb.h"
#include "scrsaver.h"
#include "vars.h"

void pgp_output_box(void)
{
    int len;

    len = strlen(lang[180]);
    draw_shaded_box(scrwidth/2-(len/2)-(len & 1)-1,1,scrwidth/2+(len/2)+2,3,color[col_box_frame],0,NULL);
    cmiddle(2,lang[180],color[col_box_hilight]);
    gotoxy(1,5);
}

/* Export message to text file */
void export_msg(char *output)
{
    FILE *Fout;
    char str[256];
    unsigned line;

    /* Try to create file */
    if ((Fout = FileOpen(output,"w+t")) == NULL) return;

    /* Write message to file */
    for (line=1; line<=pkt->txt_lines; line++)
        fprintf(Fout,"%s\n",pkt->read_line(pkt, str,line));

    fclose(Fout);
}

/* Add a new key to keyring. */
void pgp_add_ring(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char oldpath[256];
    int slen;

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    unsigned drive,drives;

    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

    /* Go to PGP path */
#ifndef __NO_DRIVES__
    if (setup.PGPPath[1] == ':')
        _dos_setdrive(toupper(setup.PGPPath[0])-64,&drives);
#endif
    slen = strlen(setup.PGPPath); setup.PGPPath[slen-1] = 0;
    ChangeDir(setup.PGPPath);
    setup.PGPPath[slen-1] = SLASH;

    /* Export message text to sky_pgp.tmp */
    export_msg("sky_pgp.tmp");

    /* Run PGP */
    save_scr(&cx,&cy,&oldscr);
    tclrscr();
    pgp_output_box();
    if (swapexec("pgp.exe","-ka sky_pgp.tmp",0) == -1) err_box("Error running PGP.EXE!");
    old_scr(cx,cy,&oldscr);

    /* Delete sky_pgp.tmp */
    FileRemove("sky_pgp.tmp");

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);
}

void pgp_post_key(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char oldpath[256],userid[51],tmp[256];
    int slen,info;

    FILE *Fsrc,*Fdst;

    /* Ask user name */
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-27,13,scrwidth/2+26,17,color[col_box_frame],color[col_box_title],lang[181]);
    strcpy(userid,setup.pgp_userid); key_xpos = 0; key_xovr = 0;
    info = get_string(scrwidth/2-25,15,50,50,userid,4+128,color[col_box_text],color[col_box_hilight],0);
    if ((info == 5) || (userid[0] == 0))
    {
        slen = strlen(lang[182])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[182],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return;
    }

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    unsigned drive,drives;

    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

    /* Go to PGP path */
#ifndef __NO_DRIVES__
    if (setup.PGPPath[1] == ':')
        _dos_setdrive(toupper(setup.PGPPath[0])-64,&drives);
#endif
    slen = strlen(setup.PGPPath); setup.PGPPath[slen-1] = 0;
    ChangeDir(setup.PGPPath);
    setup.PGPPath[slen-1] = SLASH;

    /* Run PGP */
    tclrscr();
    pgp_output_box();
    sprintf(tmp,"-kxa \"%s\" sky_pgp.tmp",userid);
    if (swapexec("pgp.exe",tmp,0) == -1) err_box("Error running PGP.EXE!");
    old_scr(cx,cy,&oldscr);

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);

    if ((Fdst = FileOpen(setup.msgtxt,"a+t")) != NULL) {
        if ((Fsrc = FileOpen(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"),"rt")) != NULL) {
            fprintf(Fdst,"\n");
            while (fgets(tmp,sizeof(tmp),Fsrc) != NULL)
                fprintf(Fdst,"%s",tmp);
            fclose(Fsrc);
        }
        fclose(Fdst);
    }

    /* Delete sky_pgp.asc */
    FileRemove(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"));
}

void pgp_sign_msg(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char oldpath[256],tmp[256];
    int slen;


    /* Copy reply file to \pgp\sky_pgp.tmp */
    copyfile(setup.msgtxt,strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.tmp"));

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    unsigned drive,drives;

    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

    /* Go to PGP path */
#ifndef __NO_DRIVES__
    if (setup.PGPPath[1] == ':')
        _dos_setdrive(toupper(setup.PGPPath[0])-64,&drives);
#endif
    slen = strlen(setup.PGPPath); setup.PGPPath[slen-1] = 0;
    ChangeDir(setup.PGPPath);
    setup.PGPPath[slen-1] = SLASH;

    /* Run PGP */
    save_scr(&cx,&cy,&oldscr);
    tclrscr();
    pgp_output_box();
    sprintf(tmp,"-sta sky_pgp.tmp -u \"%s\"",setup.pgp_userid);
    if (swapexec("pgp.exe",tmp,0) == -1) err_box("Error running PGP.EXE!");
    old_scr(cx,cy,&oldscr);

    /* Delete sky_pgp.tmp */
    FileRemove("sky_pgp.tmp");

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);

    if (exists(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc")))
    {
        /* Copy sky_pgp.asc to msgtemp.txt */
        copyfile(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"),setup.msgtxt);

        /* Delete sky_pgp.asc */
        FileRemove(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"));
    }
}

void pgp_encrypt_msg(char *msg_to)
{
    unsigned short cx,cy;
    char *oldscr;

    char oldpath[256],userid[51],tmp[256];
    int slen,info;

    /* Ask recipients' name */
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-27,13,scrwidth/2+26,17,color[col_info_frame],color[col_info_title],lang[183]);
    strcpy(userid,msg_to);
    info = get_string(scrwidth/2-25,15,50,50,userid,4,color[col_info_text],color[col_info_hilight],0);
    if ((info == 5) || (userid[0] == 0))
    {
        slen = strlen(lang[182])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[182],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return;
    }

    /* Copy reply file to \pgp\sky_pgp.tmp */
    copyfile(setup.msgtxt,strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.tmp"));

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    unsigned drive,drives;

    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

   /* Go to PGP path */
#ifndef __NO_DRIVES__
    if (setup.PGPPath[1] == ':')
        _dos_setdrive(toupper(setup.PGPPath[0])-64,&drives);
#endif
    slen = strlen(setup.PGPPath); setup.PGPPath[slen-1] = 0;
    ChangeDir(setup.PGPPath);
    setup.PGPPath[slen-1] = SLASH;

    /* Run PGP */
    tclrscr();
    pgp_output_box();
    sprintf(tmp,"-sea sky_pgp.tmp %s -u \"%s\"",userid,setup.pgp_userid);
    if (swapexec("pgp.exe",tmp,0) == -1) err_box("Error running PGP.EXE!");
    old_scr(cx,cy,&oldscr);

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);

    /* Delete sky_pgp.tmp */
    FileRemove(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.tmp"));

    if (exists(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc")))
    {
        /* Copy sky_pgp.asc to msgtemp.txt */
        copyfile(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"),setup.msgtxt);

        /* Delete sky_pgp.asc */
        FileRemove(strcat(strcpy(tmp,setup.PGPPath),"sky_pgp.asc"));
    }
}

/* Decrypt PGP message */
void pgp_decrypt_msg(void) {
    unsigned short cx,cy;
    char *oldscr;

    char oldpath[256],tmp[256];
    int slen;

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    unsigned drive,drives;

    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

    /* Go to PGP path */
#ifndef __NO_DRIVES__
    if (setup.PGPPath[1] == ':')
        _dos_setdrive(toupper(setup.PGPPath[0])-64,&drives);
#endif
    slen = strlen(setup.PGPPath); setup.PGPPath[slen-1] = 0;
    ChangeDir(setup.PGPPath);
    setup.PGPPath[slen-1] = SLASH;

    /* Export message text to sky_pgp.tmp */
    export_msg("sky_pgp.tmp");

    /* Run PGP */
    save_scr(&cx,&cy,&oldscr);
    tclrscr();
    pgp_output_box();
    sprintf(tmp,"sky_pgp.tmp -o %ssky_pgp.tmp",setup.replypath);
    if (swapexec("pgp.exe",tmp,0) == -1) err_box("Error running PGP.EXE!");
    old_scr(cx,cy,&oldscr);

    /* Delete sky_pgp.tmp */
    FileRemove("sky_pgp.tmp");

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);
}

/* PGP options box */
char pgp_options(char pgpopts, char reply, int aflags) {
    unsigned short cx,cy;
    char *oldscr;

    int oldkeys[sizeof(keys)],oldkeypos[sizeof(keypos)],oldkeyb_keys;
    int quit,slen;
    char ch;

    /* Save old keyb_keys, keys[] and keypos[] variables */
    memcpy(oldkeys,keys,sizeof(oldkeys));
    memcpy(oldkeypos,keypos,sizeof(oldkeypos));
    oldkeyb_keys = keyb_keys;

    /* Draw "PGP Options" box */
    save_scr(&cx,&cy,&oldscr);
    slen = get_max_langtext_len(184,188);
    draw_shaded_box(10,10,10+slen+2,15,color[col_box_frame],color[col_box_title],lang[184]);
    keys[0] = toupper(highwrite(12,11,lang[185],&keypos[0]));
    keys[1] = toupper(highwrite(12,12,lang[186],&keypos[1]));

    /* Disable "Sign and Encrypt message" in echo areas */
    if ((aflags & TYPE_ECHO) && ((aflags & TYPE_INET) == 0) && ((aflags & TYPE_NET) == 0))
    {
        highwrite_locol = color[col_box_disabled];
        highwrite_hicol = color[col_box_disabled];
        highwrite(12,13,lang[187],NULL);
        highwrite_locol = color[col_box_text];
        highwrite_hicol = color[col_box_hilight];
        keys[2] = 0;
    }
    else
    {
        if (pgpopts & 0x04) writechr(13,13,'',color[col_box_hilight]);
        keys[2] = toupper(highwrite(12,13,lang[187],&keypos[2]));
    }

    /* If not a reply, disable "Decrypt/Reply message" */
    if (reply)
    {
        keys[3] = toupper(highwrite(12,14,lang[188],&keypos[3]));
        if (pgpopts & 0x08) writechr(13,14,'',color[col_box_hilight]);
        keyb_keys = 4;
    }
    else
    {
        highwrite_locol = color[col_box_disabled];
        highwrite_hicol = color[col_box_disabled];
        highwrite(12,14,lang[188],NULL);
        highwrite_locol = color[col_box_text];
        highwrite_hicol = color[col_box_hilight];
        keyb_keys = 3;
    }

    if ((pgpopts & 0x02) && (pgpopts & 0x04)) pgpopts ^= 0x02;
    if (pgpopts & 0x01) writechr(13,11,'',color[col_box_hilight]);
    if (pgpopts & 0x02) writechr(13,12,'',color[col_box_hilight]);

    /* Do "PGP options" */
    quit = 0;
    while (!quit)
    {
        if (!sk_kbhit())
        {
            ch = (char) toupper(sk_getch());
            if (ch == 0) ch = find_key(sk_getch());

            if (ch == keys[0])
            {
                pgpopts ^= 0x01;
                if (pgpopts & 0x01) ch = ''; else ch = ' ';
                writechr(13,11,ch,color[col_box_hilight]);
                continue;
            }
            if (ch == keys[1])
            {
                pgpopts ^= 0x02;
                if (pgpopts & 0x02)
                {
                    pgpopts &= ~0x04;
                    writechr(13,13,' ',color[col_box_hilight]);
                    ch = '';
                } else ch = ' ';
                writechr(13,12,ch,color[col_box_hilight]);
                continue;
            }
            if (ch == keys[2])
            {
                pgpopts ^= 0x04;
                if (pgpopts & 0x04)
                {
                    pgpopts &= ~0x02;
                    writechr(13,12,' ',color[col_box_hilight]);
                    ch = '';
                } else ch = ' ';
                writechr(13,13,ch,color[col_box_hilight]);
                continue;
            }
            if (ch == keys[3])
            {
                pgpopts ^= 0x08;
                if (pgpopts & 0x08) ch = ''; else ch = ' ';
                writechr(13,14,ch,color[col_box_hilight]);
                continue;
            }
            if ((ch == 13) || (ch == 27))
                quit = 1;
        } else give_timeslice();
    }

    old_scr(cx,cy,&oldscr);

    /* Restore keyb_keys, keys[] and keypos[] variables */
    memcpy(keys,oldkeys,sizeof(oldkeys));
    memcpy(keypos,oldkeypos,sizeof(oldkeypos));
    keyb_keys = oldkeyb_keys;

    return pgpopts;
}
