#ifndef __PKT_OBJ_H
#define __PKT_OBJ_H

#include <stdio.h>
#include "bluewave.h"

#define MAX_AREAS 32
#define MAX_MIXES 128
#define BUF_SIZE  4096      /* Oltava 128:lla jaollinen!! */
//#define BUF_SIZE  79        /* Oltava 128:lla jaollinen!! */
#define XTI_SIZE  256

#define LINE_TYPE_NORMAL  0
#define LINE_TYPE_QUOTE   1
#define LINE_TYPE_TAG     2
#define LINE_TYPE_TEAR    3
#define LINE_TYPE_ORIGIN  4
#define LINE_TYPE_KLUDGE  5
#define LINE_TYPE_SPECIAL 6

typedef struct _line_rec
{
    struct _line_rec *next;
    struct _line_rec *prev;

    unsigned long ptr;
    unsigned char len;
    char line_type;
}
LINE_REC;

typedef struct _offline_packet offline_packet;

struct _offline_packet
{
    void *child;

    LINE_REC *first_linerec;
    LINE_REC *linerec;
    unsigned long current_line;

    /* Size & pointer in Fdat file of current message */
    unsigned long msgtxtsize;
    unsigned long msgtxtptr;

    char username[36];
    char useralias[36];
    char sysop_name[36];
    char board_name[41];

    char xtiname[13];
    char aidname[13];

    char lastarea[6];
    unsigned lastareanum;

    unsigned txt_length,max_freqs;
    unsigned char from_to_len,subj_len,mixedcase;
    char allow_forwarding,know_areas,allow_freq,offline_config,ansi_newfiles;
    char allow_crash,allow_direct,allow_immediate,allow_hold,allow_killsent,allow_fattach,allow_net_freq;

    long first;

    unsigned areas,replies;
    unsigned curarea;

    long msgptr;

    unsigned txt_lines;         /* Number of lines in message */
    char chrs_kludge[21];       /* CHARSET kludge in message */
    char msgid_kludge[80];      /* MSGID kludge in message */
    unsigned fmpt;              /* FMPT kludge in message */
    char intl_kludge[80];       /* INTL kludge in message */
    char origin_line[256];      /* Origin line of message */

    char xti_path[256];

    /* BW style .XTI file infos */
    FILE *Fxti;
    XTI_REC *xti_buf;
    unsigned xti_start,xti_end;

    char hippoinf;              /* Hippo area infos exists */
    char arealist;              /* Offline config exists */

    /* BW style .MIX file infos */
    FILE *Fmix;
    MIX_REC *mix_buf;
    unsigned mix_start,mix_end,total_mixes;

    /* ANSI files in message packet */
    unsigned char ansi_files;
    char ansi_name[255][13];
    char ansi_time[255][17];

    /* .FTI, .IDX, etc. file buffer positions */
    unsigned long idxstart,idxend;

    /* BW style .INF file infos */
    FILE *Finfo;                            /* .INF file handle */
    INF_HEADER info;                        /* .INF header */
    INF_AREA_INFO *area_buf;                /* .INF records */
    unsigned inf_header_slen,inf_area_slen; /* Size of .INF header & record */
    unsigned abufsize;                      /* Size of area_buf buffer */
    unsigned area_start,area_end;           /* Buffer positions */

    /* BW style reply information */
    char replyopen,fupl_opened;
    UPL_HEADER uplheader;
    FILE *Freply,*Fupl;

    /* Message text buffer */
    FILE *Fdat;
    unsigned char *txt_buf;
    unsigned long dat_start,dat_end;

    /* For SOUP */
    char *references;
    char *message_id;
    char *newsgroups;

    char (*open_packet) (offline_packet *, char *);
    void (*close_packet) (offline_packet *);
    char (*save_info) (offline_packet *, char *path);

    void (*read_inf_area) (offline_packet *, unsigned area);

    char (*area_selected) (offline_packet *, unsigned area);
    char *(*get_area_number) (offline_packet *, unsigned area);
    char *(*get_area_name) (offline_packet *, unsigned area);
    char *(*get_area_tag) (offline_packet *, unsigned area);

    unsigned (*getarea) (offline_packet *, char *areanum);
    unsigned (*getaname) (offline_packet *, char *area);
    unsigned (*gettag) (offline_packet *, char *tag);

    unsigned (*get_msgs) (offline_packet *, char *areanum);
    unsigned (*get_personal_msgs) (offline_packet *, char *areanum);
    unsigned (*get_unread_msgs) (offline_packet *, char *areanum);

    char (*open_area) (offline_packet *, char *area);
    char (*read_msg) (offline_packet *, unsigned msgnum);
    void (*write_msg) (offline_packet *, unsigned msgnum);
    void (*delete_msg) (offline_packet *, unsigned msgnum);

    long (*read_num) (offline_packet *, unsigned msgnum);
    char *(*read_from) (offline_packet *, unsigned msgnum);
    char *(*read_to) (offline_packet *, unsigned msgnum);
    char *(*read_subj) (offline_packet *, unsigned msgnum);

    char (*init_text) (offline_packet *);
    void (*deinit_msgtext) (offline_packet *);
    char *(*read_line) (offline_packet *, char *str, unsigned line);

    void (*area_flags) (offline_packet *, unsigned num, XTI_REC *xti);
    void (*save_area_flags) (offline_packet *, unsigned num, XTI_REC *xti);
    void (*update_area_flags) (offline_packet *);
    void (*delete_xti) (offline_packet *, unsigned num);

    void (*open_replypacket) (offline_packet *);
    void (*close_replypacket) (offline_packet *);

    char (*read_reply) (offline_packet *, unsigned num);

    char *(*export_msg) (offline_packet *, char *out);
    char (*init_replytext) (offline_packet *, char *fname);
    char *(*read_replyline) (offline_packet *, char *str, unsigned line);
    void (*export_reply) (offline_packet *, unsigned num, char *name);
    void (*deinit_replytext) (offline_packet *);

    unsigned (*area_type) (offline_packet *, unsigned area);

    void (*enter_msg) (offline_packet *);
    void (*edit_msg) (offline_packet *, unsigned num);

    void (*toggle_deleted) (offline_packet *, unsigned msgnum, char deleted);
    void (*delete_reply) (offline_packet *, unsigned msgnum);

    void (*read_arealist) (offline_packet *, FILE *F);
    void (*write_arealist) (offline_packet *, FILE *F);

    void (*read_mix) (offline_packet *pkt, unsigned area);
    void (*write_mix) (offline_packet *pkt, unsigned area, MIX_REC *mix);
    void (*delete_mix) (offline_packet *pkt, unsigned area);
};

char off_open_packet(offline_packet *, char *);
void off_close_packet(offline_packet *);
char off_read_msg(offline_packet *, unsigned msgnum);

offline_packet *new_offpacket(void);

#endif
