#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "general.h"
#include "vars.h"
#include "files.h"
#include "pkt_qwk.h"
#include "pkt_bw.h"
#include "pkt_obj.h"

char *qwk_packet::get_qwk_str(char *str, char size)
{
    int num;

    str[size] = 0;
    for (num=size-1; num>=0; num--)
    {
        if ((str[num] != ' ') && (str[num] != 0))
        {
            str[num+1] = 0;
            break;
        }
    }
    return str;
}

char qwk_packet::read_msg(unsigned msgnum)
{
    long pos;
    msg_header msghdr;
    char mnum[7];

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        msgtxtptr = msg.blockpos;
        msgtxtsize = msg.txtblocks;
        return 1;
    }
    memset(&msg,32,sizeof(msg));
    pos = (read_idx(msgnum)-1)*128;

    read_txt(pos);

    memcpy(&msghdr,&txt_buf[pos-dat_start],sizeof(msghdr));
    memcpy(mnum,msghdr.num,sizeof(msghdr.num)); get_qwk_str(mnum,6);
    msg.mnum = atol(mnum);

    msg.flags = 0;
    if ((msghdr.flag == '*') || (msghdr.flag == '+')) msg.flags = flag_private;
    if ((msghdr.flag == '+') || (msghdr.flag == '-')) msg.flags = flag_received;
    memcpy(msg.mto,msghdr.mto,25); get_qwk_str(msg.mto,25);
    memcpy(msg.mfrom,msghdr.mfrom,25); get_qwk_str(msg.mfrom,25);
    memcpy(msg.subj,msghdr.subj,25); get_qwk_str(msg.subj,25);

    memcpy(msg.date,msghdr.date,8);
    memcpy(msg.date+9,msghdr.time,5);
    msg.date[8] = ' ';
    msg.date[14] = 0;

    memcpy(mnum,msghdr.reply,sizeof(msghdr.reply)); get_qwk_str(mnum,sizeof(msghdr.reply));
    msg.replyto = atol(mnum);
    msg.replyat = 0;

    memcpy(mnum,msghdr.blocks,sizeof(msghdr.blocks)); get_qwk_str(mnum,sizeof(msghdr.blocks));
    msg.txtblocks = atol(mnum);

    msgtxtptr = pos+128;
    msgtxtsize = (msg.txtblocks-1) * 128;

    msg.blockpos = msgtxtptr;
    msg.txtblocks = msgtxtsize;

    offline_packet::read_msg(msgnum);
    return 1;
}

long qwk_packet::read_num(unsigned msgnum)
{
    long pos;
    msg_header *msghdr;
    char mnum[7];

    if (msgs_in_mem) return mem_msgs[msgnum-1].mnum;

    pos = (read_idx(msgnum)-1)*128;
    read_txt(pos);
    msghdr = (msg_header *) &txt_buf[pos-dat_start];

    memcpy(mnum,msghdr->num,6); get_qwk_str(mnum,6);
    msg.mnum = atol(mnum);
    return msg.mnum;
}

char *qwk_packet::read_from(unsigned msgnum) {
    long pos;
    msg_header *msghdr;
    char mnum[7];

    if (msgs_in_mem) {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }
    pos = (read_idx(msgnum)-1)*128;
    read_txt(pos);
    msghdr = (msg_header *) &txt_buf[pos-dat_start];

    memcpy(mnum,msghdr->num,6); get_qwk_str(mnum,6);
    msg.mnum = atol(mnum);

    memcpy(msg.mfrom,msghdr->mfrom,25); get_qwk_str(msg.mfrom,25);
    return msg.mfrom;
}
    
char *qwk_packet::read_to(unsigned msgnum) {
    long pos;
    msg_header *msghdr;
    char mnum[7];

    if (msgs_in_mem) {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mto;
    }
    pos = (read_idx(msgnum)-1)*128;
    read_txt(pos);
    msghdr = (msg_header *) &txt_buf[pos-dat_start];

    memcpy(mnum,msghdr->num,6); get_qwk_str(mnum,6);
    msg.mnum = atol(mnum);

    memcpy(msg.mto,msghdr->mto,25); get_qwk_str(msg.mto,25);
    return msg.mto;
}

char *qwk_packet::read_subj(unsigned msgnum) {
    long pos;
    msg_header *msghdr;
    char mnum[7];

    if (msgs_in_mem) {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }
    pos = (read_idx(msgnum)-1)*128;
    read_txt(pos);
    msghdr = (msg_header *) &txt_buf[pos-dat_start];

    memcpy(mnum,msghdr->num,6); get_qwk_str(mnum,6);
    msg.mnum = atol(mnum);

    memcpy(msg.subj,msghdr->subj,25); get_qwk_str(msg.subj,25);
    offline_packet::read_subj(msgnum);
    return msg.subj;
}

long qwk_packet::read_idx(unsigned num)
{
    char tmp[256];
    long msgs;

    if (ndxopen != curarea)
    {
        if (ndxopen > 0)
            free(ndxarr);

        sprintf(tmp,"%s%03ld.ndx",setup.workpath,atol((char *) mix_buf[curarea-mix_start].areanum));
        if ((Fndx = fopen_ign(tmp,"rb")) == NULL)
        {
            ndxopen = 0;
            ndxarr = NULL;
            return 0;
        }
        ndxopen = curarea;
        msgs = get_msgs((char *) mix_buf[curarea-mix_start].areanum);
        if ((ndxarr = (NDX_REC *) malloc(sizeof(NDX_REC)*msgs)) == NULL)
        {
            ndxopen = 0;
            fclose(Fndx);
            printf("\n\nNot enough memory!\n");
            return 0;
        }
        fread(ndxarr,sizeof(NDX_REC),msgs,Fndx);
        fclose(Fndx);
    }
    return basicreal2long(ndxarr[num-1].pos);
}

void qwk_packet::read_txt(unsigned long num)
{
    size_t readed;

    if ((dat_start > num) || (dat_end < num))
    {
        fseek(Fdat,num,SEEK_SET);
        readed = fread(txt_buf,1,BUF_SIZE,Fdat);
        dat_start = num;
        dat_end = dat_start-1+readed;
    }
}

char *qwk_packet::export_msg(char *out)
{
    FILE *F;
    unsigned num,num2;
    size_t readed;

    strcat(strcpy(out,setup.workpath),"TMP_ANSI.");
    if ((F = FileOpen(out,"w+b")) == NULL) return NULL;

    fseek(Fdat,msgtxtptr,SEEK_SET);
    num2 = msgtxtsize/BUF_SIZE;
    for (num=1; num<=num2; num++) {
        readed = fread(txt_buf,1,BUF_SIZE,Fdat);
        fwrite(txt_buf,1,readed,F);
    }
    readed = fread(txt_buf,1,msgtxtsize % BUF_SIZE,Fdat);
    fwrite(txt_buf,1,readed,F);

    fclose(F);
    return out;
}

void qwk_packet::write_arealist(FILE *F)
{
    unsigned astart,aend,area;
    char areabuf[512];

    FILE *Ftmp;

    if ((Ftmp = FileOpen(strcat(strcpy(areabuf,setup.replypath),"ADD.MSG"),"w+b")) != NULL)
    {
        fprintf(Ftmp,"ADD\r\n");
        fclose(Ftmp);
    } else return;
    if ((Ftmp = FileOpen(strcat(strcpy(areabuf,setup.replypath),"DROP.MSG"),"w+b")) != NULL)
    {
        fprintf(Ftmp,"DROP\r\n");
        fclose(Ftmp);
    } else {
        FileRemove(strcat(strcpy(areabuf,setup.replypath),"ADD.MSG"));
        return;
    }

    astart = 0; aend = 0;
    remove_replyfile = 0;
    for (area=1; area<=areas; area++)
    {
        if ((astart > area) || (aend < area))
        {
            fseek(F,area-1,SEEK_SET);
            astart = area;
            aend = area+fread(areabuf,1,sizeof(areabuf),F)-1;
        }
        switch (areabuf[area-astart])
        {
            case 1:
                memset(&reply,0,sizeof(reply));
                strcpy(reply.area,get_area_tag(area));
                strcpy(reply.mfrom,username);
                strcpy(reply.mto,whoto);
                strcpy(reply.subj,"ADD");
                reply.flags = flag_private;
                strcpy(reply.fname,"ADD.MSG");
                enter_msg();
                break;
            case 2:
                memset(&reply,0,sizeof(reply));
                strcpy(reply.area,get_area_tag(area));
                strcpy(reply.mfrom,username);
                strcpy(reply.mto,whoto);
                strcpy(reply.subj,"DROP");
                reply.flags = flag_private;
                strcpy(reply.fname,"DROP.MSG");
                enter_msg();
                break;
        }
    }
    remove_replyfile = 1;
}
