#ifdef __386__
#  define _intr(x,y,z) int386(x,y,z)
#else
#  define _intr(x,y,z) int86(x,y,z)
#endif

#define KELLO

#ifdef __OS2__
#  define INCL_VIO
#  define INCL_PM
#  define INCL_WIN
#  include <os2.h>
#  include <process.h>
#  define WinSetTitle WIN16SETTITLE
extern "C" {
    APIRET16 APIENTRY16 Win16SetTitle (HAB hab, PSZ title);
}
#elif defined (__linux__)
#  include <ncurses.h>
#elif defined (__NT__)
#  include <windows.h>
#else
#  include <dos.h>
#endif

#ifdef __linux__
#  define SHADE_COLOR 7
#else
#  define SHADE_COLOR 8
#endif

#include <stdlib.h>
#include <time.h>

#include <stdio.h>
#include <string.h>

#ifdef KELLO
#  include "scrsaver.h"
#  include "vars.h"
#endif

#include "keyb.h"
#include "screen.h"

int c_height = 16;
int scrwidth = 80;
int scrsize = 25;
int chg_title;
int wherex = 1;
int wherey = 1;

#if defined (__NT__)
    HANDLE scrHandle;
#elif !defined (__OS2__) && !defined (__linux__)
#ifndef __386__
    char far *s_screen = (char far *) 0xb8000000;
    unsigned short far *screen = (unsigned short far *) 0xb8000000;
#else
    char *s_screen = (char *) 0xb8000;
    unsigned short *screen = (unsigned short *) 0xb8000;
#endif
#endif

#ifdef __NT__
void InitScreen(void)
{
    /*SECURITY_ATTRIBUTES lpsa;

    lpsa.nLength = sizeof(SECURITY_ATTRIBUTES);
    lpsa.lpSecurityDescriptor = NULL;
    lpsa.bInheritHandle = TRUE;*/

    scrHandle = CreateConsoleScreenBuffer(
        GENERIC_READ | GENERIC_WRITE,
        0,
        NULL,
        CONSOLE_TEXTMODE_BUFFER,
        NULL
    );
    SetConsoleActiveScreenBuffer(scrHandle);
}
#endif

#ifdef __linux__

int changed;
chtype *vscr;

inline void set_color(unsigned char col)
{
    register unsigned long bcol = 0;

    if ((col & 0x0f) == 8)
    {
        attroff(A_BOLD);
        bcol = A_DIM;
        col |= 7;
    }
    else
    {
        attroff(A_DIM);
        if (col & 8) bcol |= A_BOLD; else attroff(A_BOLD);
    }
    if (col & 128) bcol |= A_BLINK; else attroff(A_BLINK);
    attron(COLOR_PAIR((col&7) + (col&0x70)/2) | bcol);
}

void InitScreen(void)
{
    char ansi_tab[8] = {0,4,2,6,1,5,3,7};
    int num;

    if (!initscr()) exit(1);
    raw();
    halfdelay(1);
    noecho();
    start_color();
    for (num=1; num<COLOR_PAIRS; num++)
    {
        init_pair(num,ansi_tab[num&7],ansi_tab[num>>3]);
    }
    vscr = (chtype *) malloc(sizeof(chtype)*8000);
    changed = 1;
}
#endif

void gotoxy(int x, int y)
{
    wherex = x;
    wherey = y;
#ifdef __NT__
    COORD Cursor;
    Cursor.X = x-1;
    Cursor.Y = y-1;
    SetConsoleCursorPosition(scrHandle,Cursor);
#elif defined (__OS2__)
    VioSetCurPos((unsigned short) (y-1),(unsigned short) (x-1),0);
#elif defined (__linux__)
    changed = 1;
    move(y-1,x-1);
#else
    union REGS regs;
    regs.w.dx = (y << 8) + x - 0x0101;
    regs.h.bh = 0;
    regs.h.ah = 2;
    _intr(0x10,&regs,&regs);
#endif
}

void cwritexy(int x, int y, char *str, char col)
{
#ifdef __NT__
    COORD Coord;
    DWORD Written;
    int slen;

    slen = strlen(str);
    Coord.X = x-1;
    Coord.Y = y-1;
    WriteConsoleOutputCharacter(scrHandle,str,slen,Coord,&Written);
    FillConsoleOutputAttribute(scrHandle,col,slen,Coord,&Written);
#elif defined (__OS2__)
    VioWrtCharStrAtt(str,strlen(str),(unsigned short) (y-1),(unsigned short) (x-1),&col,0);
#elif defined (__linux__)
    changed = 1;
    set_color(col);
    move(y-1,x-1);
    addstr(str);

    {
        unsigned long *addr = vscr + (y-1)*scrwidth + (x-1);
        while (*str != '\0')
        {
            *addr = ((unsigned long) col << 24) + (unsigned char) *str;
            addr++; str++;
        }
    }
#else
    {
        unsigned short far *addr = (unsigned short far *) screen + (y-1)*scrwidth + (x-1);
        while (*str != '\0')
        {
            *addr++ = ((unsigned) col << 8) + (unsigned char) *str++;
        }
    }
#endif
}

void tclrscr(void)
{
#ifdef __NT__
    COORD Cursor;
    COORD Coord;
    DWORD Written;

    Coord.X = 0;
    Coord.Y = 0;
    FillConsoleOutputAttribute(scrHandle,7,scrwidth*scrsize,Coord,&Written);
    FillConsoleOutputCharacter(scrHandle,' ',scrwidth*scrsize,Coord,&Written);

    Cursor.X = 0;
    Cursor.Y = 0;
    SetConsoleCursorPosition(scrHandle,Cursor);
#elif defined (__OS2__)
    char cell[3] = { ' ', 7, 0 };

    VioScrollUp(0,0,65535,65535,65535,cell,0);
    VioSetCurPos(0,0,0);
#elif defined (__linux__)
    unsigned nro;

    changed = 0;
    set_color(7);
    erase();
    move(0,0);
    refresh();

    for (nro=0; nro<scrsize*scrwidth; nro++)
        vscr[nro] = (7<<24)+' ';
#else
    unsigned nro;

    for (nro=0; nro<scrsize*scrwidth; nro++)
        screen[nro] = (7<<8)+' ';
    gotoxy(1,1);
#endif
}

void tbar(int x1, int y1, int x2, int y2, int col)
{
#ifdef __NT__
    COORD Coord;
    DWORD Written;
    int y;

    Coord.X = x1-1;
    for (y=y1-1; y<y2; y++)
    {
        Coord.Y = y;
        FillConsoleOutputAttribute(scrHandle,col,x2-x1+1,Coord,&Written);
        FillConsoleOutputCharacter(scrHandle,' ',x2-x1+1,Coord,&Written);
    }
#elif defined (__OS2__)
    int y;

    char cell[3] = { ' ', 7, 0 };
    cell[1] = (char) col;

    for (y=y1-1; y<y2; y++)
        VioWrtNCell(cell,(unsigned short) (x2-x1+1),(unsigned short) y,(unsigned short) (x1-1),0);
#elif defined (__linux__)
    int x,y,addr;
    char box[256];
    set_color(col);

    changed = 1;
    memset(box,' ',sizeof(box)-1); box[x2-x1+1] = '\0';
    for (y=y1-1; y<y2; y++)
    {
        move(y,x1-1);
        addstr(box);
        addr = (x1-1)+y*scrwidth;
        for (x=x1-1; x<=x2-1; x++)
            vscr[addr++] = ((unsigned long) col << 24) + ' ';
    }
#else
    int x,y,addr;
    for (y=y1-1; y<y2; y++)
    {
        addr = (x1-1)+y*scrwidth;
        for (x=x1-1; x<=x2-1; x++)
            screen[addr++] = ((unsigned) col << 8) + ' ';
    }
#endif
}

void tbox(int x1, int y1, int x2, int y2, int col, int ct)
{
    if (x2 <= x1) return;

#ifdef __linux__
    {
    int num;

    writechr(x1,y1,ACS_ULCORNER,col);
    writechr(x2,y1,ACS_URCORNER,col);
    for (num=1; num<x2-x1; num++)
    {
        writechr(x1+num,y1,ACS_HLINE,col);
        writechr(x1+num,y2,ACS_HLINE,col);
    }
    writechr(x1,y2,ACS_LLCORNER,col);
    writechr(x2,y2,ACS_LRCORNER,col);
    }
#else
    {
    char corner[8] = { '','','','','','','','' };
    char straight[4] = { '','','','' };
    char tmp[256];

    /* Write upper line */
    tmp[0] = corner[(ct-1) << 2];
    memset(tmp+1,straight[((ct-1) << 1)+1],x2-x1-1);
    tmp[x2-x1] = corner[((ct-1) << 2)+2];
    tmp[x2-x1+1] = '\0';
    cwritexy(x1,y1,tmp,col);

    /* Write lower line */
    tmp[0] = corner[((ct-1) << 2)+1];
    memset(tmp+1,straight[((ct-1) << 1)+1],x2-x1-1);
    tmp[x2-x1] = corner[((ct-1) << 2)+3];
    tmp[x2-x1+1] = '\0';
    cwritexy(x1,y2,tmp,col);
    }
#endif

#ifdef __NT__
    {
    COORD Coord;
    DWORD Written;
    int y;

    for (y=y1; y<y2-1; y++)
    {
        Coord.Y = y;

        Coord.X = x1-1;
        FillConsoleOutputAttribute(scrHandle,col,1,Coord,&Written);
        FillConsoleOutputCharacter(scrHandle,straight[(ct-1) << 1],1,Coord,&Written);
        Coord.X = x2-1;
        FillConsoleOutputAttribute(scrHandle,col,1,Coord,&Written);
        FillConsoleOutputCharacter(scrHandle,straight[(ct-1) << 1],1,Coord,&Written);
    }
    }
#elif defined (__OS2__)
    {
    int y;
    char cell[3] = { ' ', 7, 0 };

    cell[1] = (char) col;

    cell[0] = straight[(ct-1) << 1];
    for (y=y1; y<y2-1; y++)
    {
        VioWrtNCell(cell,1,y,x1-1,0);
        VioWrtNCell(cell,1,y,x2-1,0);
    }
    }
#elif defined (__linux__)
    {
    int y;

    for (y=y1+1; y<y2; y++)
    {
        writechr(x1,y,ACS_VLINE,col);
        writechr(x2,y,ACS_VLINE,col);
    }
    }
#else
    {
    int y;

    x1--; x2--;

    for (y=y1; y<y2-1; y++)
    {
        screen[x1+y*scrwidth] = straight[(ct-1) << 1]+(col<<8);
        screen[x2+y*scrwidth] = straight[(ct-1) << 1]+(col<<8);
    }
    }
#endif
}

void tattr(int x, int y, char col)
{
#ifdef __NT__
    COORD Coord;
    DWORD Written;

    Coord.X = x-1;
    Coord.Y = y-1;
    FillConsoleOutputAttribute(scrHandle,col,1,Coord,&Written);
#elif defined (__OS2__)
    VioWrtNAttr(&col,1,y-1,x-1,0);
#elif defined (__linux__)
    writechr(x,y,vscr[(x-1)+(y-1)*scrwidth] & 0xffffff,col);
#else
    s_screen[(x-1)*2+1+(y-1)*scrwidth*2] = col;
#endif
}

void tattrbar(int x1, int y1, int x2, int y2, char col)
{
    if (x2 > (int) scrwidth) x2 = scrwidth;
#ifdef __NT__
    {
    COORD Coord;
    DWORD Written;
    int y;

    Coord.X = x1-1;
    for (y=y1-1; y<y2; y++)
    {
        Coord.Y = y;
        FillConsoleOutputAttribute(scrHandle,col,x2-x1+1,Coord,&Written);
    }
    }
#elif defined (__OS2__)
    {
    int y;
    for (y=y1-1; y<y2; y++)
        VioWrtNAttr(&col,x2-x1+1,y,x1-1,0);
    }
#elif defined (__linux__)
    {
    int x,y;

    if ((unsigned) x2 > scrwidth) x2 = scrwidth;

    for (y=y1; y<=y2; y++)
    {
        for (x=x1; x<=x2; x++)
        {
            writechr(x,y,vscr[(x-1)+(y-1)*scrwidth] & 0xffffff,col);
        }
    }
    }
#else
    {
    char far *addr;
    int x,y,diff;

    if (x2 > scrwidth) x2 = scrwidth;

    addr = s_screen + ((x1-1) << 1)+1 + (y1-1)*scrwidth*2;
    diff = (scrwidth-x2 + x1-1)*2;
    x2 -= x1-1; y2 -= y1-1;
    for (y=y2; y > 0; y--)
    {
        for (x = x2; x > 0; x--)
        {
            *addr = col; addr += 2;
        }
        addr += diff;
    }
    }
#endif
}

void draw_shaded_box(int x1, int y1, int x2, int y2, int col1, int col2, char *str)
{
    char tmp[256],slen;

    tbox(x1,y1,x2,y2,col1,1);
    tbar(x1+1,y1+1,x2-1,y2-1,col1);
    if ((unsigned) (y2+1) <= scrsize)
        tattrbar(x1+2,y2+1,x2+2,y2+1,SHADE_COLOR);

    if ((unsigned) (x2+1) <= scrwidth)
        tattrbar(x2+1,y1+1,x2+2,y2,SHADE_COLOR);

    if (str == NULL) return;

    sprintf(tmp," %s ",str);
    slen = strlen(tmp);
    cwritexy(x1+((x2-x1-slen) >> 1)+1,y1,tmp,col2);
}

void nocursor(void)
{
#ifdef __NT__
    CONSOLE_CURSOR_INFO Cursor;

    Cursor.dwSize = 1;
    Cursor.bVisible = FALSE;
    SetConsoleCursorInfo(scrHandle,&Cursor);
#elif defined (__OS2__)
    VIOCURSORINFO vio_curs;

    vio_curs.yStart = 0;
    vio_curs.cEnd = 0;
    vio_curs.cx = 0;
    vio_curs.attr = 0xffff;
    VioSetCurType(&vio_curs,0);
#elif defined (__linux__)
    gotoxy(1,1);
#else
    union REGS regs;
    regs.h.ah = 1;
    regs.w.cx = 0x2000;

    _intr(0x10,&regs,&regs);
#endif
}

void cursorsize(int cstart,int cend)
{
#ifdef __NT__
    CONSOLE_CURSOR_INFO Cursor;

    Cursor.dwSize = (cend-cstart+1)*10;
    Cursor.bVisible = TRUE;
    SetConsoleCursorInfo(scrHandle,&Cursor);
#elif defined (__OS2__)
    VIOCURSORINFO vio_curs;

    vio_curs.yStart = cstart;
    vio_curs.cEnd = cend;
    vio_curs.cx = 0;
    vio_curs.attr = 0;
    VioSetCurType(&vio_curs,0);
#elif defined (__linux__)
#else
    union REGS regs;
    regs.h.ah = 1;
    regs.h.ch = cstart;
    regs.h.cl = cend;
    _intr(0x10,&regs,&regs);
#endif
}

void getcursorsize(char *cstart, char *cend)
{
#ifdef __NT__
    CONSOLE_CURSOR_INFO Cursor;

    GetConsoleCursorInfo(scrHandle,&Cursor);
    *cstart = 14-(Cursor.dwSize/10);
    *cend = 14;
#elif defined (__OS2__)
    VIOCURSORINFO vio_curs;

    VioGetCurType(&vio_curs,0);
    *cstart = vio_curs.yStart;
    *cend = vio_curs.cEnd;
#elif defined (__linux__)
#else
    union REGS regs;
    regs.h.bh = 0;
    regs.h.ah = 3;
    _intr(0x10,&regs,&regs);
    *cstart = regs.h.ch;
    *cend = regs.h.cl;
#endif
}

#ifdef __linux__
void save_scr(unsigned short *ox, unsigned short *oy, char **oldscr)
{
    unsigned size;

    size = scrwidth*scrsize;
    if (( (*oldscr) = (char *) malloc(sizeof(chtype)*size)) == NULL)
    {
        printf("\nNot enough memory!\n");
        exit(1);
    }

    memcpy(*oldscr,vscr,size*sizeof(chtype));
}
#else
void save_scr(unsigned short *ox, unsigned short *oy, char **oldscr)
{
    unsigned short size;

#ifdef __NT__
    CONSOLE_SCREEN_BUFFER_INFO ScrInfo;
    COORD BufSize,BufCoord;
    SMALL_RECT Rect;

    CHAR_INFO *tmp;

    GetConsoleScreenBufferInfo(scrHandle,&ScrInfo);
    *ox = ScrInfo.dwCursorPosition.X;
    *oy = ScrInfo.dwCursorPosition.Y;

    size = sizeof(CHAR_INFO) * scrwidth * scrsize;
    if ((tmp = (CHAR_INFO *) malloc(sizeof(CHAR_INFO)*size)) == NULL) {
        printf("\nNot enough memory!\n");
        exit(1);
    }

    *oldscr = (char *) tmp;
    BufSize.X = scrwidth;
    BufSize.Y = scrsize;
    BufCoord.X = 0;
    BufCoord.Y = 0;
    Rect.Left = 0;
    Rect.Top = 0;
    Rect.Right = scrwidth-1;
    Rect.Bottom = scrsize-1;
    ReadConsoleOutput(scrHandle,(CHAR_INFO *) *oldscr,BufSize,BufCoord,&Rect);
#else
#ifdef __OS2__
    VioGetCurPos(oy,ox,0);
#else
    union REGS regs;
    regs.h.bh = 0;
    regs.h.ah = 3;
    _intr(0x10,&regs,&regs);
    *ox = regs.h.dl;
    *oy = regs.h.dh;
#endif /* __OS2__ */

    size = scrwidth*2*scrsize;
    if (( (*oldscr) = (char *) malloc(size)) == NULL)
    {
        printf("\nNot enough memory!\n");
        exit(1);
    }
#ifdef __OS2__
    VioReadCellStr(*oldscr,&size,0,0,0);
#else
    _fmemcpy(*oldscr,s_screen,size);
#endif
#endif /* __NT__ */
}
#endif

#ifdef __linux__
void old_scr(unsigned short ox, unsigned short oy, char **oldscr)
{
    unsigned x,y;

    memcpy(vscr,*oldscr,scrwidth*scrsize*sizeof(chtype));
    free(*oldscr);
    *oldscr = NULL;

    for (y=0; y<scrsize; y++)
    {
        for (x=0; x<scrwidth; x++)
        {
            writechr(x+1,y+1,vscr[x+y*scrwidth] & 0xffffff,vscr[x+y*scrwidth] >> 24);
        }
    }

#ifdef KELLO
    if (showclock) draw_clock();
#endif
    changed = 0;
    refresh();
}
#else
void old_scr(unsigned short ox, unsigned short oy, char **oldscr)
{
    unsigned size;

#ifdef __NT__
    COORD Cursor;
    COORD BufSize,BufCoord;
    SMALL_RECT Rect;

    Cursor.X = ox;
    Cursor.Y = oy;
    SetConsoleCursorPosition(scrHandle,Cursor);

    size = sizeof(CHAR_INFO) * scrwidth * scrsize;

    BufSize.X = scrwidth;
    BufSize.Y = scrsize;
    BufCoord.X = 0;
    BufCoord.Y = 0;
    Rect.Left = 0;
    Rect.Top = 0;
    Rect.Right = scrwidth-1;
    Rect.Bottom = scrsize-1;
    WriteConsoleOutput(scrHandle,(CHAR_INFO *) *oldscr,BufSize,BufCoord,&Rect);

    free(*oldscr);
#else
#ifdef __OS2__
    VioSetCurPos(oy,ox,0);
#elif defined (__linux__)
#else
    union REGS regs;
    regs.w.dx = (oy << 8) + ox - 0x0101;
    regs.h.bh = 0;
    regs.h.ah = 2;
    _intr(0x10,&regs,&regs);
#endif /* __OS2__ */

    size = scrwidth*2 * scrsize;
#ifdef __OS2__
    VioWrtCellStr(*oldscr,size,0,0,0);
#else
    _fmemcpy(s_screen,*oldscr,size);
#endif
    free(*oldscr);
#endif /* __NT__ */

    oldscr = NULL;

#ifdef KELLO
    if (showclock) draw_clock();
#endif
}
#endif

void writeblock(int x, int y, char *block, int len)
{
#ifdef __OS2__
    VioWrtCellStr(block,len,y-1,x-1,0);
#elif defined (__NT__) || defined (__linux__)
    while (len > 0)
    {
        writechr(x++,y,*block,*(block+1));
        block += 2;
        len -= 2;
    }
#else
    _fmemcpy(s_screen+(y-1)*scrwidth*2+(x-1)*2,block,len);
#endif
}

void writechr(int x, int y, chtype chr, char col)
{
#ifdef __NT__
    COORD Coord;
    DWORD Written;

    Coord.X = x-1;
    Coord.Y = y-1;
    WriteConsoleOutputCharacter(scrHandle,(char *) &chr,1,Coord,&Written);
    FillConsoleOutputAttribute(scrHandle,col,1,Coord,&Written);
#elif defined (__OS2__)
    VioWrtCharStrAtt((char *) &chr,1,y-1,x-1,&col,0);
#elif defined (__linux__)
    unsigned char st[2];

    changed = 1;
    set_color(col);
    move(y-1,x-1);
    if ((signed long) chr < 0 || (chr & (~127)) == 128)
    {
        /* HiASCII - use addstr because of bug in ncurses */
        st[0] = chr;
        st[1] = '\0';
        addstr((char *) st);
        vscr[(y-1)*scrwidth + (x-1)] = ((unsigned long) col << 24) + (unsigned char) chr;
    }
    else
    {
        addch(chr);
        vscr[(y-1)*scrwidth + (x-1)] = ((unsigned long) col << 24) + chr;
    }
#else
    screen[(y-1)*scrwidth + (x-1)] = ((unsigned) col << 8) + chr;
#endif
}

void scroll_down(int x1, int y1, int x2, int y2)
{
#ifdef __NT__
    SMALL_RECT MoveArea;
    COORD NewPos;
    CHAR_INFO Fill;

    MoveArea.Left = x1-1;
    MoveArea.Top = y1-1;
    MoveArea.Right = x2-1;
    MoveArea.Bottom = y2-2;

    NewPos.X = x1-1;
    NewPos.Y = y1;

    Fill.Char.AsciiChar = ' ';
    Fill.Attributes = 7;

    ScrollConsoleScreenBuffer(scrHandle,&MoveArea,NULL,NewPos,&Fill);
#elif defined (__OS2__)
    char cell[3] = { ' ', 7, 0 };
    VioScrollDn(y1-1,x1-1,y2-1,x2-1,1,cell,0);
#elif defined (__linux__)
    WINDOW *win;
    int y;

    win = subwin(stdscr,y2-y1+1,x2-x1+1,y1-1,x1-1);
    scrollok(win,TRUE);
    wscrl(win,-1);
    wrefresh(win);
    delwin(win);

    for (y=y2-1; y>=y1; y--)
    {
        memcpy(vscr+x1-1+y*scrwidth,vscr+x1-1+(y-1)*scrwidth,(x2-x1+1)*sizeof(chtype));
    }
#else
    int y;

    for (y=y2-1; y>=y1; y--)
    {
        _fmemcpy(screen+x1-1+y*scrwidth,screen+x1-1+(y-1)*scrwidth,(x2-x1+1)*2);
    }
#endif
}

void scroll_up(int x1, int y1, int x2, int y2)
{
#ifdef __NT__
    SMALL_RECT MoveArea;
    COORD NewPos;
    CHAR_INFO Fill;

    MoveArea.Left = x1-1;
    MoveArea.Top = y1;
    MoveArea.Right = x2-1;
    MoveArea.Bottom = y2-1;

    NewPos.X = x1-1;
    NewPos.Y = y1-1;

    Fill.Char.AsciiChar = ' ';
    Fill.Attributes = 7;

    ScrollConsoleScreenBuffer(scrHandle,&MoveArea,NULL,NewPos,&Fill);
#elif defined (__OS2__)
    char cell[3] = { ' ', 7, 0 };
    VioScrollUp(y1-1,x1-1,y2-1,x2-1,1,cell,0);
#elif defined (__linux__)
    WINDOW *win;
    int y;

    win = subwin(stdscr,y2-y1+1,x2-x1+1,y1-1,x1-1);
    scrollok(win,TRUE);
    wscrl(win,1);
    wrefresh(win);
    delwin(win);

    for (y=y1-1; y<=y2-2; y++)
    {
        memcpy(vscr+x1-1+y*scrwidth,vscr+x1-1+(y+1)*scrwidth,(x2-x1+1)*sizeof(chtype));
    }
#else
    int y;

    for (y=y1-1; y<=y2-2; y++)
    {
        _fmemcpy(screen+x1-1+y*scrwidth,screen+x1-1+(y+1)*scrwidth,(x2-x1+1)*2);
    }
#endif
}

#ifdef KELLO
void draw_clock(void)
{
    time_t _tim;
    struct tm *tim;
    char tmp[20];

    if ((setup.misc_flags & MISC_SHOW_TIME) == 0) return;
    _tim = time(NULL);
    tim = localtime(&_tim);
    sprintf(tmp," %02d:%02d:%02d ",tim->tm_hour,tim->tm_min,tim->tm_sec);
    cwritexy(scrwidth-10,1,tmp,clockcolor);
    sprintf(tmp," %02d-%02d-%02d ",tim->tm_mon+1,tim->tm_mday,tim->tm_year % 100);
    cwritexy(2,1,tmp,clockcolor);
}
#endif

void get_attr(int x1, int x2, int y, char *buf)
{
    int num;

#ifdef __NT__
    COORD BufSize,BufCoord;
    SMALL_RECT Rect;

    CHAR_INFO tmp[256];

    BufSize.X = x2-x1+1;
    BufSize.Y = 1;
    BufCoord.X = x1-1;
    BufCoord.Y = y-1;
    Rect.Left = x1-1;
    Rect.Top = y-1;
    Rect.Right = x2-1;
    Rect.Bottom = y-1;
    ReadConsoleOutput(scrHandle,(CHAR_INFO *) tmp,BufSize,BufCoord,&Rect);
    for (num=0; num<=x2-x1; num++)
        buf[num] = tmp[num].Attributes;
#elif defined (__OS2__)
    unsigned short tmp[256];
    unsigned short size = (x2-x1+1)*2;

    VioReadCellStr((char *) tmp,&size,y-1,x1-1,0);
    for (num=0; num<=x2-x1; num++)
        buf[num] = tmp[num] >> 8;
#elif defined (__linux__)
    int pos = (int) (y-1)*scrwidth+x1-1;
    for (num=0; num<=x2-x1; num++)
        buf[num] = vscr[pos+num] >> 24;
#else
    int pos = (int) (y-1)*scrwidth+x1-1;
    for (num=0; num<=x2-x1; num++)
        buf[num] = (char) (screen[pos+num] >> 8);
#endif
}

void mode_80x50(void)
{
#ifdef __OS2__
    VIOMODEINFO VioMode;
    VIOMODEINFO OldMode;

    OldMode.cb = sizeof(VIOMODEINFO);
    VioGetMode(&OldMode,0);
    scrsize = OldMode.row;
    scrwidth = OldMode.col;

    memcpy(&VioMode,&OldMode,sizeof(VioMode));
    VioMode.col = 80;
    VioMode.row = 50;
    VioMode.hres = 640;
    VioMode.vres = 50*8;

#elif defined (__NT__)
#elif defined (__linux__)
#else
    union REGS regs;
    // .........
    _intr(0x10,&regs,&regs);
#endif
}

#ifndef __linux__
void scroll_left(int x1, int y1, int x2, int y2)
{
#ifdef __NT__
    SMALL_RECT MoveArea;
    COORD NewPos;
    CHAR_INFO Fill;
    
    MoveArea.Left = x1;
    MoveArea.Top = y1-1;
    MoveArea.Right = x2-1;
    MoveArea.Bottom = y2-1;
    
    NewPos.X = x1-1;
    NewPos.Y = y1-1;
    
    Fill.Char.AsciiChar = ' ';
    Fill.Attributes = 7;
    
    ScrollConsoleScreenBuffer(scrHandle,&MoveArea,NULL,NewPos,&Fill);
#elif defined (__OS2__)
    char cell[3] = { ' ', 7, 0 };
    VioScrollLf(y1-1,x1-1,y2-1,x2-1,1,cell,0);
#elif defined (__linux__)
#else
    int x,y;
    
    for (y=y2-1; y>=y1; y--)
        for (x=x1-1; x<=x2-1; x++)
            screen[x + y*scrwidth] =
            screen[x + (y-1)*scrwidth];
#endif
}

void scroll_right(int x1, int y1, int x2, int y2)
{
#ifdef __NT__
    SMALL_RECT MoveArea;
    COORD NewPos;
    CHAR_INFO Fill;
    
    MoveArea.Left = x1-1;
    MoveArea.Top = y1-1;
    MoveArea.Right = x2-2;
    MoveArea.Bottom = y2-1;
    
    NewPos.X = x1;
    NewPos.Y = y1-1;
    
    Fill.Char.AsciiChar = ' ';
    Fill.Attributes = 7;
    
    ScrollConsoleScreenBuffer(scrHandle,&MoveArea,NULL,NewPos,&Fill);
#elif defined (__OS2__)
    char cell[3] = { ' ', 7, 0 };
    VioScrollRt(y1-1,x1-1,y2-1,x2-1,1,cell,0);
#elif defined (__linux__)
#else
    int x,y;
    
    for (y=y2-1; y>=y1; y--)
        for (x=x1-1; x<=x2-1; x++)
            screen[x + y*scrwidth] =
            screen[x + (y-1)*scrwidth];
#endif
}
#endif

char *gettitle(char *title)
{
    title[0] = 0;
#ifdef __OS2__
    HSWITCH hsw;
    SWCNTRL sw;

    if (chg_title) {
        hsw = WinQuerySwitchHandle(NULLHANDLE, getpid());

        if (WinQuerySwitchEntry(hsw, &sw) == 0)
            strcpy(title, sw.szSwtitle);
    }
#elif defined (__NT__)
    GetConsoleTitle(title,80);
#endif
    return title;
}

void settitle(char *title)
{
#ifdef __OS2__
    HSWITCH hsw;
    SWCNTRL sw;
    PID pid;
    TID tid;

    if (chg_title)
    {
        hsw = WinQuerySwitchHandle(NULLHANDLE, getpid());

        if (WinQuerySwitchEntry(hsw, &sw) == 0) {

            strncpy (sw.szSwtitle, title, MAXNAMEL - 1);
            sw.szSwtitle[MAXNAMEL-1] = 0;

            WinQueryWindowProcess(sw.hwnd, &pid, &tid);

            WinChangeSwitchEntry(hsw, &sw);
        }
        Win16SetTitle(0, title);
    }
#elif defined (__NT__)
    SetConsoleTitle(title);
#endif
}

void draw_hline(int x1, int x2, int y, char col)
{
    if (x2 <= x1) return;

#ifdef __linux__
    {
    int num;

    writechr(x1,y,ACS_LTEE,col);
    writechr(x2,y,ACS_RTEE,col);
    for (num=x1+1; num<=x2-1; num++) writechr(num,y,ACS_HLINE,col);
    }
#else
    {
    char tmp[256];

    memset(tmp,'',x2-x1-1);
    tmp[x2-x1-1] = '\0';
    cwritexy(x1+1,y,tmp,col);

    writechr(x1,y,'',col);
    writechr(x2,y,'',col);
    }
#endif
}

void _draw_hline(int x1, int x2, int y, char col)
{
    if (x2 < x1) return;

#ifdef __linux__
    {
    int num;

    for (num=x1; num<=x2; num++) writechr(num,y,ACS_HLINE,col);
    }
#else
    {
    char tmp[256];

    memset(tmp,'',x2-x1+1);
    tmp[x2-x1+1] = '\0';
    cwritexy(x1,y,tmp,col);
    }
#endif
}
