#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "shell.h"
#include "scrolbox.h"
#include "keyb.h"
#include "screen.h"
#include "scrsaver.h"

unsigned scroll_box(SCROLL_BOX *box)
{
    int index, draw_max;
    char quit,ch;

    draw_max = box->yend-box->ystart+1;

    for (index = 0; index < draw_max; index++)
    {
        box->draw_func(index+box->ystart, index+box->upy+1);
    }

    quit = 0;
    tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
    while ( !quit )
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch ( ch )
            {
                case 0:
                    ch = sk_getch();
                    switch ( ch )
                    {
                        case '$':
                            /* Shell to OS */
                            shell_dos();
                            break;
                        case 'H':
                            /* Up */
                            if ( box->ypos + box->upy > 1 )
                            {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                if ( box->ypos == 1 )
                                {
                                    box->upy--;
                                    scroll_down( box->xstart, box->ystart, box->xend, box->yend );
                                    box->draw_func( box->ystart, box->ypos + box->upy );
                                }
                                else
                                {
                                    box->ypos--;
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        case 'P':
                            /* Down */
                            if ( box->ypos + box->upy < *box->lines ) {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                if ( box->ypos == box->yend - box->ystart + 1 )
                                {
                                    box->upy++;
                                    scroll_up( box->xstart, box->ystart, box->xend, box->yend );
                                    box->draw_func( box->yend, box->ypos + box->upy );
                                }
                                else
                                {
                                    box->ypos++;
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        case 'I':
                            /* PgUp */
                            if ( box->ypos + box->upy > 1 )
                            {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                if ( box->ypos == 1 )
                                {
                                    if (box->upy < box->yend-box->ystart) box->upy = 0; else box->upy -= box->yend-box->ystart;

                                    tbar( box->xstart, box->ystart, box->xend, box->yend, box->background_color );

                                    if ( *box->lines - box->upy > box->yend - box->ystart + 1 )
                                    {
                                        draw_max = box->yend - box->ystart + 1;
                                    }
                                    else
                                    {
                                        draw_max = *box->lines - box->upy;
                                    }

                                    for ( index = 0; index < draw_max; index++ )
                                    {
                                        box->draw_func( index + box->ystart, index + box->upy + 1 );
                                    }
                                }
                                else
                                {
                                    box->ypos = 1;
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        case 'Q':
                            /* PgDn */
                            if ( box->ypos + box->upy < *box->lines )
                            {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                if ( box->ypos == box->yend - box->ystart + 1 )
                                {
                                    box->upy += box->yend - box->ystart;
                                    if ( *box->lines - box->upy < box->ypos ) box->upy = *box->lines - box->ypos;

                                    tbar( box->xstart, box->ystart, box->xend, box->yend, box->background_color );

                                    if ( *box->lines - box->upy > box->yend - box->ystart + 1 )
                                    {
                                        draw_max = box->yend - box->ystart + 1;
                                    }
                                    else
                                    {
                                        draw_max = *box->lines - box->upy;
                                    }

                                    for ( index = 0; index < draw_max; index++ )
                                    {
                                        box->draw_func( index + box->ystart, index + box->upy + 1 );
                                    }
                                }
                                else
                                {
                                    box->ypos = box->yend - box->ystart + 1;
                                    if (box->ypos+box->upy > *box->lines) box->ypos = *box->lines-box->upy;
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        case 'G':
                            /* Home */
                            if ( box->ypos + box->upy > 1 )
                            {
                                if ( box->upy == 0 )
                                {
                                    box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                }
                                else
                                {
                                    tbar( box->xstart, box->ystart, box->xend, box->yend, box->background_color );

                                    if ( *box->lines > box->yend - box->ystart + 1 )
                                    {
                                        draw_max = box->yend - box->ystart + 1;
                                    }
                                    else
                                    {
                                        draw_max = *box->lines;
                                    }

                                    for ( index = 0; index < draw_max; index++ )
                                    {
                                        box->draw_func( index + box->ystart, index + 1 );
                                    }
                                }
                                box->ypos = 1; box->upy = 0;
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        case 'O':
                            /* End */
                            if ( box->ypos + box->upy < *box->lines ) {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                if ( *box->lines - box->upy <= box->yend - box->ystart + 1 )
                                {
                                    box->ypos = *box->lines - box->upy;
                                }
                                else
                                {
                                    box->ypos = box->yend - box->ystart + 1;
                                    box->upy = *box->lines - box->ypos;

                                    tbar( box->xstart, box->ystart, box->xend, box->yend, box->background_color );

                                    if ( *box->lines - box->upy > box->yend - box->ystart + 1 )
                                    {
                                        draw_max = box->yend - box->ystart + 1;
                                    }
                                    else
                                    {
                                        draw_max = *box->lines - box->upy;
                                    }

                                    for ( index = 0; index < draw_max; index++ )
                                    {
                                        box->draw_func( index + box->ystart, index + box->upy + 1 );
                                    }
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                            break;
                        default:
                            box->cur_key = box->first_key;
                            while (box->cur_key != NULL)
                            {
                                if (box->cur_key->key1 == 0 && box->cur_key->key2 == ch)
                                {
                                    /* Found! Execute function. */
                                    box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                    if (box->cur_key->func(box) == 1)
                                    {
                                        if (*box->lines == 0)
                                        {
                                            box->ypos = 0;
                                            box->upy = 0;
                                            quit = 1;
                                            break;
                                        }

                                        if (box->ypos+box->upy > *box->lines)
                                        {
                                            if (box->ypos > 1)
                                            {
                                                box->ypos--;
                                            }
                                            else
                                            {
                                                box->upy--;
                                            }
                                        }

                                        /* Redraw screen */
                                        for (index = 0; index < draw_max; index++)
                                        {
                                            box->draw_func(index+box->ystart, index+box->upy+1);
                                        }
                                        tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                                        break;
                                    }
                                    else
                                    {
                                        box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                        tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                                    }
                                }
                                box->cur_key = box->cur_key->next;
                            }
                            break;
                    }
                    break;
                case 13:
                    quit = 1;
                    break;
                case 27:
                    box->ypos = 0;
                    box->upy = 0;
                    quit = 1;
                    break;
                default:
                    box->cur_key = box->first_key;
                    while (box->cur_key != NULL)
                    {
                        if (toupper(box->cur_key->key1) == toupper(ch))
                        {
                            /* Found! Execute function. */
                            box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                            if (box->cur_key->func(box) == 1)
                            {
                                if (*box->lines == 0)
                                {
                                    box->ypos = 0;
                                    box->upy = 0;
                                    quit = 1;
                                    break;
                                }

                                if (box->ypos+box->upy > *box->lines)
                                {
                                    if (box->ypos > 1)
                                    {
                                        box->ypos--;
                                    }
                                    else
                                    {
                                        box->upy--;
                                    }
                                }

                                /* Redraw screen */
                                for (index = 0; index < draw_max; index++)
                                {
                                    box->draw_func(index+box->ystart, index+box->upy+1);
                                }
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                                break;
                            }
                            else
                            {
                                box->draw_func( box->ypos + box->ystart - 1, box->ypos + box->upy );
                                tattrbar( box->xstart, box->ystart+box->ypos-1, box->xend, box->ystart+box->ypos-1, box->scrollbar_color );
                            }
                        }
                        box->cur_key = box->cur_key->next;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    return box->ypos+box->upy;
}

void add_key(char key1, char key2, SCROLL_FUNC func, SCROLL_BOX *box)
{
    SCROLL_KEY *key;

    key = (SCROLL_KEY *) malloc(sizeof(SCROLL_KEY));
    if (box->cur_key != NULL) box->cur_key->next = key;
    if (box->first_key == NULL) box->first_key = key;
    box->cur_key = key;

    key->next = NULL;
    key->key1 = key1;
    key->key2 = key2;
    key->func = func;
}

void deinit_scroll_box(SCROLL_BOX *box)
{
    while (box->first_key != NULL)
    {
        box->cur_key = box->first_key->next;
        free(box->first_key);
        box->first_key = box->cur_key;
    }
}
