#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "pkt_bw.h"
#include "setpref2.h"
#include "vars.h"
#include "files.h"
#include "general.h"
#include "screen.h"
#include "readsets.h"
#include "keyb.h"
#include "scrsaver.h"
#include "shell.h"
#include "setup.h"

static char yes_txt[] = "Yes          ";
static char no_txt[] = "No           ";
static char yes_txt_def[] = "Default (Yes)";
static char no_txt_def[] = "Default (No) ";

offline_packet *bw;

char useiniarea;
unsigned short *iniarea;


char *yesno(unsigned short yes)
{
    if (yes > 0)
        return yes_txt;
    else
        return no_txt;
}

char *defyesno(unsigned short yes)
{
    if (yes > 0)
        return yes_txt_def;
    else
        return no_txt_def;
}

char *flagsr(unsigned short flag, unsigned short flagdef)
{
    if ((opt.rflags & flagdef) > 0)
        return defyesno(defopt.rflags & flag);
    else
        return yesno(opt.rflags & flag);
}

char *flagsw(unsigned short flag, unsigned short flagdef)
{
    if ((opt.wflags & flagdef) > 0)
        return defyesno(defopt.wflags & flag);
    else
        return yesno(opt.wflags & flag);
}

char *flagsw2(unsigned short flag, unsigned short flagdef)
{
    if ((opt.wflags2 & flagdef) > 0)
        return defyesno(defopt.wflags2 & flag);
    else
        return yesno(opt.wflags2 & flag);
}

void save_options(char type, char *area)
{
    char tmp[256],*pstr;
    unsigned num;
    FILE *F;
    char new_file,ok;
    size_t readed;
    PrefsRecord tmpopt;
    
    if (area != NULL) strcpy(opt.areatag,area);
    
    strcpy(tmp,setup.datapath);
    if (type == OPTIONS_DEFAULT)
        strcat(tmp,"default.ini");
    else
        strcat(strcat(tmp,mailpkt),".ini");
    
    if ((F = FileOpen(tmp,"r+b")) == NULL)
        if ((F = FileOpen(tmp,"w+b")) == NULL)
        {
            err_box("Can't create .ini file!");
            return;
        }
        else
            new_file = 1;
    else
        new_file = 0;
    
    fseek(F,0,SEEK_END);
    if (ftell(F) < (int) sizeof(opt)) new_file = 1;
    fseek(F,0,SEEK_SET);
    
    if (type == OPTIONS_AREAOVRRIDE)
    {
        if (new_file)
        {
            memcpy(&tmpopt, &opt, sizeof(tmpopt));
            load_options(OPTIONS_DEFAULT, (char *) 1);
            fwrite(&opt, sizeof(opt), 1, F);
            memcpy(&opt, &tmpopt, sizeof(opt));
        }

        if (useiniarea)
        {
            ok = 0;
            for (num=0; num<bw->areas; num++)
                if (iniarea[num] & 32768)
                {
                    if (bw->info.ver == 254)
                        pstr = bw->get_area_name(bw, num+1);
                    else
                        pstr = bw->get_area_tag(bw, num+1);
                    
                    ok = 0;
                    fseek(F,0,SEEK_SET);
                    readed = fread(&tmpopt,sizeof(tmpopt),1,F);
                    while (readed)
                    {
                        if (strcmp(tmpopt.areatag,pstr) == 0)
                        {
                            fseek(F,-sizeof(tmpopt),SEEK_CUR);
                            strcpy(opt.areatag,pstr);
                            fwrite(&opt,sizeof(opt),1,F);
                            ok = 1;
                            break;
                        }
                        readed = fread(&tmpopt,sizeof(tmpopt),1,F);
                    }
                    if (!ok)
                    {
                        strcpy(opt.areatag,pstr);
                        fwrite(&opt,sizeof(opt),1,F);
                        ok = 1;
                    }
                }
            if (ok)
            {
                fclose(F);
                return;
            }
        }

        if (new_file)
        {
            fwrite(&opt,sizeof(opt),1,F);
        }
        else
        {
            readed = fread(&tmpopt,sizeof(tmpopt),1,F);
            while (readed)
            {
                if (strcmp(tmpopt.areatag,area) == 0)
                {
                    fseek(F,-sizeof(tmpopt),SEEK_CUR);
                    break;
                }
                readed = fread(&tmpopt,sizeof(tmpopt),1,F);
            }
        }
    }

    fwrite(&opt,sizeof(opt),1,F);
    fclose(F);
}

void setup_preferences(void)
{
    void setup_preferences_default(char ovrride, char *area);
    void setup_preferences_pkt_override(char areaoverride);

    unsigned short cx,cy;
    char *oldscr;

    char ch,pos,quit;

    useiniarea = 0;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(8,10,39,14,color[col_box_frame],color[col_box_title],"Global");
    cwritexy(10,11,"Default preferences",color[col_box_text]);
    cwritexy(10,12,"Packet preference override",color[col_box_text]);
    cwritexy(10,13,"Msg area preference override",color[col_box_text]);
    tattrbar(9,11,38,11,color[col_box_select]);
    
    pos = 1; quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch (ch) {
                case 13:
                    switch (pos) {
                        case 1:
                            setup_preferences_default(OPTIONS_DEFAULT,NULL);
                            break;
                        case 2:
                            setup_preferences_pkt_override(0);
                            break;
                        case 3:
                            setup_preferences_pkt_override(1);
                            break;
                    }
                    break;
                case 27: pos = 0; quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(9,10+pos,38,10+pos,color[col_box_text]);
                            if (pos == 3) pos = 1; else pos++;
                            tattrbar(9,10+pos,38,10+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(9,10+pos,38,10+pos,color[col_box_text]);
                            if (pos == 1) pos = 3; else pos--;
                            tattrbar(9,10+pos,38,10+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}

void setup_preferences_default(char ovrride, char *area)
{
    void setup_preferences_read_mode_options(int def);
    void setup_preferences_entry_mode_options(int def);
    void setup_preferences_other_options(void);

    unsigned short cx,cy;
    char *oldscr;

    char ch,pos,quit;

    if (ovrride == OPTIONS_DEFAULT)
    {
        get_default_settings();
        memcpy(&defopt,&opt,sizeof(opt));
    }
    else if (ovrride == OPTIONS_PKTOVRRIDE)
    {
        load_options(OPTIONS_DEFAULT,NULL);
        memcpy(&defopt,&opt,sizeof(opt));
        get_default_settings();
        fill_default();
    }
    else
    {
        load_options(OPTIONS_PKTOVRRIDE,NULL);
        memcpy(&defopt,&opt,sizeof(opt));
        load_options(OPTIONS_DEFAULT,NULL);
        fill_default();
        get_default_settings();
        fill_default();
    }

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(10,12,41,16,color[col_box_frame],color[col_box_title],"Options");
    cwritexy(12,13,"Message read mode options",color[col_box_text]);
    cwritexy(12,14,"Message entry mode options",color[col_box_text]);
    cwritexy(12,15,"File names & other options",color[col_box_text]);
    tattrbar(11,13,40,13,color[col_box_select]);

    load_options(ovrride,area);
    pos = 1; quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    switch (pos)
                    {
                        case 1:
                            setup_preferences_read_mode_options(ovrride == OPTIONS_DEFAULT);
                            break;
                        case 2:
                            setup_preferences_entry_mode_options(ovrride == OPTIONS_DEFAULT);
                            break;
                        case 3:
                            setup_preferences_other_options();
                            break;
                    }
                    break;
                case 27: pos = 0; quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(11,12+pos,40,12+pos,color[col_box_text]);
                            if (pos == 3) pos = 1; else pos++;
                            tattrbar(11,12+pos,40,12+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(11,12+pos,40,12+pos,color[col_box_text]);
                            if (pos == 1) pos = 3; else pos--;
                            tattrbar(11,12+pos,40,12+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        }
        else
            give_timeslice();
    }
    draw_shaded_box(scrwidth/2-12,10,scrwidth/2+12,12,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(11, "Saving, please wait..", color[col_info_text]);
    save_options(ovrride,area);
    old_scr(cx,cy,&oldscr);
}

void nextr(unsigned short flag, unsigned short flagdef, int def)
{
    if ((opt.rflags & flag) > 0 && !def)
    {
        opt.rflags ^= flag;
        opt.rflags |= flagdef;
    }
    else
    {
        if ((opt.rflags & flagdef) > 0)
            opt.rflags ^= flagdef;
        else
            opt.rflags ^= flag;
    }
}

void setup_preferences_read_mode_options(int def)
{
    unsigned short cx,cy,cx2,cy2;
    char *oldscr,*oldscr2;
    
    char quit,pos,ch,tmp[21];
    
    char *sorttable[4] = {
        "None             ","Subject          ",
        "From             ","To               "
    };
    char *sorttable2[4] = {
        "None","Subject","From","To"
    };
    
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(12,13,66,24,color[col_box_frame],color[col_box_title],"Read mode options");
    
    cwritexy(14,14,"Automatically to title scan  :",color[col_box_text]);
    cwritexy(14,15,"Personal mail scan           :",color[col_box_text]);
    cwritexy(14,16,"Beep on personal messages    :",color[col_box_text]);
    cwritexy(14,17,"Read msgs sorted on          :",color[col_box_text]);
    cwritexy(14,18,"Automatic area advantage     :",color[col_box_text]);
    cwritexy(14,19,"Only display areas with msgs :",color[col_box_text]);
    cwritexy(14,20," - only with unread msgs     :",color[col_box_text]);
    cwritexy(14,21,"Treat '' as normal char     :",color[col_box_text]);
    cwritexy(14,22,"Strip RE: from subjects      :",color[col_box_text]);
    cwritexy(14,23,"Inbound translation table    :",color[col_box_text]);
    
    if (opt.sort_msgs > 4) opt.sort_msgs = MSGSORT_SUBJ;
    opt.intable[20] = 0;
    
    cwritexy(45,14,flagsr(AUTO_TITLE_SCAN,AUTO_TITLE_DEFAULT),color[col_box_hilight]);
    cwritexy(45,15,flagsr(AUTO_MAIL_SCAN,AUTO_MAIL_DEFAULT),color[col_box_hilight]);
    cwritexy(45,16,flagsr(NOICE_PERSONAL,NOICE_PERS_DEFAULT),color[col_box_hilight]);
    if (opt.sort_msgs == MSGSORT_DEF) {
        sprintf(tmp,"Default (%s)",sorttable2[defopt.sort_msgs]);
        cwritexy(45,17,tmp,color[col_box_hilight]);
    } else
        cwritexy(45,17,sorttable[opt.sort_msgs],color[col_box_hilight]);
    cwritexy(45,18,flagsr(AUTO_ADVANTAGE,AUTO_ADV_DEFAULT),color[col_box_hilight]);
    cwritexy(45,19,flagsr(AREAS_ONLY_MSGS,AREAS_ONLY_MSGS_DEFAULT),color[col_box_hilight]);
    cwritexy(45,20,flagsr(AREAS_ONLY_UNREAD_MSGS,AREAS_ONLY_UNREAD_MSGS_DEFAULT),color[col_box_hilight]);
    cwritexy(45,21,flagsr(TREAT_I_NORMAL,TREAT_I_DEFAULT),color[col_box_hilight]);
    cwritexy(45,22,flagsr(STRIP_RE,STRIP_RE_DEFAULT),color[col_box_hilight]);
    if ((opt.defaults & DEFAULT_INTABLE) == 0) {
        writechr(44,23,'*',color[col_box_scroll]);
        cwritexy(45,23,opt.intable,color[col_box_hilight]);
    } else cwritexy(45,23,defopt.intable,color[col_box_hilight]);
    
    tattrbar(13,14,41,14,color[col_box_select]);
    pos = 1; quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch (ch) {
                case 13:
                    switch (pos) {
                        case 1:
                            nextr(AUTO_TITLE_SCAN,AUTO_TITLE_DEFAULT,def);
                            cwritexy(45,14,flagsr(AUTO_TITLE_SCAN,AUTO_TITLE_DEFAULT),color[col_box_hilight]);
                            break;
                        case 2:
                            nextr(AUTO_MAIL_SCAN,AUTO_MAIL_DEFAULT,def);
                            cwritexy(45,15,flagsr(AUTO_MAIL_SCAN,AUTO_MAIL_DEFAULT),color[col_box_hilight]);
                            break;
                        case 3:
                            nextr(NOICE_PERSONAL,NOICE_PERS_DEFAULT,def);
                            cwritexy(45,16,flagsr(NOICE_PERSONAL,NOICE_PERS_DEFAULT),color[col_box_hilight]);
                            break;
                        case 4:
                            if (opt.sort_msgs >= 4-def)
                                opt.sort_msgs = 0;
                            else
                                opt.sort_msgs++;
                            
                            if (opt.sort_msgs == MSGSORT_DEF) {
                                sprintf(tmp,"Default (%s)",sorttable2[defopt.sort_msgs]);
                                cwritexy(45,17,tmp,color[col_box_hilight]);
                            } else
                                cwritexy(45,17,sorttable[opt.sort_msgs],color[col_box_hilight]);
                            break;
                        case 5:
                            nextr(AUTO_ADVANTAGE,AUTO_ADV_DEFAULT,def);
                            cwritexy(45,18,flagsr(AUTO_ADVANTAGE,AUTO_ADV_DEFAULT),color[col_box_hilight]);
                            break;
                        case 6:
                            nextr(AREAS_ONLY_MSGS,AREAS_ONLY_MSGS_DEFAULT,def);
                            cwritexy(45,19,flagsr(AREAS_ONLY_MSGS,AREAS_ONLY_MSGS_DEFAULT),color[col_box_hilight]);
                            break;
                        case 7:
                            nextr(AREAS_ONLY_UNREAD_MSGS,AREAS_ONLY_UNREAD_MSGS_DEFAULT,def);
                            cwritexy(45,20,flagsr(AREAS_ONLY_UNREAD_MSGS,AREAS_ONLY_UNREAD_MSGS_DEFAULT),color[col_box_hilight]);
                            break;
                        case 8:
                            nextr(TREAT_I_NORMAL,TREAT_I_DEFAULT,def);
                            cwritexy(45,21,flagsr(TREAT_I_NORMAL,TREAT_I_DEFAULT),color[col_box_hilight]);
                            break;
                        case 9:
                            nextr(STRIP_RE,STRIP_RE_DEFAULT,def);
                            cwritexy(45,22,flagsr(STRIP_RE,STRIP_RE_DEFAULT),color[col_box_hilight]);
                            break;
                        case 10:
                            key_xpos = 0;
                            save_scr(&cx2,&cy2,&oldscr2);
                            tbar(1,scrsize,scrwidth,scrsize,color[col_info_text]);
                            cwritexy(1,scrsize,"F10 - Use default, Enter - Save field",color[col_info_text]);
                            if (opt.defaults & DEFAULT_INTABLE)
                                strcpy(opt.intable,defopt.intable);
                            ch = get_string(45,23,20,20,opt.intable,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            old_scr(cx2,cy2,&oldscr2);
                            if (ch == 3)
                            {
                                writechr(44,23,' ',color[col_box_scroll]);
                                tbar(45,23,65,23,color[col_box_hilight]);
                                cwritexy(45,23,defopt.intable,color[col_box_hilight]);
                                opt.defaults |= DEFAULT_INTABLE;
                            }
                            else
                            {
                                writechr(44,23,'*',color[col_box_scroll]);
                                tbar(45,23,65,23,color[col_box_hilight]);
                                cwritexy(45,23,opt.intable,color[col_box_hilight]);
                                opt.defaults &= ~DEFAULT_INTABLE;
                            }
                            break;
                    }
                    break;
                case 27: quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$':
                            shell_dos();
                            break;
                        case 'D':
                            if (pos == 9)
                            {
                                transtable(opt.intable,NULL);
                                cwritexy(45,23,defopt.intable,color[col_box_hilight]);
                                writechr(44,23,' ',color[col_box_scroll]);
                                opt.defaults &= ~DEFAULT_INTABLE;
                            }
                            break;
                        case 'P':
                            tattrbar(13,13+pos,41,13+pos,color[col_box_text]);
                            if (pos == 10) pos = 1; else pos++;
                            tattrbar(13,13+pos,41,13+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(13,13+pos,41,13+pos,color[col_box_text]);
                            if (pos == 1) pos = 10; else pos--;
                            tattrbar(13,13+pos,41,13+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}

void nextw(char flag, char flagdef, int def)
{
    if (opt.wflags & flag && !def)
    {
        opt.wflags ^= flag;
        opt.wflags |= flagdef;
    }
    else
    {
        if (opt.wflags & flagdef)
            opt.wflags ^= flagdef;
        else
            opt.wflags ^= flag;
    }
}

void nextw2(unsigned short flag, unsigned short flagdef, int def)
{
    if (opt.wflags2 & flag && !def)
    {
        opt.wflags2 ^= flag;
        opt.wflags2 |= flagdef;
    }
    else
    {
        if (opt.wflags2 & flagdef)
            opt.wflags2 ^= flagdef;
        else
            opt.wflags2 ^= flag;
    }
}

void setup_preferences_entry_mode_options(int def)
{
    unsigned short cx,cy,cx2,cy2;
    char *oldscr,*oldscr2;
    
    char quit,pos,ch,tmp[20];
    
    char *sorttable[4] = {
        "None             ","To               ",
        "Area             ","Subject          "
    };
    char *sorttable2[4] = {
        "None","To","Area","Subject"
    };
    
    char *quotetable[4] = {
        "JS>TS>             ",">>>>>>             ",
        "TS>>>>             "," JS> TS>           "
    };
    char *quotetable2[4] = {
        "JS>TS>",">>>>>>","TS>>>"," JS> TS>"
    };

    char *tagtable[5] = {
        "None                 ","Random               ",
        "Prompt               ","Manual               ",
        "External             "
    };
    char *tagtable2[5] = {
        "None","Random","Prompt","Manual","External"
    };
    
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(12,12,66,24,color[col_box_frame],color[col_box_title],"Entry mode options");
    
    cwritexy(14,13,"Insert quote header          :",color[col_box_text]);
    cwritexy(14,14," - Only when orig not to you :",color[col_box_text]);
    cwritexy(14,15,"Insert \"subject changed\" hdr :",color[col_box_text]);
    cwritexy(14,16,"Automatically save new msgs  :",color[col_box_text]);
    cwritexy(14,17,"Quote style                  :",color[col_box_text]);
    cwritexy(14,18,"Read replies sorted on       :",color[col_box_text]);
    cwritexy(14,19,"Tagline usage                :",color[col_box_text]);
    cwritexy(14,20,"Quote header                 :",color[col_box_text]);
    cwritexy(14,21,"Auto split msg to # lines    :",color[col_box_text]);
    cwritexy(14,22,"Quoting: Remove spaces       :",color[col_box_text]);
    cwritexy(14,23,"Outbound translation table   :",color[col_box_text]);
    
    if (opt.quote > 4) opt.quote = QUOTE_GOLDED;
    if (opt.replysort > 4) opt.replysort = REPLYSORT_AREA;
    if (opt.taglines > 5) opt.taglines = TAGLINE_PROMPT;
    opt.quotehdr[sizeof(opt.quotehdr)-1] = 0;
    opt.outtable[sizeof(opt.outtable)-1] = 0;
    
    cwritexy(45,13,flagsw(INSERT_QUOTE,INSERT_QUOTE_DEFAULT),color[col_box_hilight]);
    cwritexy(45,14,flagsw(QUOTE_NOT4U,QUOTE_NOT4U_DEFAULT),color[col_box_hilight]);
    cwritexy(45,15,flagsw2(SUBJ_HEADER,SUBJ_HEADER_DEFAULT),color[col_box_hilight]);
    cwritexy(45,16,flagsw(AUTO_SAVE,AUTO_SAVE_DEFAULT),color[col_box_hilight]);
    if (opt.quote == QUOTE_DEFAULT)
    {
        sprintf(tmp,"Default (%s)",quotetable2[defopt.quote]);
        cwritexy(45,17,tmp,color[col_box_hilight]);
    }
    else
    {
        cwritexy(45,17,quotetable[opt.quote],color[col_box_hilight]);
    }
    if (opt.replysort == REPLYSORT_DEF)
    {
        sprintf(tmp,"Default (%s)",sorttable2[defopt.replysort]);
        cwritexy(45,18,tmp,color[col_box_hilight]);
    }
    else
    {
        cwritexy(45,18,sorttable[opt.replysort],color[col_box_hilight]);
    }

    if (opt.taglines == TAGLINE_DEFAULT)
    {
        sprintf(tmp,"Default (%s)",tagtable2[defopt.taglines]);
        cwritexy(45,19,tmp,color[col_box_hilight]);
    }
    else
    {
        cwritexy(45,19,tagtable[opt.taglines],color[col_box_hilight]);
    }
    
    if (opt.defaults & DEFAULT_QUOTEHDR)
    {
        ch = defopt.quotehdr[20]; defopt.quotehdr[20] = 0;
        cwritexy(45,20,defopt.quotehdr,color[col_box_hilight]);
        defopt.quotehdr[20] = ch;
    }
    else
    {
        writechr(44,20,'*',color[col_box_scroll]);
        ch = opt.quotehdr[20]; opt.quotehdr[20] = 0;
        cwritexy(45,20,opt.quotehdr,color[col_box_hilight]);
        opt.quotehdr[20] = ch;
    }
    if (opt.defaults & DEFAULT_AUTOSPLIT)
    {
        sprintf(tmp,"%d",defopt.autosplit);
        cwritexy(45,21,tmp,color[col_box_hilight]);
    }
    else
    {
        writechr(44,21,'*',color[col_box_scroll]);
        sprintf(tmp,"%d",opt.autosplit);
        cwritexy(45,21,tmp,color[col_box_hilight]);
    }
    cwritexy(45,22,flagsw(REMOVE_SPACES,REMOVE_SPACES_DEFAULT),color[col_box_hilight]);
    if (opt.defaults & DEFAULT_OUTTABLE)
    {
        cwritexy(45,23,defopt.outtable,color[col_box_hilight]);
    }
    else
    {
        writechr(44,23,'*',color[col_box_scroll]);
        cwritexy(45,23,opt.outtable,color[col_box_hilight]);
    }

    tattrbar(13,13,41,13,color[col_box_select]);
    pos = 1; quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    switch (pos)
                    {
                        case 1:
                            nextw(INSERT_QUOTE,INSERT_QUOTE_DEFAULT,def);
                            cwritexy(45,13,flagsw(INSERT_QUOTE,INSERT_QUOTE_DEFAULT),color[col_box_hilight]);
                            break;
                        case 2:
                            nextw(QUOTE_NOT4U,QUOTE_NOT4U_DEFAULT,def);
                            cwritexy(45,14,flagsw(QUOTE_NOT4U,QUOTE_NOT4U_DEFAULT),color[col_box_hilight]);
                            break;
                        case 3:
                            nextw2(SUBJ_HEADER,SUBJ_HEADER_DEFAULT,def);
                            cwritexy(45,15,flagsw2(SUBJ_HEADER,SUBJ_HEADER_DEFAULT),color[col_box_hilight]);
                            break;
                        case 4:
                            nextw(AUTO_SAVE,AUTO_SAVE_DEFAULT,def);
                            cwritexy(45,16,flagsw(AUTO_SAVE,AUTO_SAVE_DEFAULT),color[col_box_hilight]);
                            break;
                        case 5:
                            if (opt.quote >= QUOTE_DEFAULT-def)
                                opt.quote = 0;
                            else
                                opt.quote++;

                            if (opt.quote == QUOTE_DEFAULT)
                            {
                                sprintf(tmp,"Default (%s)",quotetable2[defopt.quote]);
                                cwritexy(45,17,tmp,color[col_box_hilight]);
                            } else
                                cwritexy(45,17,quotetable[opt.quote],color[col_box_hilight]);
                            break;
                        case 6:
                            if (opt.replysort >= 4-def)
                                opt.replysort = 0;
                            else
                                opt.replysort++;
                            
                            if (opt.replysort == REPLYSORT_DEF) {
                                sprintf(tmp,"Default (%s)",sorttable2[defopt.replysort]);
                                cwritexy(45,18,tmp,color[col_box_hilight]);
                            } else
                                cwritexy(45,18,sorttable[opt.replysort],color[col_box_hilight]);
                            break;
                        case 7:
                            if (opt.taglines >= 5-def)
                                opt.taglines = 0;
                            else
                                opt.taglines++;
                            
                            if (opt.taglines == TAGLINE_DEFAULT) {
                                sprintf(tmp,"Default (%s)",tagtable2[defopt.taglines]);
                                cwritexy(45,19,tmp,color[col_box_hilight]);
                            } else
                                cwritexy(45,19,tagtable[opt.taglines],color[col_box_hilight]);
                            break;
                        case 8:
                            key_xpos = 0;
                            save_scr(&cx2,&cy2,&oldscr2);
                            tbar(1,scrsize,scrwidth,scrsize,color[col_info_text]);
                            cwritexy(1,scrsize,"F10 - Use default, Enter - Save field",color[col_info_text]);
                            if (opt.defaults & DEFAULT_QUOTEHDR)
                                strcpy(opt.quotehdr,defopt.quotehdr);
                            ch = get_string(45,20,sizeof(opt.quotehdr)-1,20,opt.quotehdr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            old_scr(cx2,cy2,&oldscr2);
                            if (ch == 3)
                            {
                                writechr(44,20,' ',color[col_box_scroll]);
                                tbar(45,20,65,20,color[col_box_hilight]);
                                ch = defopt.quotehdr[20]; defopt.quotehdr[20] = 0;
                                cwritexy(45,20,defopt.quotehdr,color[col_box_hilight]);
                                defopt.quotehdr[20] = ch;
                                opt.defaults |= DEFAULT_QUOTEHDR;
                            }
                            else
                            {
                                writechr(44,20,'*',color[col_box_scroll]);
                                tbar(45,20,65,20,color[col_box_hilight]);
                                ch = opt.quotehdr[20]; opt.quotehdr[20] = 0;
                                cwritexy(45,20,opt.quotehdr,color[col_box_hilight]);
                                opt.quotehdr[20] = ch;
                                opt.defaults &= ~DEFAULT_QUOTEHDR;
                            }
                            break;
                        case 9:
                            key_xpos = 0;
                            save_scr(&cx2,&cy2,&oldscr2);
                            tbar(1,scrsize,scrwidth,scrsize,color[col_info_text]);
                            cwritexy(1,scrsize,"F10 - Use default, Enter - Save field",color[col_info_text]);
                            if (opt.defaults & DEFAULT_AUTOSPLIT)
                                sprintf(tmp,"%d",defopt.autosplit);
                            else
                                sprintf(tmp,"%d",opt.autosplit);
                            ch = get_string(45,21,5,5,tmp,128+8+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            old_scr(cx2,cy2,&oldscr2);
                            if (ch == 3)
                            {
                                opt.defaults |= DEFAULT_AUTOSPLIT;
                                tbar(45,21,50,21,color[col_box_hilight]);
                                writechr(44,21,' ',color[col_box_scroll]);
                                sprintf(tmp,"%d",defopt.autosplit);
                                cwritexy(45,21,tmp,color[col_box_hilight]);
                            }
                            else
                            {
                                opt.defaults &= ~DEFAULT_AUTOSPLIT;
                                opt.autosplit = (unsigned short) atoi(tmp);
                                tbar(45,21,50,21,color[col_box_hilight]);
                                writechr(44,21,'*',color[col_box_scroll]);
                                sprintf(tmp,"%d",opt.autosplit);
                                cwritexy(45,21,tmp,color[col_box_hilight]);
                            }
                            break;
                        case 10:
                            nextw(REMOVE_SPACES,REMOVE_SPACES_DEFAULT,def);
                            cwritexy(45,22,flagsw(REMOVE_SPACES,REMOVE_SPACES_DEFAULT),color[col_box_hilight]);
                            break;
                        case 11:
                            key_xpos = 0;
                            save_scr(&cx2,&cy2,&oldscr2);
                            tbar(1,scrsize,scrwidth,scrsize,color[col_info_text]);
                            cwritexy(1,scrsize,"F10 - Use default, Enter - Save field",color[col_info_text]);
                            if (opt.defaults & DEFAULT_OUTTABLE)
                                strcpy(opt.outtable,defopt.outtable);
                            ch = get_string(45,23,20,20,opt.outtable,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            old_scr(cx2,cy2,&oldscr2);
                            if (ch == 3)
                            {
                                tbar(45,23,65,23,color[col_box_hilight]);
                                writechr(44,23,' ',color[col_box_scroll]);
                                cwritexy(45,23,defopt.outtable,color[col_box_hilight]);
                                opt.defaults |= DEFAULT_OUTTABLE;
                            }
                            else
                            {
                                writechr(44,23,'*',color[col_box_scroll]);
                                cwritexy(45,23,opt.outtable,color[col_box_hilight]);
                                opt.defaults &= ~DEFAULT_OUTTABLE;
                            }
                            break;
                    }
                    break;
                case 27:
                    quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(13,12+pos,41,12+pos,color[col_box_text]);
                            if (pos == 11) pos = 1; else pos++;
                            tattrbar(13,12+pos,41,12+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(13,12+pos,41,12+pos,color[col_box_text]);
                            if (pos == 1) pos = 11; else pos--;
                            tattrbar(13,12+pos,41,12+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}

void setup_preferences_other_options(void)
{
    unsigned short cx,cy;
    char *oldscr;
    
    char *pstr,oldone[256];
    int info, pos;
    
    char *pointers[7] = {
        opt.signature,
        opt.savefile,
        opt.replysave,
        opt.tagfile,
        opt.adoptfile,
        opt.alias,
        opt.editor
    };
    unsigned long defaults[7] = {
        DEFAULT_SIGNATURE,
        DEFAULT_SAVEFILE,
        DEFAULT_REPLYSAVE,
        DEFAULT_TAGFILE,
        DEFAULT_ADOPTFILE,
        DEFAULT_ALIAS,
        DEFAULT_EDITOR
    };
    
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(12,14,70,22,color[col_box_frame],color[col_box_title],"Read mode options");
    for (pos=0; pos<7; pos++) {
        if ((opt.defaults & defaults[pos]) != 0) {
            pstr = pointers[pos];
            strcpy(pstr,(char *) ((long) &defopt+(long) pstr-(long) &opt));
        }
        else
            writechr(33,15+pos,'*',color[col_box_scroll]);
        pstr = pointers[pos];
        info = pstr[35]; pstr[35] = 0;
        cwritexy(34,15+pos,pstr,color[col_box_hilight]);
        pstr[35] = info;
    }
    tbar(1,scrsize,scrwidth,scrsize,color[col_info_text]);
    cwritexy(1,scrsize,"F10 - Use default, Enter - Save field, ESC - Quit",color[col_info_text]);
    cwritexy(14,15,"Signature file    :",color[col_box_text]);
    cwritexy(14,16,"Save msgs to file :",color[col_box_text]);
    cwritexy(14,17,"Reply save file   :",color[col_box_text]);
    cwritexy(14,18,"Tagline file      :",color[col_box_text]);
    cwritexy(14,19,"Tagl. adopt file  :",color[col_box_text]);
    cwritexy(14,20,"Your alias name   :",color[col_box_text]);
    cwritexy(14,21,"Editor cmd line   :",color[col_box_text]);
    pos = 1; pstr = opt.signature;
    key_xpos = 0;
    do {
        if (opt.defaults & defaults[pos-1])
            strcpy(pstr,(char *) ((long) &defopt+(long) pstr-(long) &opt));

        strcpy(oldone, pstr);
        if (pos == 6)
            info = get_string(34,14+pos,35,35,pstr,128+8+4,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
        else
            info = get_string(34,14+pos,80,35,pstr,128+8+4,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
        switch (info)
        {
            case 0:
                writechr(33,14+pos,'*',color[col_box_scroll]);
                opt.defaults &= ~defaults[pos-1];
            case 1:
                if (strcmp(oldone, pstr) != 0)
                {
                    writechr(33,14+pos,'*',color[col_box_scroll]);
                    opt.defaults &= ~defaults[pos-1];
                }
                if (pos == 7) pos = 1; else pos++;
                key_xpos = 0;
                pstr = pointers[pos-1];
                break;
            case 2:
                if (strcmp(oldone, pstr) != 0)
                {
                    writechr(33,14+pos,'*',color[col_box_scroll]);
                    opt.defaults &= ~defaults[pos-1];
                }
                if (pos == 1) pos = 7; else pos--;
                key_xpos = 0;
                pstr = pointers[pos-1];
                break;
            case 3:
                tbar(34,14+pos,69,14+pos,color[col_box_hilight]);
                writechr(33,14+pos,' ',color[col_box_scroll]);
                cwritexy(34,14+pos,(char *) ((long) &defopt+(long) pstr-(long) &opt),color[col_box_hilight]);
                opt.defaults |= defaults[pos-1];
                
                if (pos == 7) pos = 1; else pos++;
                key_xpos = 0;
                pstr = pointers[pos-1];
                break;
        }
    }
    while (info != 5);

    if (strcmp(oldone, pstr) != 0)
    {
        writechr(33,14+pos,'*',color[col_box_scroll]);
        opt.defaults &= ~defaults[pos-1];
    }

    old_scr(cx,cy,&oldscr);
}

void setup_preferences_pkt_override(char areaoverride)
{
    if (select_packet(1,mailpkt) == NULL) return;
    
    if (areaoverride)
        select_area();
    else
        setup_preferences_default(OPTIONS_PKTOVRRIDE,NULL);
}

