#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include "crc.h"

#ifdef __linux__
#  define O_BINARY 0
#endif

unsigned char CRCSTRING[] = "\x36\x56\x51\x41\x66\x82\xb2"; /* 6VQAf */

int main(int argc, char *argv[])
{
    unsigned long CRC,seekpos;
    int hFile,iReaded,iReadPos,pos,already;
    unsigned char buf[256],*strp;

    if (argc != 2)
    {
        printf("Usage: crc <filename>\n");
        return 1;
    }

    hFile = open(argv[1], O_RDWR | O_BINARY);
    if (hFile == -1)
    {
        printf("Can't open file '%s'\n",argv[1]);
        return 0;
    }
    printf("Creating CRC for file: %s\n",argv[1]);

    pos = 0; CRC = 0xffffffff; seekpos = 0; already = 0;
    for (;;)
    {
        iReaded = read(hFile, buf, sizeof(buf));
        if (iReaded == 0) break;

        strp = buf; iReadPos = 0;
        while (iReadPos < iReaded)
        {
            if (pos < 0)
            {
                if (pos == -1) { seekpos = lseek(hFile, 0, SEEK_CUR)-iReaded+iReadPos; pos--; }
                else if (pos > -4) pos--;
                else { pos = 0; already = 1; }
            }
            else
            {
                CalcCRC(CRC, *strp);
                if (pos != 255)
                {
                    if (*strp == CRCSTRING[pos])
                    {
                        pos++;
                        if (pos == sizeof(CRCSTRING)-1)
                        {
                            if (already)
                            {
                                printf("ERRORR!!! Sama stringi kahdesti!!\n");
                                return 1;
                            }
                            pos = -1; /* Found CRC position! */
                        }
                    }
                    else
                    {
                        pos = 0;
                    }
                }
            }
            strp++; iReadPos++;
        }
    }

    if (seekpos == 0)
    {
        close(hFile);
        printf("Didn't find CRC position!!\n");
        return 1;
    }

    lseek(hFile, seekpos, SEEK_SET);
    if (write(hFile, &CRC, 4) != 4)
    {
        close(hFile);
        printf("Error writing CRC!!\n");
        return 1;
    }
    printf("OK. CRC: %04lx\n", CRC);

    close(hFile);

    return 0;
}
