#define LangLines 334
#define NumColors 126

#ifdef __OS2__
#  define INCL_WINWORKPLACE
#  include <os2.h>
#endif

#include <stdio.h>
#include <sys/stat.h>

#ifdef __NT__
#  include <windows.h>
extern HANDLE scrHandle;
#endif

#include "scrsaver.h"
#include "screen.h"
#include "shell.h"
#include "files.h"
#include "keyb.h"
#include "vars.h"
#include "version.h"

char keep_video_mode = 1;

char box_ypos;

void reader_info(void) {}

#ifdef __linux__
#include <ctype.h>
char *strupr(char *str)
{
    register char *pstr;

    pstr = str;
    while (*pstr != '\0')
    {
        *pstr = toupper(*pstr);
        pstr++;
    }

    return str;
}
#endif

void printtxt(char *txt, char col)
{
    cwritexy(6,box_ypos,txt,(1<<4)+col);
    if (box_ypos == 11)
    {
        scroll_up(6,4,74,11);
        tbar(6,11,74,11,1<<4);
    }
    else
        box_ypos++;
}

void err_box(char *text)
{
    unsigned short cx,cy;
    char *oldscr;
    int slen;

    slen = strlen(text);
    if (slen == 0) return;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,14,color[col_warn_frame],color[col_warn_title],"Error!");
    cmiddle(12,text,color[col_warn_hilight]);
    if (sk_getch() == 0) sk_getch();
    old_scr(cx,cy,&oldscr);
#ifdef __linux__
    gotoxy(1,scrsize);
#endif
}

int selobj(char *title, char *yes, char *no)
{
    char ch;
    int ypos, quit;

    draw_shaded_box(22,10,58,16,(1<<4)+9,0,NULL);
    cmiddle(12,title,(1<<4)+15);
    cmiddle(13,yes,(1<<4)+11);
    cmiddle(14,no,(1<<4)+11);

    quit = 0; ypos = 0;
    tattrbar(26,13+ypos,54,13+ypos,7<<4);
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    if ((ch == 'P') || (ch == 'H'))
                    {
                        tattrbar(26,13+ypos,54,13+ypos,(1<<4)+11);
                        ypos = 1-ypos;
                        tattrbar(26,13+ypos,54,13+ypos,7<<4);
                    }
                    break;
            }
        }
        else
            give_timeslice();
    }

    return ypos;
}

int main(void)
{
    unsigned short cx,cy;
    char *oldscr;

#ifndef __linux__
    char tmp2[256];
#else
    unsigned x;
#endif
    char directory[256],slen;
    char tmp[256],*pstr,language_file,ypos;
    unsigned y;
    int num, errlvl;

    FILE *F;

/*#ifdef __linux__
    if (stat("/usr/share/terminfo", &statbuf) != 0)
    {
        printf("\n/usr/share/terminfo does not exist - type:\n");
        printf("ln -s /usr/lib/terminfo /usr/share/terminfo\n\n");
        return 1;
    }
#endif*/

#ifdef __NT__
    InitScreen();
    KbdInit();
#endif
#ifdef __linux__
    InitScreen();
#endif
    nocursor();

    tbar(1,1,scrwidth,1,(1<<4)+11);
    cmiddle(1," "Reader_Name" v"version" ",(1<<4)+11);

    clockcolor = (1<<4)+10; showclock = 1;
#ifdef __linux__
    for (y=2; y<=scrsize; y++)
    {
        for (x=1; x<=scrwidth; x++)
        {
            writechr(x,y,ACS_CKBOARD,7);
        }
    }
#else
    memset(tmp,'',scrwidth); tmp[scrwidth] = '\0';
    for (y=2; y<=scrsize; y++)
        cwritexy(1,y,tmp,7);
#endif

    draw_shaded_box(scrwidth/2-35,15,scrwidth/2+36,21,(1<<4)+9,(1<<4)+15,""Reader_Name" v"version"");
    cmiddle(17,"Blue Wave, QWK, OMEN, SOUP & Hippo v2 Compatible Offline Mail Reader",(1<<4)+7);
    cmiddle(19,COPYRIGHT,(1<<4)+15);
    draw_clock();

    draw_shaded_box(5,3,77,12,(1<<4)+9,(1<<4)+15,"SkyReader Installation");
#ifdef __linux__
    cmiddle(5,"Directory where to install SkyReader executable:",(1<<4)+11);
#else
    cmiddle(5,"Directory where to install SkyReader:",(1<<4)+11);
#endif

    /* Ask destination path */
#ifdef __linux__
    strcpy(directory,"/usr/local/bin");
#else
    strcpy(directory,"C:\\SKYREAD");
#endif
__ask_destination:
    get_string(7,7,255,68,directory,0,(1<<4)+15,(1<<4)+7,(1<<4)+10);

    /* Take off extra slash */
    slen = strlen(directory)-1;
    if (directory[slen] == SLASH) directory[slen] = '\0';

    /* Create directory */
    if (!isdir(directory))
    {
        if (!mkpath(directory))
        {
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(15,10,65,14,(4<<4)+12,0,NULL);
            cmiddle(12,"Could not create directory! Try again.",(4<<4)+15);
            if (sk_getch() == 0) sk_getch();
            old_scr(cx,cy,&oldscr);
            goto __ask_destination;
        }
    }

    box_ypos = 9;
#ifdef __linux__
    printtxt(" * Installing rest of SkyReader in ~/.skyreader/ directory", 15);
    if (!mkpath("~/.skyreader"))
    {
        tclrscr();
        printf("Can't create directory ~/.skyreader\n");
        return 1;
    }
    box_ypos = 10;
#endif

    printtxt(" * Analyzing directory",15);

    /* Check colors.cfg file condition */
#ifdef __linux__
    F = FileOpen("~/.skyreader/colors.cfg","rb");
#else
    F = FileOpen(strcat(strcpy(tmp,directory),SSLASH"colors.cfg"),"rb");
#endif
    if (F != NULL)
    {
        num = 0;
        while (_fgets(tmp,sizeof(tmp),F) != NULL)
        {
            pstr = tmp;
            while (*pstr == ' ') pstr++;
            if (*pstr != '\0' && *pstr != ';') num++;
        }
        fclose(F);
        if (num != NumColors)
        {
            printtxt(" * colors.cfg file out of date, renaming to colors.bak",12);
#ifdef __linux__
            FileRemove("~/.skyreader/colors.bak");
            FileRename("~/.skyreader/colors.cfg", "~/.skyreader/colors.bak");
#else
            remove(strcat(strcpy(tmp2,directory),"\\colors.bak"));
            rename(strcat(strcpy(tmp,directory),"\\colors.cfg"),tmp2);
#endif
        } else
            printtxt(" * colors.cfg file ok.",10);
    }


    /* Check language.dat file condition */
    language_file = 0;
#ifdef __linux__
    F = FileOpen("~/.skyreader/language.dat","rb");
#else
    F = FileOpen(strcat(strcpy(tmp,directory),"\\language.dat"),"rb");
#endif
    if (F != NULL)
    {
        num = 0;
        while (_fgets(tmp,sizeof(tmp),F) != NULL)
        {
            pstr = tmp;
            while (*pstr == ' ') pstr++;
            if (*pstr != '\0' && *pstr != ';') num++;
        }
        fclose(F);
        if (num != LangLines)
        {
            printtxt(" * language.dat file out of date, renaming to language.bak",12);
#ifdef __linux__
            FileRemove("~/.skyreader/language.bak");
            FileRename("~/.skyreader/language.dat","~/.skyreader/language.bak");
#else
            remove(strcat(strcpy(tmp2,directory),"\\language.bak"));
            rename(strcat(strcpy(tmp,directory),"\\language.dat"),tmp2);
#endif
        }
        else
        {
            printtxt(" * language.dat file ok.",10);
            language_file = 1;
        }
    }
    printtxt(" * Press any key to start unpacking files",15);
    if (sk_getch() == 0) sk_getch();

    save_scr(&cx,&cy,&oldscr);
    tclrscr();

#ifdef __linux__
    sprintf(tmp,"x skyread.rar ~/.skyreader");
    tclrscr();
    errlvl = swapexec("unrar",tmp,0);
#else
    sprintf(tmp,"x skyread.rar *.* %s",directory);
    errlvl = swapexec("unrar.exe",tmp,0);
#endif
    if (errlvl != 0 && errlvl != 1)
    {
        sprintf(tmp, "Packer returned errorlevel %d", errlvl);
        err_box(tmp);
        return 2;
    }

    old_scr(cx,cy,&oldscr);
#ifdef __linux__
    sprintf(tmp, "%s/sky", directory);
    if (copyfile("~/.skyreader/sky", tmp))
    {
        FileRemove("~/.skyreader/sky");
        chmod(tmp, 0770);
    }
    else
    {
        printtxt(" * Can't copy SkyReader executable to destination directory!", 12);
        if (sk_getch() == 0) sk_getch();
    }
#endif

    /* Rename language files */
    if (!language_file)
    {
        ypos = selobj("Language file to use?", "English", "Finnish/Suomi");

#ifdef __linux__
        if (ypos == 0)
            FileRename("~/.skyreader/language.eng","~/.skyreader/language.dat");
        else
            FileRename("~/.skyreader/language.fin","~/.skyreader/language.dat");
#else
        if (ypos == 0)
            rename(strcat(strcpy(tmp,directory),"\\language.eng"),strcat(strcpy(tmp2,directory),"\\language.dat"));
        else
            rename(strcat(strcpy(tmp,directory),"\\language.fin"),strcat(strcpy(tmp2,directory),"\\language.dat"));
#endif
    }
    ypos = selobj("Color configuration to use?", "Bright (Blue Wave)", "Dark");

#ifdef __linux__
    if (ypos == 0)
        FileRename("~/.skyreader/colors.bri","~/.skyreader/colors.cfg");
    else
        FileRename("~/.skyreader/colors.drk","~/.skyreader/colors.cfg");
#else
    if (ypos == 0)
        rename(strcat(strcpy(tmp,directory),"\\colors.bri"),strcat(strcpy(tmp2,directory),"\\colors.cfg"));
    else
        rename(strcat(strcpy(tmp,directory),"\\colors.drk"),strcat(strcpy(tmp2,directory),"\\colors.cfg"));
#endif
#ifdef __OS2__
    if (selobj("Create SkyReader icon to desktop?", "Yes", "No") == 0)
    {
        sprintf(tmp, "EXENAME=%s\\SKY2.EXE;STARTUPDIR=%s", directory, directory);
        WinCreateObject("WPProgram", "SkyReader", tmp, "<WP_DESKTOP>", CO_FAILIFEXISTS);
    }
#endif
    tclrscr();

#ifdef __NT__
    CloseHandle(scrHandle);
    KbdDeInit();
#endif
#ifdef __linux__
    endwin();
#endif
    printf("Installation successful.\n");

    return 0;
}
