#include <stdio.h>

#include "screen.h"

static char waiting = 0;
static _meta = 0;

void reader_info(void);

int sk_kbhit(void)
{
    int hit;

    if (!changed)
    {
        changed = 1;
        refresh();
    }
    hit = wgetch(stdscr);
    if (hit != ERR) ungetch(hit);

    return hit != ERR;
}

char chr_in(void)
{
    char c;

    while (!sk_kbhit()) ;
    c = wgetch(stdscr);

    return c;
}

char sk_getch(void)
{
    char alt_table[] = "qwertyuiopasdfghjklzxcvbnm";

    char ch;
    int num;

    if (waiting != 0)
    {
        ch = waiting;
        waiting = 0;
        if (ch == 27) goto __esc;
        return ch;
    }

    ch = chr_in();
    if (ch == 24) { _meta = 1; return 24; } /* Ctrl-X */
    if (ch == 10) ch = 13;
    if (ch == 127) return 8; /* Backspace */

    if (_meta) goto __alt;

    if (ch == 27)
    {
    __esc:
        /* Scan code? */
        halfdelay(0);
        num = wgetch(stdscr);
        if (num == ERR)
        {
            halfdelay(1);
            return ch;
        }

        /* Yep.. */
        ch = (char) num;

        if (ch == '[')
        {
            if (!sk_kbhit()) return 27;
            ch = sk_getch();

            if (ch >= '0' && ch <= '9')
            {
                num = 0;
                while (ch >= '0' && ch <= '9')
                {
                    num = num*10+ch-'0';
                    if (!sk_kbhit()) return 27;
                    ch = sk_getch();
                }

                switch (num)
                {
                    case 1:
                        /* Home */
                        waiting = 'G';
                        return 0;
                    case 2:
                        /* Insert */
                        waiting = 'R';
                        return 0;
                    case 3:
                        /* Delete */
                        waiting = 'S';
                        return 0;
                    case 4:
                        /* End */
                        waiting = 'O';
                        return 0;
                    case 5:
                        /* PgUp */
                        waiting = 'I';
                        return 0;
                    case 6:
                        /* PgDn */
                        waiting = 'Q';
                        return 0;
                    case 17:
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                        /* F6..F10 */
                        waiting = 64+num-17;
                        return 0;
                    case 23:
                        /* F11 */
                        waiting = 133;
                        return 0;
                    case 24:
                        /* F12 */
                        waiting = 134;
                        return 0;
                    case 25:
                        /* Shift-F3 */
                        waiting = 86;
                        return 0;
                    case 26:
                        /* Shift-F4 */
                        waiting = 87;
                        return 0;
                    case 28:
                        /* Shift-F5 */
                        waiting = 88;
                        return 0;
                    case 29:
                        /* Shift-F6 */
                        waiting = 89;
                        return 0;
                    case 31:
                    case 32:
                    case 33:
                    case 34:
                        /* Shift-F7..Shift-F10 */
                        waiting = 90+num-31;
                        if (num == 34) reader_info();
                        return 0;
                    default:
                        waiting = 200+num;
                        return 0;
                }
            }

            switch (ch)
            {
                case 'A':
                    /* Cursor up */
                    waiting = 'H';
                    return 0;
                case 'B':
                    /* Down */
                    waiting = 'P';
                    return 0;
                case 'C':
                    /* Right */
                    waiting = 'M';
                    return 0;
                case 'D':
                    /* Left */
                    waiting = 'K';
                    return 0;
                case '[':
                    if (!sk_kbhit()) return '[';
                    ch = sk_getch();
                    if (ch >= 'A' && ch <= 'E')
                    {
                        waiting = 59+ch-'A';
                        return 0;
                    }
                    waiting = ch;
                    return 0;
                default:
                    waiting = ch;
                    return 0;
            }
        }
        else
        {
        __alt:
            _meta = 0;
            if (ch >= 'a' && ch <= 'z')
            {
                /* Alt-key */
                num = (int) (strchr(alt_table,ch)-alt_table);
                if (num < 10) num += 16;
                else if (num < 19) num += 30-10;
                else num += 44-19;
                waiting = num;
                return 0;
            }
            if (ch >= '1' && ch <= '9')
            {
                waiting = ch-'1'+120;
                return 0;
            }
            switch (ch)
            {
                case 10:
                    waiting = 28;
                    return 0;
                case 8:
                    waiting = 14;
                    return 0;
                case 9:
                    waiting = 165;
                    return 0;
                case 27:
                    waiting = 27;
                    return 27;
                case '0':
                    waiting = 129;
                    return 0;
                default:
                    waiting = ch;
                    return 0;
            }
        }
    }

    return ch;
}
