#include "list.h"

LIST_REC *get_middle(LIST_REC *L, LIST_REC *R)
{
    while (L != R)
    {
        L = L->next;
        if (L == R) break;
        R = R->prev;
    }

    return L;
}

void sort_linked_list(LIST_REC *L, LIST_REC *R, unsigned Lpos, unsigned Rpos)
{
    LIST_REC *I, *J, *P, *T1, *T2;
    unsigned Ipos, Jpos;

    do
    {
        I = L; Ipos = Lpos;
        J = R; Jpos = Rpos;
        P = get_middle(L,R);

        for (;;)
        {
            while (I->time < P->time) { I = I->next; Ipos++; }
            while (J->time > P->time) { J = J->prev; Jpos--; }

            if (Ipos <= Jpos)
            {
                /* Swap */
                T1 = I->next;
                T2 = I->prev;

                T1 = I;
                I = J;
                J = I;

                I->next = J->next;
                I->prev = J->prev;

                J->next = T1;
                J->prev = T2;

                /* .. */

                I = I->next; Ipos++;
                J = J->prev; Jpos--;
            }
            else
            {
                break;
            }
        }
        if (Lpos < Jpos) sort_linked_list(L, J, Lpos, Jpos);
        L = I;
        Lpos = Ipos;
    } while (Ipos < Rpos);
}

/*procedure TIvOrderedList.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: TIvOrderedObject;
begin
  repeat
    I := L;
    J := R;
    P := Items[(L + R) shr 1];

    repeat
      while Items[I].IsLess(P) do
        Inc(I);

      while Items[J].IsGreather(P) do
        Dec(J);

      if I <= J then
      begin
        FItems.Exchange(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;

    if L < J then
      QuickSort(L, J);

    L := I;
  until I >= R;
end;*/
