#define KELLO

#ifdef __OS2__
#  define INCL_DOS
#  include <os2.h>
#elif defined (__NT__)
#  include <windows.h>
#elif defined (__linux__)
#  include <unistd.h>
#else
#  include <dos.h>
#endif

#include <string.h>
#include <time.h>

#ifdef KELLO
#  include "screen.h"
#  include "vars.h"
#  include "keyb.h"
#endif

#define OS_MSDOS     0  /* MS-DOS */
#define OS_OS2       1  /* IBM OS/2 */
#define OS_WINDOWS   2  /* Microsoft Windows */
#define OS_DESQVIEW  3  /* Quarterdeck DESQview */
#define OS_DBLDOS    4  /* DoubleDOS */
#define OS_NETWARE   5  /* Novell Netware */

char showclock = 1,clockcolor;
static int oldsecond,oldhour,oldday;
int scrsaver;

#if !defined (__OS2__) && !defined (__NT__) && !defined (__linux__)
int opsys_id = OS_MSDOS;

int opsysDetect(void) {
    union REGS regs;

    /* detect DESQview */
#ifdef __386__
    regs.w.ax = 0x2B01;
    regs.w.cx = 0x4445;
    regs.w.dx = 0x5351;
    int386(0x21, &regs, &regs);
#else
    regs.x.ax = 0x2B01;
    regs.x.cx = 0x4445;
    regs.x.dx = 0x5351;
    int86(0x21, &regs, &regs);
#endif
    if (regs.h.al != 0xFF)
    {
        opsys_id = OS_DESQVIEW;
        return opsys_id;
    }

    /* detect OS/2 */
    regs.h.ah = 0x30;
#ifdef __386__
    int386(0x21, &regs, &regs);
#else
    int86(0x21, &regs, &regs);
#endif
    if (regs.h.al >= 10)
    {
        opsys_id = OS_OS2;
        return opsys_id;
    }

    /* detect Windows */
#ifdef __386__
    regs.w.ax = 0x160A;
    int386(0x2F, &regs, &regs);
    if (regs.w.ax == 0)
#else
    regs.x.ax = 0x160A;
    int86(0x2F, &regs, &regs);
    if (regs.x.ax == 0)
#endif
    {
        opsys_id = OS_WINDOWS;
        return opsys_id;
    }

    /* must be MS-DOS */
    opsys_id = OS_MSDOS;
    return opsys_id;
}
#endif

void give_timeslice(void)
{
#ifdef KELLO
    time_t _tim;
    struct tm *tim;
    char tmp[20];

    unsigned short cx,cy;
    char *oldscr;

    if (showclock && setup.misc_flags & MISC_SHOW_TIME)
    {
        /* Draw clock */
        _tim = time(NULL);
        tim = localtime(&_tim);

        if (oldsecond != tim->tm_sec)
        {
            oldsecond = tim->tm_sec;
            sprintf(tmp," %02d:%02d:%02d ",tim->tm_hour,tim->tm_min,tim->tm_sec);
            cwritexy(scrwidth-10,1,tmp,clockcolor);
            if (oldhour != tim->tm_hour)
            {
                oldhour = tim->tm_hour;
                if (oldday != tim->tm_mday) {
                    sprintf(tmp," %02d-%02d-%02d ",tim->tm_mon+1,tim->tm_mday,tim->tm_year % 100);
                    cwritexy(2,1,tmp,clockcolor);
                    oldday = tim->tm_mday;
                }
            }
            scrsaver--;
            if (scrsaver == 0)
            {
                save_scr(&cx,&cy,&oldscr);
                tbar(1,1,scrwidth,scrsize,7);
                showclock = 0;
                if (sk_getch() == 0) sk_getch();
                showclock = 1;
                old_scr(cx,cy,&oldscr);
            }
            gotoxy(wherex,wherey);
        }
    }
#endif
#ifdef __OS2__
    DosSleep(1);
#elif defined (__NT__)
    Sleep(1);
#elif !defined (__linux__)
    union REGS regs;
    switch (opsys_id)
    {
/*        case OS_MSDOS:
#ifdef __386__
            int386(0x28, &regs, &regs);
#else
            int86(0x28, &regs, &regs);
#endif
            break;*/

        case OS_OS2:
        case OS_WINDOWS:
#ifdef __386__
            regs.w.ax = 0x1680;
            int386(0x2F, &regs, &regs);
#else
            regs.x.ax = 0x1680;
            int86(0x2F, &regs, &regs);
#endif
            break;

        case OS_DESQVIEW:
#ifdef __386__
            regs.w.ax = 0x1000;
            int386(0x15, &regs, &regs);
#else
            regs.x.ax = 0x1000;
            int86(0x15, &regs, &regs);
#endif
            break;

        case OS_DBLDOS:
#ifdef __386__
            regs.w.ax = 0xEE01;
            int386(0x21, &regs, &regs);
#else
            regs.x.ax = 0xEE01;
            int86(0x21, &regs, &regs);
#endif
            break;

        case OS_NETWARE:
#ifdef __386__
            regs.w.bx = 0x000A;
            int386(0x7A, &regs, &regs);
#else
            regs.x.bx = 0x000A;
            int86(0x7A, &regs, &regs);
#endif
            break;
    }
#endif
}
