/* Definitions */

#define INCL_WIN
#define APPLICATION     "SkyReader/PM"

/* Includes */

#include <os2.h>
#include <process.h>
#include <stdio.h>
#include <string.h>

#include "rc.h"

/* Prototypes */

MRESULT EXPENTRY WinProc (HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY WinMsgTextProc (HWND, ULONG, MPARAM, MPARAM);

/* Global Variables */

HAB     hab;
HWND    hwndClient,hwndFrame2;

/* main function */

void main (void)
{
    HMQ     hmq;
    QMSG    qmsg;
    ULONG   flCreate;
    HWND    hwndFrame;
    SWP     swp;

    hab = WinInitialize (0);
    if (!hab) return;

    hmq = WinCreateMsgQueue (hab, 0);
    WinRegisterClass(hab,
                     APPLICATION,
                     (PFNWP) WinProc,
                     CS_SIZEREDRAW,
                     sizeof(PVOID));

    flCreate =
        FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MINMAX |
        FCF_TASKLIST | FCF_SHELLPOSITION | FCF_MENU | FCF_ICON;

    hwndFrame = WinCreateStdWindow(
                                   HWND_DESKTOP,
                                   WS_VISIBLE,
                                   &flCreate,
                                   APPLICATION,
                                   "SkyReader/PM",
                                   0,
                                   NULLHANDLE,
                                   RES_CLIENT,
                                   &hwndClient);

    WinRegisterClass(hab,
                     "Loota",
                     (PFNWP) WinMsgTextProc,
                     0,
                     sizeof(PVOID));
    WinQueryWindowPos(hwndClient, &swp);
    hwndFrame2 = WinCreateWindow(hwndClient,"Loota","Ikkuna", WS_VISIBLE, 12, 12, swp.cx-23, swp.cy-113,
                                 hwndClient, HWND_BOTTOM, RES_MSGTEXT, NULL, NULL);

    if (hwndFrame != NULLHANDLE) {
        while (WinGetMsg (hab,&qmsg,(HWND)NULL,0,0))
            WinDispatchMsg (hab,&qmsg);

        WinDestroyWindow(hwndFrame);
    }

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

/* SkyReader's main window procedure */

void DrawUpperBox(HPS hpsPaint, PRECTL rclPaint);
void DrawLowerBox(HPS hpsPaint, PRECTL rclPaint);
void DrawStaticTexts(HPS hpsPaint, PRECTL rclPaint);

MRESULT EXPENTRY WinProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS hpsPaint;
    RECTL rclPaint;
    SWP swp;

    switch (msg)
    {
        case WM_COMMAND:
            switch (SHORT1FROMMP(mp1))
            {
                case MI_EXIT:
                    WinPostMsg(hwnd,WM_QUIT,0L,0L);
                    break;
                default:
                    return WinDefWindowProc (hwnd, msg, mp1, mp2);
            }
            break;
        case WM_SIZE:
        case WM_PAINT:
            hpsPaint = WinBeginPaint(hwnd,NULLHANDLE,&rclPaint);
            WinFillRect(hpsPaint,&rclPaint,SYSCLR_DIALOGBACKGROUND);
            WinQueryWindowRect(hwnd,&rclPaint);

            DrawUpperBox(hpsPaint,&rclPaint);
            DrawLowerBox(hpsPaint,&rclPaint);
            DrawStaticTexts(hpsPaint,&rclPaint);

            WinEndPaint(hpsPaint);
            if (msg == WM_SIZE) {
                WinQueryWindowPos(hwndClient, &swp);
                WinSetWindowPos(hwndFrame2, HWND_TOP, 0, 0, swp.cx-23, swp.cy-113, SWP_SIZE);
                /*WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                              "WM_SIZE",NULL,0,MB_OK);*/
            } else
            {
                /*WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                              "WM_PAINT",NULL,0,MB_OK);*/
            }
            break;

        case WM_CLOSE:
            /*if (WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                              "Are you sure you want to quit?","Sample",
                              0,MB_YESNO | MB_QUERY) == MBID_YES)*/
            WinPostMsg(hwnd,WM_QUIT,0,0);
            break;

        default:
            return WinDefWindowProc (hwnd, msg, mp1, mp2);
    }
    return FALSE;
}

void DrawUpperBox(HPS hpsPaint, PRECTL rclPaint)
{
    POINTL ptl;

    /* Draw left and upper lines */
    GpiSetColor(hpsPaint,SYSCLR_SHADOWHILITEBGND);
    ptl.x = 10;
    ptl.y = rclPaint->yTop-80;
    GpiMove(hpsPaint,&ptl);
    ptl.y = rclPaint->yTop-10;
    GpiLine(hpsPaint,&ptl);
    ptl.x = rclPaint->xRight-10;
    GpiLine(hpsPaint,&ptl);

    /* Draw right and lower lines */
    GpiSetColor(hpsPaint,SYSCLR_SHADOWHILITEFGND);
    ptl.y = rclPaint->yTop-80;
    GpiLine(hpsPaint,&ptl);
    ptl.x = 10;
    GpiLine(hpsPaint,&ptl);
}

void DrawLowerBox(HPS hpsPaint, PRECTL rclPaint)
{
    POINTL ptl;

    if (rclPaint->yTop < 110) return;

    /* Draw left and upper lines */
    GpiSetColor(hpsPaint,SYSCLR_SHADOWHILITEFGND);
    ptl.x = 10;
    ptl.y = 10;
    GpiMove(hpsPaint,&ptl);
    ptl.y = rclPaint->yTop-100;
    GpiLine(hpsPaint,&ptl);
    ptl.x = rclPaint->xRight-10;
    GpiLine(hpsPaint,&ptl);

    /* Draw right and lower lines */
    GpiSetColor(hpsPaint,SYSCLR_SHADOWHILITEBGND);
    ptl.y = 10;
    GpiLine(hpsPaint,&ptl);
    ptl.x = 10;
    GpiLine(hpsPaint,&ptl);
}

void DrawStaticTexts(HPS hpsPaint, PRECTL rclPaint)
{
    RECTL rclRectangle;

    /* Draw texts */
    rclRectangle.xLeft = 15;
    rclRectangle.yTop = rclPaint->yTop-15;
    rclRectangle.yBottom = rclPaint->yTop-80;
    rclRectangle.xRight = rclPaint->xRight-5;
    WinDrawText(hpsPaint,-1,"Msg#:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);

    rclRectangle.yTop -= 15;
    WinDrawText(hpsPaint,-1,"From:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);

    rclRectangle.xLeft += 350;
    WinDrawText(hpsPaint,-1,"Date:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);
    rclRectangle.xLeft -= 350;

    rclRectangle.yTop -= 15;
    WinDrawText(hpsPaint,-1,"To:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);

    rclRectangle.xLeft += 350;
    WinDrawText(hpsPaint,-1,"Mark:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);
    rclRectangle.xLeft -= 350;

    rclRectangle.yTop -= 15;
    WinDrawText(hpsPaint,-1,"Subj:",&rclRectangle,SYSCLR_WINDOWSTATICTEXT,0,0);
}

MRESULT EXPENTRY WinMsgTextProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS hpsPaint;
    RECTL rclPaint,rclRect;
    char str[256];
    static FILE *Ftxt;

    switch (msg)
    {
        case WM_CREATE:
            if ((Ftxt = FileOpen("e:\\autoexec.bat","rt")) == NULL) {
                WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                              "Ei saatu avattua!",NULL,0,MB_OK);
            }
            break;
        case WM_DESTROY:
            fclose(Ftxt);
            break;
        case WM_PAINT:
            hpsPaint = WinBeginPaint(hwnd,NULLHANDLE,&rclPaint);
            WinFillRect(hpsPaint,&rclPaint,SYSCLR_DIALOGBACKGROUND);
            rclRect = rclPaint;
            fseek(Ftxt,0,SEEK_SET);
            while (fgets(str,sizeof(str),Ftxt)) {
                WinDrawText(hpsPaint,-1,str,&rclRect,SYSCLR_WINDOWTEXT,0,0);
                rclRect.yTop -= 15;
                if (rclRect.yTop < 15) break;
            }
            WinEndPaint(hpsPaint);
            break;

        default:
            return WinDefWindowProc (hwnd, msg, mp1, mp2);
    }
    return FALSE;
}
