#ifndef __FILES_H
#define __FILES_H

#ifdef __OS2__
#  include <os2.h>
#endif

#include <stdio.h>
#include <fcntl.h>

#if defined (__OS2__) || defined (__linux__)
#  define FIND_CLOSE
#endif

#ifdef __linux__
#  include <dirent.h>
#  include <unistd.h>
#  include <utime.h>
#  include <sys/stat.h>
#  define __NO_DRIVES__
#  define DEV_NUL "/dev/null"
#  define DEV_CON "/dev/tty"
#  define SLASH '/'
#  define SSLASH "/"
#  define REST "*"
#  define ftrunc(a,b) ftruncate(fileno(a),b)
#  define ISDIR(a) (a.st_mode & S_IFDIR)
#  define ISDIRP(a) (a->st_mode & S_IFDIR)
#  define sopen(a,b,c) open(a,b)
#  define O_BINARY 0
#else
#  include <sys/utime.h>
#  include <direct.h>
#  include <dos.h>
#  include <io.h>
#  define DEV_NUL "nul"
#  define DEV_CON "con"
#  define SLASH '\\'
#  define SSLASH "\\"
#  define REST "*.*"
#  define ftrunc(a,b) chsize(fileno(a),b)
#  define ISDIR(a) (a.st_attr & _A_SUBDIR)
#  define ISDIRP(a) (a->st_attr & _A_SUBDIR)
#  define fopen_ign(a,b) fopen(a,b)
#  define search_ign_file(a) (a)
#  define FileOpen(a,b) fopen(a,b)
#  define FileStat(a,b) stat(a,b)
#  define FileRename(a,b) rename(a,b)
#  define FileRemove(a) remove(a)
#  define ChangeDir(a) chdir(a)
#  define FileTime(a,b) utime(a,b)
#endif

int compare_filenames(char *fname, char *wildcard);
char exists(char *fname);
char isdir(char *path);
char *_fgets(char *buf, size_t n, FILE *fp);
char make_space(FILE *Fhandle, long pos, long size, long fsize);
char delete_space(FILE *Fhandle, long pos, long size, long fsize);
char mkpath(char *);
char copyfile(char *src, char *dest);
char cmpfile(char *file1, char *file2);

#ifdef __linux__

#define _A_HIDDEN 0
#define _A_SYSTEM 0
#define _A_SUBDIR 1

struct find_t {
    DIR *dir;
    struct dirent *direntp;
    unsigned attributes;
    char name[256];
    char search[256];
};

FILE *fopen_ign(char *fname, char *mode);
FILE *FileOpen(char *fname, char *mode);
int FileStat(char *fname, struct stat *buf);
int FileRename(char *from, char *to);
int FileRemove(char *fname);
int ChangeDir(char *path);
int FileTime(char *path, struct utimbuf *buf);
char *search_ign_file(char *fname);

unsigned _dos_findfirst(char *path, unsigned attributes, struct find_t *buffer);
unsigned _dos_findnext(struct find_t *buffer);
unsigned _dos_findclose(struct find_t *buffer);
#endif

#endif
