#ifndef __PKT_OBJ_H
#define __PKT_OBJ_H

#include <stdio.h>
#include "bluewave.h"

#define MAX_AREAS 32
#define MAX_MIXES 128
#define BUF_SIZE  4096      /* Oltava 128:lla jaollinen!! */
//#define BUF_SIZE  79        /* Oltava 128:lla jaollinen!! */
#define XTI_SIZE  256

#define LINE_TYPE_NORMAL  0
#define LINE_TYPE_QUOTE   1
#define LINE_TYPE_TAG     2
#define LINE_TYPE_TEAR    3
#define LINE_TYPE_ORIGIN  4
#define LINE_TYPE_KLUDGE  5
#define LINE_TYPE_SPECIAL 6

typedef struct _line_rec
{
    struct _line_rec *next;
    struct _line_rec *prev;

    unsigned long ptr;
    unsigned char len;
    char line_type;
}
LINE_REC;

class offline_packet
{
public:
    LINE_REC *first_linerec;
    LINE_REC *linerec;
    unsigned long current_line;

    /* Size & pointer in Fdat file of current message */
    unsigned long msgtxtsize;
    unsigned long msgtxtptr;

    char username[36];
    char useralias[36];
    char sysop_name[36];
    char board_name[41];

    char xtiname[13];
    char aidname[13];

    char lastarea[6];
    unsigned lastareanum;

    unsigned txt_length,max_freqs;
    unsigned char from_to_len,subj_len,mixedcase;
    char allow_forwarding,know_areas,allow_freq,offline_config,ansi_newfiles;
    char allow_crash,allow_direct,allow_immediate,allow_hold,allow_killsent,allow_fattach,allow_net_freq;

    long first;

    unsigned areas,replies;
    unsigned curarea;

    long msgptr;

    unsigned txt_lines;         /* Number of lines in message */
    char chrs_kludge[21];       /* CHARSET kludge in message */
    char msgid_kludge[80];      /* MSGID kludge in message */
    unsigned fmpt;              /* FMPT kludge in message */
    char intl_kludge[80];       /* INTL kludge in message */
    char origin_line[256];      /* Origin line of message */

    char xti_path[256];

    /* BW style .XTI file infos */
    FILE *Fxti;
    XTI_REC *xti_buf;
    unsigned xti_start,xti_end;

    char hippoinf;              /* Hippo area infos exists */
    char arealist;              /* Offline config exists */

    /* BW style .MIX file infos */
    FILE *Fmix;
    MIX_REC *mix_buf;
    unsigned mix_start,mix_end,total_mixes;

    /* ANSI files in message packet */
    unsigned char ansi_files;
    char ansi_name[255][13];
    char ansi_time[255][17];

    /* .FTI, .IDX, etc. file buffer positions */
    unsigned long idxstart,idxend;

    /* BW style .INF file infos */
    FILE *Finfo;                            /* .INF file handle */
    INF_HEADER info;                        /* .INF header */
    INF_AREA_INFO *area_buf;                /* .INF records */
    unsigned inf_header_slen,inf_area_slen; /* Size of .INF header & record */
    unsigned abufsize;                      /* Size of area_buf buffer */
    unsigned area_start,area_end;           /* Buffer positions */

    /* BW style reply information */
    char replyopen,fupl_opened;
    UPL_HEADER uplheader;
    FILE *Freply,*Fupl;

    /* Message text buffer */
    FILE *Fdat;
    unsigned char *txt_buf;
    unsigned long dat_start,dat_end;

    /* For SOUP */
    char *references;
    char *message_id;
    char *newsgroups;

    virtual char open_packet(char *str);
    virtual void close_packet(void);
    virtual char save_info(char *path);

    virtual void read_inf_area(unsigned area);
    void read_mix(unsigned area);
    void write_mix(unsigned area, MIX_REC *mix);
    void delete_mix(unsigned area);

    virtual char area_selected(unsigned area);
    virtual char *get_area_number(unsigned area);
    virtual char *get_area_name(unsigned area);
    virtual char *get_area_tag(unsigned area);

    virtual unsigned getarea(char *areanum);
    virtual unsigned getaname(char *area);
    virtual unsigned gettag(char *tag);

    virtual unsigned get_msgs(char *areanum);
    virtual unsigned get_personal_msgs(char *areanum);
    virtual unsigned get_unread_msgs(char *areanum);

    virtual char open_area(char *area);
    virtual char read_msg(unsigned msgnum);
    virtual void write_msg(unsigned msgnum);
    virtual void delete_msg(unsigned msgnum);

    virtual long read_num(unsigned msgnum);
    virtual char *read_from(unsigned msgnum);
    virtual char *read_to(unsigned msgnum);
    virtual char *read_subj(unsigned msgnum);

    virtual char init_text(void);
    virtual void deinit_msgtext(void);
    virtual char *read_line(char *str, unsigned line);

    virtual void area_flags(unsigned num, XTI_REC *xti);
    virtual void save_area_flags(unsigned num, XTI_REC *xti);
    virtual void update_area_flags(void);
    virtual void delete_xti(unsigned num);

    virtual void open_replypacket(void);
    virtual void close_replypacket(void);

    virtual char read_reply(unsigned num);

    virtual char *export_msg(char *out);
    virtual char init_replytext(char *fname);
    virtual char *read_replyline(char *str, unsigned line);
    virtual void export_reply(unsigned num, char *name);
    virtual void deinit_replytext(void);

    virtual unsigned area_type(unsigned area);

    virtual void enter_msg(void);
    virtual void edit_msg(unsigned num);

    virtual void toggle_deleted(unsigned msgnum, char deleted);
    virtual void delete_reply(unsigned msgnum);

    virtual void read_arealist(FILE *F);
    virtual void write_arealist(FILE *F);
};

#endif
