#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "crc.h"
#include "files.h"
#include "general.h"
#include "screen.h"
#include "pkt_bw.h"
#include "pkt_soup.h"
#include "vars.h"
#include "version.h"

char soup_packet::open_packet(char *str)
{
    unsigned short cx, cy;
    char *oldscr;

    FILE *Farea, *Fmsg;
    char *strp, *title, idx;
    char subject[200], author[100], date[50];
    unsigned long seekpos, lastpos, next, lines;
    int email, slen, msgs;

    INF_HEADER infhdr;
    INF_AREA_INFO infarea;
    MIX_REC mixrec;

    know_areas = 1;
    offline_config = 1;

    from_to_len = 36;
    subj_len = sizeof(reply.subj);

    inf_header_slen = sizeof(INF_HEADER);
    inf_area_slen = sizeof(INF_AREA_INFO);

    replyopen = 0; replies = 0; fupl_opened = 0; arealist = 0; curarea = 0;

    idxline = (char *) malloc(8192);

    sprintf(idxline, "%sAREAS", setup.workpath);
    Farea = fopen_ign(idxline, "rb");
    if (Farea == NULL) return 3;

    strcpy(username,setup.UsrName);
    strcpy(useralias,opt.alias);
    strcpy(board_name,"<unknown>");
    strcpy(sysop_name,"<unknown>");

    /* Create .INF file */
    sprintf(idxline, "%s%s.inf", setup.workpath, pktname);
    Finfo = FileOpen(idxline,"w+b");
    if (Finfo == NULL)
    {
        fclose(Farea);
        free(idxline);
        return 4;
    }

    memset(&infhdr,0,sizeof(infhdr));
    fwrite(&infhdr,sizeof(infhdr),1,Finfo);

    /* Create .MIX file */
    sprintf(idxline, "%s%s.mix", setup.workpath, pktname);
    Fmix = FileOpen(idxline,"w+b");
    if (Fmix == NULL)
    {
        fclose(Finfo);
        fclose(Farea);
        free(idxline);
        return 4;
    }

    msgs = 0;
    save_scr(&cx,&cy,&oldscr);
    slen = strlen(lang[23]);
    if ((int) strlen(lang[25])+2 > slen) slen = strlen(lang[25])+2;
    draw_shaded_box(scrwidth/2-slen/2-2,8,scrwidth/2+slen/2+2,12,color[col_box_frame],color[col_box_title],lang[23]);

    areas = 0; email = 0;
    while (_fgets(idxline, 8192, Farea) != NULL)
    {
        /* MIX_REC */
        memset(&mixrec, 0, sizeof(mixrec));
        sprintf((char *) mixrec.areanum, "%u", areas);

        /* prefix<TAB>area name<TAB>encoding[<TAB>description[<TAB>number]] */
        memset(&infarea, 0, sizeof(infarea));
        sprintf((char *) infarea.areanum, "%u", areas);
        infarea.network_type = INF_NET_INTERNET;
        infarea.area_flags = INF_SCANNING | INF_POST;

        /* echotag = prefix */
        strp = strchr(idxline, 9);
        if (strp == NULL)
        {
        __err:
            free(idxline);
            fclose(Farea);
            fclose(Finfo);
            return 1;
        }
        *strp++ = '\0'; title = strp;

        strcpy((char *) infarea.echotag, (char *) idxline);

        /* title = area name */
        strp = strchr(title, 9);
        if (strp == NULL) goto __err;
        *strp++ = '\0';
        strncpy((char *) infarea.title, (char *) title, sizeof(infarea.title)-1);
        infarea.title[sizeof(infarea.title)-1] = '\0';

        /* Get encoding */
        title = strp;
        strp = strchr(title, 9);
        if (strp != NULL) *strp = '\0';
        infarea.echotag[sizeof(infarea.echotag)-1] = title[0];
        idx = title[1];
        if (title[2] == 'm')
        {
            /* email */
            infarea.area_flags |= INF_NO_PUBLIC | INF_NETMAIL | INF_ECHO;
            email = 1;
        }
        else if (title[2] == 'n')
        {
            /* news */
            infarea.area_flags |= INF_NO_PRIVATE | INF_ECHO;
        }
        else
        {
            if (title[0] == 'm' || title[0] == 'M' || title[0] == 'b')
            {
                /* email */
                infarea.area_flags |= INF_NO_PUBLIC | INF_NETMAIL | INF_ECHO;
                email = 1;
            }
            else if (title[0] == 'u' || title[0] == 'B' || title[0] == 'i')
            {
                /* news */
                infarea.area_flags |= INF_NO_PRIVATE | INF_ECHO;
            }
        }

        if (idx != 'C' && idx != 'c')
        {
            /* Create 'c' type index file */
            /* offset<TAB>subject<TAB>author<TAB>date<TAB>bytes<TAB>lines[<TAB>selector] */
        __index:
            sprintf(idxline, "%s%s.MSG", setup.workpath, infarea.echotag);
            Fmsg = fopen_ign(idxline, "rb");
            if (Fmsg != NULL)
            {
                sprintf(idxline, "%s%s.IDX", setup.workpath, infarea.echotag);
                Fidx = FileOpen(idxline, "w+b");
                if (Fidx == NULL)
                {
                    free(idxline);
                    fclose(Fmsg);
                    fclose(Farea);
                    fclose(Finfo);
                    return 4;
                }

                /* Read messages from .MSG file.. */
                lines = next = lastpos = seekpos = 0;
                for (;;)
                {
                    if ((infarea.echotag[sizeof(infarea.echotag)-1] == 'b' || infarea.echotag[sizeof(infarea.echotag)-1] == 'B') && lastpos >= seekpos+next)
                    {
                        if (fread(idxline, 1, 4, Fmsg) != 4) break;
                        if (_fgets(idxline+4, 8192-4, Fmsg) == NULL) break;
                    }
                    else
                    {
                        if (_fgets(idxline, 8192, Fmsg) == NULL) break;
                    }

                    strp = idxline;
                    if (lastpos >= seekpos+next)
                    {
                        if ((infarea.echotag[sizeof(infarea.echotag)-1] == 'u' && strncmp(idxline, "#! rnews ", 9) == 0) ||
                            (infarea.echotag[sizeof(infarea.echotag)-1] == 'm' && strncmp(idxline, "From ", 5) == 0) ||
                            (infarea.echotag[sizeof(infarea.echotag)-1] == 'M' && strncmp(idxline, "\x01\x01\x01\x01", 4) == 0) ||
                            (infarea.echotag[sizeof(infarea.echotag)-1] == 'b' || infarea.echotag[sizeof(infarea.echotag)-1] == 'B'))
                        {
                            if (next != 0)
                            {
                                fprintf(Fidx, "%lu\x09%s\x09%s\x09%s\x09%lu\x09%lu\n",
                                        seekpos, subject, author, date, next, lines);
                            }
                            seekpos = lastpos;
                            mixrec.totmsgs++;

                            msgs++;
                            if ((msgs & 7) == 0)
                            {
                                sprintf(subject,lang[25],msgs);
                                cmiddle(10,subject,color[col_box_hilight]);
                                refresh();
                            }

                            switch (infarea.echotag[sizeof(infarea.echotag)-1])
                            {
                                case 'u':
                                    next = atol(idxline+9);
                                    break;
                                case 'M':
                                    while (*idxline == 1) idxline++;
                                case 'm':
                                    next = 0;
                                    break;
                                case 'b':
                                case 'B':
                                    /* Hi-byte first -> low-byte last */
                                    strp = (char *) &next;
                                    *strp++ = idxline[3]; *strp++ = idxline[2]; *strp++ = idxline[1]; *strp = idxline[0];
                                    strp = idxline; seekpos += 4;
                                    idxline += 4;
                                    break;
                            }
                            author[0] = '\0'; subject[0] = '\0'; date[0] = '\0'; lines = 0;
                        }
                    }
                    if (strncmp(idxline, "From:", 5) == 0)
                    {
                        strncpy(author, idxline+6, sizeof(author)-1); author[sizeof(author)-1] = '\0';
                    }
                    else if (strncmp(idxline, "Subject:", 8) == 0)
                    {
                        strncpy(subject, idxline+9, sizeof(subject)-1); subject[sizeof(subject)-1] = '\0';
                    }
                    else if (strncmp(idxline, "Date:", 5) == 0)
                    {
                        strncpy(date, idxline+6, sizeof(date)-1); date[sizeof(date)-1] = '\0';
                    }
                    else if (strncmp(date, "Lines:", 6) == 0)
                    {
                        lines = atol(idxline+7);
                    }
                    idxline = strp;
                    lastpos = ftell(Fmsg);
                }

                if (next != 0)
                {
                    fprintf(Fidx, "%lu\x09%s\x09%s\x09%s\x09%lu\x09%lu\n",
                            seekpos, subject, author, date, next, lines);
                }
                fclose(Fidx);
                fclose(Fmsg);
            }
            idx = 'C';
        }
        else
        {
            /* Indexes exist, calculate how many messages are in this area */
            sprintf(idxline, "%s%s.IDX", setup.workpath, infarea.echotag);
            Fidx = fopen_ign(idxline, "rb");
            if (Fidx == NULL) goto __index;

            while (_fgets(idxline, 8192, Fidx) != NULL) mixrec.totmsgs++;
        }
        infarea.echotag[sizeof(infarea.echotag)-2] = idx;

        /* Write records */
        fwrite(&infarea, sizeof(infarea), 1, Finfo);
        fwrite(&mixrec, sizeof(mixrec), 1, Fmix);

        areas++;
    }
    old_scr(cx,cy,&oldscr);
    fclose(Farea);

    if (!email)
    {
        /* Add email area */
        memset(&infarea, 0, sizeof(infarea));
        sprintf((char *) infarea.areanum, "%u", areas);
        infarea.network_type = INF_NET_INTERNET;
        infarea.area_flags = INF_SCANNING | INF_POST | INF_NO_PUBLIC | INF_NETMAIL | INF_ECHO;
        strcpy((char *) infarea.echotag, "email");
        strcpy((char *) infarea.title, "E-Mail messages");
        fwrite(&infarea, sizeof(infarea), 1, Finfo);
        areas++;
    }

    /* Get memory for .INF file buffer */
    if (areas < MAX_AREAS) abufsize = areas; else abufsize = MAX_AREAS;
    area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize);
    if (area_buf == NULL) return 2;

    index = NULL; Fdat = NULL;

    return offline_packet::open_packet(str);
}

void soup_packet::close_packet(void)
{
    if (index != NULL)
    {
        fclose(Fidx);
        free(index);
    }
    free(idxline);
    free(area_buf);
    fclose(Finfo);
    fclose(Fmix);
    if (Fdat != NULL) fclose(Fdat);

    offline_packet::close_packet();
}

char soup_packet::read_msg(unsigned msgnum)
{
    char *strp, *data;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        msgtxtptr = msg.blockpos;
        msgtxtsize = msg.txtblocks;
        return 1;
    }
    read_idx(msgnum);

    memset(&msg, 0, sizeof(msg));
    msg.mnum = msgnum;
    msg.area = (unsigned short) curarea;
    strcpy(msg.mto, "All");

    /* Get offset */
    strp = strchr(idxline, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    msg.blockpos = atol(idxline);
    data = strp;

    /* Get subject */
    strp = strchr(data, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    strncpy(msg.subj, data, sizeof(msg.subj)-1);
    data = strp;

    /* Get author */
    strp = strchr(data, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    strncpy(msg.mfrom, data, sizeof(msg.mfrom)-1);
    data = strp;

    /* Get date */
    strp = strchr(data, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    strncpy(msg.date, data, sizeof(msg.date)-1);
    data = strp;

    if (*(get_area_tag(curarea)+19) == 'c')
    {
        /* Skip 2 fields */
        strp = strchr(data, 9);
        if (strp == NULL) return 0;
        strp = strchr(strp+1, 9);
        if (strp == NULL) return 0;
        data = strp+1;
    }

    /* Get size */
    strp = strchr(data, 9);
    if (strp != NULL) *strp++ = '\0';
    msg.txtblocks = atol(data);
    data = strp;

    msgtxtptr = msg.blockpos;
    msgtxtsize = msg.txtblocks;

    return 1;
}

long soup_packet::read_num(unsigned msgnum)
{
    return (long) msgnum;
}

char *soup_packet::read_from(unsigned msgnum)
{
    char *data, *strp;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }

    read_idx(msgnum);

    msg.mnum = msgnum;

    /* Skip offset */
    strp = strchr(idxline, 9);
    if (strp == NULL) return 0;
    /* Skip subject */
    strp = strchr(strp+1, 9);
    if (strp == NULL) return 0; data = strp+1;

    /* Get author */
    strp = strchr(data, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    strncpy(msg.mfrom, data, sizeof(msg.mfrom)-1); msg.mfrom[sizeof(msg.mfrom)-1] = '\0';

    return msg.mfrom;
}

char *soup_packet::read_to(unsigned msgnum)
{
    msg.mnum = msgnum;
    strcpy(msg.mto, "All");

    return msg.mto;
}

char *soup_packet::read_subj(unsigned msgnum)
{
    char *data, *strp;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }
    read_idx(msgnum);

    /* Skip offset */
    strp = strchr(idxline, 9);
    if (strp == NULL) return 0; data = strp+1;

    /* Get subject */
    strp = strchr(data, 9);
    if (strp == NULL) return 0; *strp++ = '\0';
    strncpy(msg.subj, data, sizeof(msg.subj)-1); msg.subj[sizeof(msg.subj)-1] = '\0';

    return msg.subj;
}

void soup_packet::read_idx(unsigned msgnum)
{
    unsigned long lastpos;
    unsigned mnum, msgs;

    if (index == NULL || area_in_index != curarea)
    {
        if (index != NULL)
        {
            free(index);
            fclose(Fidx);
        }
        area_in_index = curarea;

        /* Read from .idx file to memory.. */
        sprintf(idxline, "%s%s.IDX", setup.workpath, get_area_tag(curarea));
        Fidx = fopen_ign(idxline, "rb");
        if (Fidx == NULL)
        {
            index = NULL;
            return;
        }

        /* Get memory for indexes */
        sprintf(idxline, "%u", curarea-1);
        msgs = get_msgs(idxline);
        index = (unsigned long *) malloc(sizeof(unsigned long)*msgs);
        if (index == NULL)
        {
            err_box("Not enough memory!");
            return;
        }

        /* Save index file positions to memory */
        lastpos = 0; mnum = 0;
        while (_fgets(idxline, 8192, Fidx) != NULL)
        {
            index[mnum++] = lastpos;
            if (mnum == msgs) break;
            lastpos = ftell(Fidx);
        }
    }

    /* Read index file.. */
    fseek(Fidx, index[msgnum-1], SEEK_SET);
    _fgets(idxline, 8192, Fidx);
}

char soup_packet::open_area(char *area)
{
    unsigned num;

    num = getarea(area);
    if (curarea == num) return 1;

    if (Fdat != NULL) fclose(Fdat);
    if (num > 0)
    {
        sprintf(idxline, "%s%s.MSG", setup.workpath, get_area_tag(num));
        Fdat = fopen_ign(idxline, "rb");
        dat_start = 1; dat_end = 0;
    }

    return offline_packet::open_area(area);
}

void soup_packet::open_replypacket(void)
{
    char tmp[256], line[256], *strp;
    unsigned long fpos, fsize;
    int mail;
    UPL_REC uplrec;
    FILE *Frep, *F, *Fout;

    if (fupl_opened) return;

    /* Create .UPL file */
    sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    if ((Fupl = fopen_ign(tmp, "r+b")) != NULL)
    {
        fseek(Fupl,0,SEEK_END);
        replies = (ftell(Fupl)-sizeof(UPL_HEADER))/sizeof(UPL_REC);
        fupl_opened = 1;
        return;
    }

    if ((Fupl = FileOpen(tmp, "w+b")) == NULL)
    {
        fupl_opened = 0;
        return;
    }
    memset(&uplheader,0,sizeof(uplheader));
    fwrite(&uplheader,sizeof(uplheader),1,Fupl);
    fupl_opened = 1;

    /* Convert SOUP replies -> BW replies */
    sprintf(tmp,"%sREPLIES",setup.replypath);
    Frep = fopen_ign(tmp, "rb");
    if (Frep == NULL) return;

    replies = 0;
    while (_fgets(line, sizeof(line), Frep) != NULL)
    {
        strp = strchr(line, '\t');
        if (strp == NULL) continue;

        *strp++ = '\0';
        mail = *strp == 'm';
        sprintf(tmp, "%s%s.MSG", setup.replypath, line);
        F = fopen_ign(tmp, "r+b");
        if (F != NULL)
        {
            memset(&uplrec, 0, sizeof(uplrec));
            strcpy((char *) uplrec.from, username);
            uplrec.msg_attr = mail ? UPL_PRIVATE | UPL_NETMAIL : 0;
            uplrec.area_flags = INF_POST | INF_ECHO | mail ? (INF_NETMAIL|INF_NO_PUBLIC) : INF_NO_PRIVATE;
            uplrec.network_type = UPL_NET_INTERNET;
            sprintf((char *) uplrec.filename, "%s.MSG", line);
            sprintf(tmp, "%s%s.fld", setup.replypath, line);
            Fout = FileOpen(tmp, "w+b");
            if (Fout != NULL)
            {
                /* Header texts to .fld */
                fseek(F, 4, SEEK_SET);
                while (_fgets(line, sizeof(line), F) != NULL)
                {
                    if (line[0] == '\0') break;
                    if (strncmp(line, "To: ", 4) == 0) strcpy((char *) uplrec.net_dest, line+4);
                    if (strncmp(line, "Newsgroups: ", 12) == 0) strcpy((char *) uplrec.net_dest, line+12);
                    if (strncmp(line, "Date: ", 6) == 0)
                    {
                        uplrec.unix_date = 0;
                    }
                    if (strncmp(line, "Subject: ", 9) == 0) strcpy((char *) uplrec.subj, line+9);
                    fprintf(Fout, "%s\n", line);
                }
                fclose(Fout);
                fpos = ftell(F); fseek(F, 0, SEEK_END); fsize = ftell(F);
                delete_space(F, 0, fpos, fsize);
                ftrunc(F, fsize-fpos);

                if (mail)
                    strcpy((char *) uplrec.echotag, "email");
                else
                {
                    strncpy((char *) uplrec.echotag, (char *) uplrec.net_dest, sizeof(uplrec.echotag)-1);
                    uplrec.echotag[sizeof(uplrec.echotag)-1] = '\0';
                }
                if (fwrite(&uplrec, sizeof(uplrec), 1, Fupl)) replies++;
            }
            fclose(F);
        }
    }
    fclose(Frep);

    sprintf(tmp,"%sREPLIES",setup.replypath);
#ifdef __linux__
    search_ign_file(tmp);
#endif
    FileRemove(tmp);

    fclose(Fupl);
    sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    Fupl = FileOpen(tmp, "r+b");
}

void soup_packet::close_replypacket(void)
{
    FILE *Frep, *Fin, *Fout;
    char tmp[256], tmp2[256], *strp;
    unsigned char num[4];
    int readed;
    unsigned long fsize;

    if (!fupl_opened) return;

    sprintf(tmp, "%sREPLIES", setup.replypath);
    Frep = FileOpen(tmp, "w+b");
    if (Frep == NULL) return;

    fseek(Fupl, sizeof(UPL_HEADER), SEEK_SET);
    while (fread(&uplrec,sizeof(uplrec),1,Fupl))
    {
        strp = strchr((char *) uplrec.filename, '.');
        if (strp != NULL) *strp = '\0';
        if (uplrec.area_flags & INF_ECHO)
            fprintf(Frep, "%s\tnews\tBn\n", uplrec.filename);
        else
            fprintf(Frep, "%s\tmail\tbn\n", uplrec.filename);

        /* Combine fields and message */
        sprintf(tmp, "%s%s.MSG", setup.replypath, uplrec.filename);
        sprintf(tmp2, "%s%s.fld", setup.replypath, uplrec.filename);
        Fout = FileOpen(tmp2, "r+b");
        if (Fout != NULL)
        {
            fseek(Fout, 0, SEEK_END);
            Fin = FileOpen(tmp, "rb");
            if (Fin != NULL)
            {
                fwrite("\n", 1, 1, Fout);
                while ((readed = fread(tmp, 1, sizeof(tmp), Fin)) > 0)
                {
                    fwrite(tmp, 1, readed, Fout);
                }
                fclose(Fin);

                sprintf(tmp, "%s%s.MSG", setup.replypath, uplrec.filename);
                FileRemove(tmp);
            }
            fseek(Fout, 0, SEEK_END);
            fsize = ftell(Fout);
            make_space(Fout, 0, 4, fsize);
            fseek(Fout, 0, SEEK_SET);
            num[0] = fsize >> 24; num[1] = (fsize >> 16) & 0xff;
            num[2] = (fsize >> 8) & 0xff; num[3] = fsize & 0xff;
            fwrite(num, 1, 4, Fout);
            fclose(Fout);
            FileRename(tmp2, tmp);
        }
    }
    fclose(Fupl);
    fclose(Frep);
    fupl_opened = 0;

    sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    FileRemove(tmp);
}

char *split_references(char *refs, int max)
{
    char *strp;
    int num;

    strp = refs; num = 0;
    while (*strp != '\0')
    {
        if (*strp == ' ')
        {
            num++;
            while (*(strp+1) == ' ') strp++;
        }
        strp++;
    }

    if (num <= max) return refs;

    num = max;
    while (num > 0)
    {
        if (*strp == ' ')
        {
            num--;
            if (num == 0) return strp+1;
            while (*(strp-1) == ' ') strp--;
        }
        strp--;
    }

    return refs;
}

void soup_packet::enter_msg(void)
{
    static char *month[12] =
    {
        "Jan","Feb","Mar","Apr","May","Jun",
        "Jul","Aug","Sep","Oct","Nov","Dec"
    };
    time_t _tim;
    struct tm *tim;
    char fname[256], *strp;
    FILE *F;

    sprintf(fname, "%s%s", setup.replypath, reply.fname);
    strp = strrchr(fname, '.');
    if (strp != NULL) *strp = '\0';
    strcat(fname, ".fld");

    F = FileOpen(fname, "w+b");
    if (F == NULL) return;

    if (opt.alias[0] != '\0')
        fprintf(F, "From: %s (%s)\n", setup.inet_addr, opt.alias);
    else if (setup.UsrName[0] != '\0')
        fprintf(F, "From: %s (%s)\n", setup.inet_addr, setup.UsrName);
    else
        fprintf(F, "From: %s\n", setup.inet_addr);
    fprintf(F, "Reply-To: %s\n", setup.inet_addr);
    strp = strrchr(setup.inet_addr, '@');
    if (strp != NULL)
    {
        *strp = '\0';
        fprintf(F, "Message-ID: <sk%08lx%04lx@%s>\n", time(NULL), crc32(setup.inet_addr) & 0xffff, strp+1);
        *strp = '@';
    }

    if (reply.flags & flag_email)
        fprintf(F, "To: %s\n", reply.mto);
    else
        fprintf(F, "Newsgroups: %s\n", reply.mto);
    fprintf(F, "Subject: %s\n", reply.subj);

    /* Date: */
    _tim = time(NULL);
    tim = localtime(&_tim);
    if (tim->tm_year < 80) tim->tm_year += 2000; else tim->tm_year += 1900;
    fprintf(F, "Date: %02d %s %04d %02d:%02d:%02d %s\n", tim->tm_mday,
            month[tim->tm_mon], tim->tm_year, tim->tm_hour, tim->tm_min, tim->tm_sec, tzname[0]);

    /* References: */
    if (reply.replyto != 0)
    {
        fprintf(F, "References: ");
        if (references != NULL && references[0] != '\0')
            fprintf(F, "%s ", split_references(references, 10));
        if (message_id != NULL) fprintf(F, "%s\n", message_id);
    }

    fprintf(F, "X-Newsreader: "Reader_Name" v"version"\n");
    fclose(F);

    offline_packet::enter_msg();
}

void soup_packet::edit_msg(unsigned num)
{
    char fname[256], old[256], *data, *strp;
    FILE *Fold, *Fnew;

    sprintf(fname, "%s%s", setup.replypath, reply.fname);
    strp = strrchr(fname, '.');
    if (strp != NULL) *strp = '\0';
    sprintf(old, "%s.fld", fname);
    strcat(fname, ".new");

    Fold = FileOpen(old, "rb");
    if (Fold == NULL) return;

    Fnew = FileOpen(fname, "w+b");
    if (Fnew == NULL)
    {
        fclose(Fold);
        return;
    }

    data = (char *) malloc(1000);
    if (data == NULL)
    {
        fclose(Fold);
        fclose(Fnew);
        return;
    }

    if (reply.flags & flag_email)
        fprintf(Fnew, "To: %s\n", reply.mto);
    else
        fprintf(Fnew, "Newsgroups: %s\n", reply.mto);
    fprintf(Fnew, "Subject: %s\n", reply.subj);

    while (_fgets(data, 1000, Fold))
    {
        if (strnicmp(data, "Newsgroups: ", 12) == 0) continue;
        if (strnicmp(data, "Subject: ", 9) == 0) continue;
        if (strnicmp(data, "To: ", 4) == 0) continue;
        fprintf(Fnew, "%s\n", data);
    }
    free(data);

    fclose(Fold);
    fclose(Fnew);

    FileRemove(old);
    FileRename(fname, old);

    offline_packet::edit_msg(num);
}

/*char *soup_packet::export_msg(char *out)
{
    FILE *F;
    unsigned num,num2;
    size_t readed;

    strcat(strcpy(out,setup.workpath),"TMP_ANSI.");
    if ((F = FileOpen(out,"w+b")) == NULL) return NULL;

    fseek(Fdat,msgtxtptr+1,SEEK_SET);
    num2 = msgtxtsize/BUF_SIZE;
    for (num=1; num<=num2; num++)
    {
        readed = fread(txt_buf,1,BUF_SIZE,Fdat);
        fwrite(txt_buf,1,readed,F);
    }
    readed = fread(txt_buf,1,msgtxtsize % BUF_SIZE,Fdat);
    fwrite(txt_buf,1,readed,F);

    fclose(F);
    return out;
    }*/

