#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "entermsg.h"
#include "offcfg.h"
#include "readrepl.h"
#include "newfiles.h"

#include "bluewave.h"
#include "readmail.h"
#include "readsets.h"
#include "openpkt.h"
#include "files.h"
#include "shell.h"
#include "screen.h"
#include "setprefs.h"
#include "general.h"
#include "scrsaver.h"
#include "keyb.h"
#include "vars.h"

static char slen;

static void clropt(int y)
{
    tattrbar(5,y+4,8+slen,y+4,color[col_box_text]);
    writechr(5+keypos[y-1],y+4,keys[y-1],color[col_box_hilight]);
}

static void error_opening(void)
{
    unsigned short ox,oy;
    char *oldscr;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-30,10,scrwidth/2+30,14,color[col_warn_frame],color[col_warn_title],"Error");
    cmiddle(12,"Could not do .. something .. out of memory?",color[col_warn_text]);
    try_key(5);
    old_scr(ox,oy,&oldscr);
}

void reply_mgr(int open)
{
    unsigned short cx,cy;
    char *oldscr;

#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif
    char tmp[256],quit,ch;
    int num,Error,ypos;

    find_t SR;
    FILE *Finf;
    INF_HEADER info;

    replymgr = 1;

    if (!open)
    {
        /* Select packet */
        if (select_packet(0,pktname) == NULL) return;
    }

    /* Open packet */
    sprintf(tmp,"%s%s.inf",setup.datapath,pktname);
    Finf = fopen_ign(tmp,"rb");
    if (Finf == NULL)
    {
        sprintf(tmp, "Sorry, could not open file %s.inf", pktname);
        err_box(tmp);
        return;
    }

    if (!fread(&info,sizeof(info),1,Finf))
    {
        fclose(Finf);
        return;
    }
    fclose(Finf);

    sprintf(tmp,"%s%s.",setup.datapath,pktname);

    switch (info.ver)
    {
        case 0:
            if (open_packet(tmp,format_qwk))
            {
                error_opening();
                return;
            }
            strcpy(ext,".rep");
            fmt = format_qwk;
            break;
        case 252:
            if (open_packet(tmp,format_soup))
            {
                error_opening();
                return;
            }
            strcpy(ext,".rep");
            fmt = format_soup;
            break;
        case 253:
            strcpy(omentag,pktname);
            if (open_packet(tmp,format_omen))
            {
                error_opening();
                return;
            }
            switch (pkt->info.mashtype)
            {
                case format_zip: strcpy(ext, ".zip"); break;
                case format_arj: strcpy(ext, ".arj"); break;
                case format_rar: strcpy(ext, ".rar"); break;
                case format_uc2: strcpy(ext, ".uc2"); break;
                case format_lha: strcpy(ext, ".lzh"); break;
                case format_aux: strcpy(ext, ".aux"); break;
            }
            fmt = format_omen;
            break;
        case 254:
            if (open_packet(tmp,format_hippo))
            {
                error_opening();
                return;
            }
            strcpy(ext,".hra");
            fmt = format_hippo;
            break;
        default:
            if (open_packet(tmp,format_bw))
            {
                error_opening();
                return;
            }
            strcpy(ext,".new");
            fmt = format_bw;
            break;
    }
    arcfmt = pkt->info.mashtype;
    pkt->txt_length = scrwidth-1;

    strcpy(reppkt,setup.uppath);
    if (fmt == format_omen)
    {
        sprintf(pktname,"return%s",omentag);
        sprintf(tmp,"%s%s.*",setup.uppath,pktname);
        Error = _dos_findfirst(tmp,0,&SR);
#ifdef FIND_CLOSE
        _dos_findclose(&SR);
#endif
        if (Error == 0)
        {
            strcat(reppkt,SR.name);
        }
        else
        {
            strcpy(reppkt,pktname);
            strcat(reppkt,ext);
        }
    }
    else
    {
        strcat(strcat(reppkt,pktname),ext);
    }

    if (!open || !replyopen)
    {
        replyopen = 1;
        doto_packet(reppkt,0);
    }

    /* Write restart file */
    sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
    Fsky = FileOpen(tmp,"w+b");
    fwrite(pktname,13,1,Fsky);
    fwrite(&arcfmt,1,1,Fsky);
    fwrite(&replyopen,1,1,Fsky);
    fwrite(&replymgr,1,1,Fsky);

    /* Reopen it to make sure it was saved. */
    fclose(Fsky);
    Fsky = FileOpen(tmp,"r+b");

    /* Initialize reply packet */
    pkt->open_replypacket();

    read_setup(NULL);
    read_table(1,inbound,opt.intable);
    read_table(0,outbound,opt.outtable);

    save_scr(&cx,&cy,&oldscr);

    draw_shaded_box(40,4,78,8,color[col_box_frame],color[col_box_title],lang[39]);
    cwritexy(42,5,lang[40],color[col_box_hilight]);
    cwritexy(42,6,lang[45],color[col_box_hilight]);
    cwritexy(42,7,lang[46],color[col_box_hilight]);

    switch (fmt)
    {
        case format_bw: cwritexy(55,5,"Blue Wave",color[col_box_text]); break;
        case format_qwk: cwritexy(55,5,"QWK",color[col_box_text]); break;
        case format_omen: cwritexy(55,5,"OMEN",color[col_box_text]); break;
        case format_hippo: cwritexy(55,5,"Hippo",color[col_box_text]); break;
        case format_soup: cwritexy(55,5,"SOUP",color[col_box_text]); break;
    }

    cwritexy(55,7,pkt->username,color[col_box_text]);

    settitle(conv_macros(setup.title,tmp));

    tbar(1,scrsize-1,scrwidth,scrsize-1,color[col_bbs_name]);
    tbar(1,scrsize,scrwidth,scrsize,color[col_sysop_name]);
    cwritexy(2,scrsize-1,"BBS   :",color[col_bbs_name_text]); cwritexy(10,scrsize-1,pkt->board_name,color[col_bbs_name]);
    cwritexy(2,scrsize,"Sysop :",color[col_sysop_name_text]); cwritexy(10,scrsize,pkt->sysop_name,color[col_sysop_name]);

    slen = get_max_langtext_len(204,209);
    draw_shaded_box(4,4,7+slen+2,10,color[col_box_frame],color[col_box_title],lang[204]);
    ypos = 1;
__again:
    if (replyopen)
    {
        tbar(55,6,77,6,color[col_box_text]);
        sprintf(tmp,"%u",pkt->replies);
        cwritexy(55,6,tmp,color[col_box_text]);
    }
    else
    {
        cwritexy(55,6,lang[47],color[col_box_text]);
    }

    keys[0] = toupper(highwrite(6,5,lang[205],&keypos[0]));
    keys[1] = toupper(highwrite(6,6,lang[206],&keypos[1]));
    keys[2] = toupper(highwrite(6,7,lang[207],&keypos[2]));
    keys[3] = toupper(highwrite(6,8,lang[208],&keypos[3]));
    keys[4] = toupper(highwrite(6,9,lang[209],&keypos[4]));

    tattrbar(5,ypos+4,8+slen,ypos+4,color[col_box_select]);

    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = (char) toupper(sk_getch());
            for (num=0; num<=4; num++)
                if (toupper(keys[num]) == ch)
                {
                    clropt(ypos); ypos--;
                    ypos = num+1;
                    tattrbar(5,ypos+4,8+slen,ypos+4,color[col_box_select]);
                    ch = 13;
                }
            switch (ch)
            {
                case 13:
                    switch (ypos)
                    {
                        case 1:
                            read_replies(0);
                            goto __again;
                        case 2:
                            enter_msg(0);
                            goto __again;
                        case 3:
                            offline_config(4,4,9+slen,10);
                            goto __again;
                        case 4:
                            freq();
                            goto __again;
                        case 5:
                            quit = 1;
                            break;
                    }
                    break;
                case 27:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            /* Down */
                            clropt(ypos);
                            if (ypos == 5) ypos = 1; else ypos++;
                            tattrbar(5,4+ypos,8+slen,4+ypos,color[col_box_select]);
                            break;
                        case 'H':
                            /* Up */
                            clropt(ypos);
                            if (ypos == 1) ypos = 5; else ypos--;
                            tattrbar(5,4+ypos,8+slen,4+ypos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    /* Close reply packet */
    pkt->close_replypacket();

    /* Save old drive & path */
#ifndef __NO_DRIVES__
    _dos_getdrive(&drive);
#endif
    getcwd(tmp,sizeof(tmp));

    fclose(Fsky);

    /* Pack replies */
    if (pack_replypacket(pkt->arealist,pkt->replies))
    {
        erase_workdir();
        erase_replydir();
    }

#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(tmp);

    /* Close packet */
    close_packet();

    old_scr(cx,cy,&oldscr);
    replymgr = 0;
}
