#ifndef __screen_h
#define __screen_h

#include <string.h>

#ifdef __linux__
#  include <ncurses.h>
extern int changed;
void InitScreen(void);
#else
#  define refresh()
typedef int chtype;
#endif

#ifdef __NT__
void InitScreen(void);
#elif !defined (__OS2__) && !defined (__linux__)
#ifndef __386__
extern char far *s_screen;
extern unsigned short far *screen;
#else
extern char *s_screen;
extern unsigned short *screen;
#endif
#endif

void gotoxy(int x, int y);
void cwritexy(int x, int y, char *str, char col);
void writechr(int x, int y, chtype chr, char col);
void writeblock(int x, int y, char *block, int len);
void tclrscr(void);
void tbar(int x1, int y1, int x2, int y2, int col);
void tbox(int x1, int y1, int x2, int y2, int col, int ct);
void tattr(int x, int y, char col);
void tattrbar(int x1, int y1, int x2, int y2, char col);
void draw_shaded_box(int x1, int y1, int x2, int y2, int col1, int col, char *str);
void nocursor(void);
void save_scr(unsigned short *ox, unsigned short *oy, char **oldscr);
void old_scr(unsigned short ox, unsigned short oy, char **oldscr);
void cursorsize(int cstart,int cend);
void scroll_down(int x1, int y1, int x2, int y2);
void scroll_up(int x1, int y1, int x2, int y2);
void getcursorsize(char *cstart, char *cend);
void draw_clock(void);
void get_attr(int x1, int x2, int y, char *buf);

void err_box(char *text);
void draw_hline(int x1, int x2, int y, char col);
void _draw_hline(int x1, int x2, int y, char col);

char *gettitle(char *title);
void settitle(char *title);

extern unsigned c_height;
extern unsigned scrwidth;
extern unsigned scrsize;
extern unsigned chg_title;
extern unsigned wherex,wherey;

#define cmiddle(y,str,col) cwritexy(((scrwidth-strlen(str)) >> 1)+1,y,str,col)

#endif
