#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK ''
#endif

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "setprefs.h"
#include "pkt_bw.h"
#include "vars.h"
#include "files.h"
#include "general.h"
#include "screen.h"
#include "readsets.h"
#include "keyb.h"
#include "scrsaver.h"
#include "shell.h"
#include "setup.h"

#define MAX_PACKETS 256

typedef struct {
    char inifound;
    char ver;
    char shortname[9];
    char name[31];
} packet_type;

static packet_type *packets;
static FILE *Fini;
static char max;

typedef int (*SORT_FUNC) (const void *, const void *);

char delete_packet(int pos, char *replypkt)
{
    unsigned short cx,cy;
    char *oldscr;
    
    char ch,ok,quit,st,flen,slen;
    
    char inifound,repfound;
    char col1,col2;
    char delinf,delini,delrep;
    
    find_t SR;
    
    char fname[9],tmp[256];
    
    save_scr(&cx,&cy,&oldscr);
    strcpy(fname,packets[pos].shortname);
    
    slen = strlen(fname);
    if ((unsigned char) packets[pos].ver == 253) flen = 8; else flen = slen;
    draw_shaded_box(23-(flen >> 1)-(flen & 1),11,56+(flen >> 1),17,
                    color[col_info_frame],color[col_info_title],"Delete what?");
    
    st = 26-(flen >> 1)-(slen & 1);
    cwritexy(st,13,"[ ]",color[col_info_text]);
    writechr(st+4,13,'H',color[col_info_hilight]);
    cwritexy(st+5,13,"ost information  -",color[col_info_text]);
    cwritexy(st+24,13,strcat(strcpy(tmp,fname),".inf"),color[col_info_hilight]);
    
    inifound = exists(strcat(strcat(strcpy(tmp,setup.datapath),fname),".ini"));
    
    if (!inifound) {
        col1 = color[col_info_disabled];
        col2 = color[col_info_disabled];
    } else {
        col1 = color[col_info_text];
        col2 = color[col_info_hilight];
    }
    
    cwritexy(st,14,"[ ]",col1);
    writechr(st+4,14,'S',col2);
    cwritexy(st+5,14,"etup information -",col1);
    cwritexy(st+24,14,strcat(strcpy(tmp,fname),".ini"),col2);

    repfound = 0;
    switch ((unsigned char) packets[pos].ver)
    {
        case 0:
            strcat(strcpy(replypkt,fname),".rep");
            break;
        case 254:
            strcat(strcpy(replypkt,fname),".hra");
            break;
        case 253:
            sprintf(replypkt, "return%s.*", fname);
            sprintf(tmp, "%s%s", setup.uppath, replypkt);
            if (_dos_findfirst(tmp,0,&SR) == 0)
            {
                strcpy(replypkt,SR.name);
                repfound = 1;
            }
#ifdef FIND_CLOSE
            _dos_findclose(&SR);
#endif
            break;
        default:
            strcat(strcpy(replypkt,fname),".new");
            break;
    }

#ifdef __linux__
    if ((unsigned char) packets[pos].ver != 253)
    {
        if (_dos_findfirst(strcat(strcpy(tmp,setup.uppath),replypkt),0,&SR) == 0)
        {
            repfound = 1;
            _dos_findclose(&SR);
        }
    }
#else
    if ((unsigned char) packets[pos].ver != 253)
        repfound = exists(strcat(strcpy(tmp,setup.uppath),replypkt));
#endif

    if (!repfound)
    {
        col1 = color[col_info_disabled];
        col2 = color[col_info_disabled];
    }
    else
    {
        col1 = color[col_info_text];
        col2 = color[col_info_hilight];
    }

    delinf = 0;
    delini = 0;
    delrep = 0;
    
    cwritexy(st,15,"[ ]",col1);
    writechr(st+4,15,'R',col2);
    cwritexy(st+5,15,"eply packet      -",col1);
    cwritexy(st+24,15,replypkt,col2);

    quit = 0; ok = 0;
    while (!quit)
    {
        ch = toupper(sk_getch());
        switch (ch)
        {
            case 13:
                ok = 1;
                quit = 1;
                break;
            case 27:
                ok = 0;
                quit = 1;
                break;
            case 'H':
                delinf = !delinf;
                if (delinf)
                    writechr(st+1,13,CHECK,color[col_info_hilight]);
                else
                    writechr(st+1,13,' ',color[col_info_hilight]);
                break;
            case 'S':
                if (inifound)
                {
                    delini = !delini;
                    if (delini)
                        writechr(st+1,14,CHECK,color[col_info_hilight]);
                    else
                        writechr(st+1,14,' ',color[col_info_hilight]);
                }
                break;
            case 'R':
                if (repfound)
                {
                    delrep = !delrep;
                    if (delrep)
                        writechr(st+1,15,CHECK,color[col_info_hilight]);
                    else
                        writechr(st+1,15,' ',color[col_info_hilight]);
                }
                break;
            case 0:
                ch = sk_getch();
                switch (ch) {
                    case '$':
                        shell_dos();
                        break;
                    case 19:
                        if (repfound) {
                            delrep = !delrep;
                            if (delrep)
                                writechr(st+1,15,CHECK,color[col_info_hilight]);
                            else
                                writechr(st+1,15,' ',color[col_info_hilight]);
                        }
                        break;
                    case 31:
                        if (inifound) {
                            delini = !delini;
                            if (delini)
                                writechr(st+1,14,CHECK,color[col_info_hilight]);
                            else
                                writechr(st+1,14,' ',color[col_info_hilight]);
                        }
                        break;
                    case 35:
                        delinf = !delinf;
                        if (delinf)
                            writechr(st+1,13,CHECK,color[col_info_hilight]);
                        else
                            writechr(st+1,13,' ',color[col_info_hilight]);
                        break;
                }
                break;
        }
    }
    old_scr(cx,cy,&oldscr);
    
    ch = 0;
    if (ok)
    {
        if (delinf)
        {
            /* Remove host information file */
            ch = 1;
            sprintf(tmp,"%s%s.inf",setup.datapath,fname);
            FileRemove(search_ign_file(tmp));
        }
        if (delini)
        {
            /* Remove setup information file */
            ch = 1;
            sprintf(tmp,"%s%s.ini",setup.datapath,fname);
            FileRemove(search_ign_file(tmp));
        }
        if (delrep)
        {
            /* Remove reply packet */
            ch = 1;
            sprintf(tmp,"%s%s",setup.uppath,replypkt);
            FileRemove(search_ign_file(tmp));
        }
    }
    return ch;
}

int compare_name(const packet_type *op1, const packet_type *op2)
{
    return strcmp(op1->shortname, op2->shortname);
}

char *select_packet(char ini, char *packet)
{
    unsigned short cx,cy;
    char *oldscr;
    
    struct find_t SR,tSR;
    
    INF_HEADER info;
    
    char ypos,max;
    unsigned short pos,pkts,upy;
    
    FILE *F;
    size_t readed;
    
    char quit,ch,tmp[256],*pstr;
    int Error,len;
    
    char fname[9];
    char replypkt[13];
    
    
    if ((packets = (packet_type *) malloc(sizeof(packet_type)*MAX_PACKETS)) == NULL) return 0;
    save_scr(&cx,&cy,&oldscr);
    upy = 0; ypos = 1; len = strlen(lang[293])/2;
    draw_shaded_box(scrwidth/2-len-2,10,scrwidth/2+len+2,12,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(11,lang[293],color[col_info_text]);

again:
    Error = _dos_findfirst(strcat(strcpy(tmp,setup.datapath),"*.inf"),0,&SR);
    pkts = 0;
    while (Error == 0)
    {
        if (stricmp(SR.name,"packets.inf") != 0)
        {
            if ((F = FileOpen(strcat(strcpy(tmp,setup.datapath),SR.name),"rb")) != NULL)
            {
                readed = fread(&info,sizeof(INF_HEADER),1,F);
                fclose(F);
                
                pstr = strrchr(SR.name,'.');
                if (pstr != NULL) *pstr = 0;
                strupr(strcpy(packets[pkts].shortname,SR.name));
                info.systemname[30] = 0;
                strcpy(packets[pkts].name,(char *) info.systemname);
                packets[pkts].ver = info.ver;
                
                if (ini)
                {
                    if (exists(strcat(strcat(strcpy(tmp,setup.datapath),SR.name),".ini")))
                        packets[pkts].inifound = 1;
                    else
                        packets[pkts].inifound = 0;
                }
                else
                {
                    strcpy(fname,packets[pkts].shortname);
                    switch((unsigned char) packets[pkts].ver)
                    {
                        case 0:
                            strcat(strcpy(replypkt,fname),".rep");
                            break;
                        case 254:
                            strcat(strcpy(replypkt,fname),".hra");
                            break;
                        case 253:
                            sprintf(replypkt,"return%s.*",fname);
                            if (_dos_findfirst(strcat(strcpy(tmp,setup.uppath),replypkt),0,&tSR) == 0)
                            {
                                strcpy(replypkt,tSR.name);
                                packets[pkts].inifound = 1;
                            } else
                                packets[pkts].inifound = 0;
#ifdef FIND_CLOSE
                            _dos_findclose(&tSR);
#endif
                            break;
                        default:
                            strcat(strcpy(replypkt,fname),".new");
                            break;
                    }
                    
                    if ((unsigned char) packets[pkts].ver != 253) packets[pkts].inifound =
                        exists(strcat(strcpy(tmp,setup.uppath),replypkt));
                }
                    if (readed) pkts++;
            }
        }
        Error = _dos_findnext(&SR);
    }
#ifdef FIND_CLOSE
    _dos_findclose(&SR);
#endif

    old_scr(cx,cy,&oldscr);
    save_scr(&cx,&cy,&oldscr);
    if (pkts > 0)
    {
        /* Sort packets */
        qsort(packets,pkts,sizeof(packet_type),(SORT_FUNC) compare_name);

        len = pkts;
        if (len > scrsize-7) len = scrsize-7;
        draw_shaded_box(36,5,77,len+6,color[col_mail_frame],color[col_mail_title],lang[292]);

        max = len;
        if (max > pkts-upy) max = pkts-upy;
        for (pos=0; pos<max; pos++)
        {
            if (packets[pos+upy].inifound)
                writechr(37,6+pos,'*',color[col_mail_bbsname]);
            cwritexy(38,6+pos,packets[pos+upy].shortname,color[col_mail_filename]);
            cwritexy(47,6+pos,packets[pos+upy].name,color[col_mail_bbsname]);
        }

        tattrbar(37,ypos+5,76,ypos+5,color[col_mail_select]);
        quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = sk_getch();
                switch (ch)
                {
                    case 27:
                        ypos = 0; upy = 0; quit = 1;
                        break;
                    case 13:
                        quit = 1;
                        break;
                    case 0:
                        ch = sk_getch();
                        switch (ch)
                        {
                            case '$':
                                shell_dos();
                                break;
                            case 'H':
                                if (ypos+upy > 1)
                                {
                                    tattrbar(37,ypos+5,37,ypos+5,color[col_mail_bbsname]);
                                    tattrbar(38,ypos+5,46,ypos+5,color[col_mail_filename]);
                                    tattrbar(47,ypos+5,76,ypos+5,color[col_mail_bbsname]);
                                    if (ypos == 1)
                                    {
                                        upy--;
                                        scroll_down(37,6,76,5+len);
                                        tbar(37,6,76,6,color[col_mail_filename]);
                                        if (packets[upy].inifound)
                                            writechr(37,6,'*',color[col_mail_bbsname]);
                                        cwritexy(38,6,packets[upy].shortname,color[col_mail_filename]);
                                        cwritexy(47,6,packets[upy].name,color[col_mail_bbsname]);
                                    }
                                    else
                                        ypos--;
                                    tattrbar(37,ypos+5,76,ypos+5,color[col_mail_select]);
                                }
                                break;
                            case 'P':
                                if (ypos+upy < pkts)
                                {
                                    tattrbar(37,ypos+5,37,ypos+5,color[col_mail_bbsname]);
                                    tattrbar(38,ypos+5,46,ypos+5,color[col_mail_filename]);
                                    tattrbar(47,ypos+5,76,ypos+5,color[col_mail_bbsname]);
                                    if (ypos == len)
                                    {
                                        upy++;
                                        scroll_up(37,6,76,5+len);
                                        tbar(37,5+len,76,5+len,color[col_mail_filename]);
                                        if (packets[upy+len-1].inifound)
                                            writechr(37,5+len,'*',color[col_mail_bbsname]);
                                        cwritexy(38,5+len,packets[upy+len-1].shortname,color[col_mail_filename]);
                                        cwritexy(47,5+len,packets[upy+len-1].name,color[col_mail_bbsname]);
                                    }
                                    else
                                        ypos++;
                                    tattrbar(37,ypos+5,76,ypos+5,color[col_mail_select]);
                                }
                                break;
                            case 'S':
                                if ((ypos+upy <= pkts) && (delete_packet(ypos+upy-1,replypkt))) goto again;
                                break;
                        }
                }
            } else give_timeslice();
        }
    }
    else
    {
        draw_shaded_box(scrwidth/2-15,10,scrwidth/2+15,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,"No mail packets found",color[col_warn_hilight]);
        try_key(2);
    }
    old_scr(cx,cy,&oldscr);
    strcpy(packet,packets[ypos+upy-1].shortname);
    free(packets);

    if ((ypos+upy == 0) || (pkts == 0)) return NULL;
    return packet;
}

void reread_ini(void)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned long num, fsize;
    unsigned n2;

    fseek(Fini,0,SEEK_END);
    fsize = ftell(Fini);
    if (fsize < sizeof(PrefsRecord)*2) return;

    save_scr(&cx,&cy,&oldscr);
    num = strlen(lang[293])/2;
    draw_shaded_box(scrwidth/2-num-2,10,scrwidth/2+num+2,12,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(11,lang[293],color[col_info_text]);

    fseek(Fini,sizeof(PrefsRecord),SEEK_SET);
    num = 1;
    while (num < fsize/sizeof(PrefsRecord))
    {
        fseek(Fini,num*sizeof(PrefsRecord),SEEK_SET);
        if (!fread(&opt,sizeof(PrefsRecord),1,Fini)) break;

        if (bw->info.ver == 254)
            n2 = bw->getaname(bw, opt.areatag); /* Hippo */
        else
            n2 = bw->gettag(bw, opt.areatag);

        if (n2 > 0)
        {
            iniarea[n2-1] = (iniarea[n2-1] & 32768)+num;
            num++;
        }
        else
        {
            /* Record not found from .inf file, delete it. */
            delete_space(Fini,num*sizeof(PrefsRecord),sizeof(PrefsRecord),fsize);
            fsize -= sizeof(PrefsRecord);
            ftrunc(Fini,fsize);
        }
    }
    old_scr(cx,cy,&oldscr);
}

static void draw_line(char ypos, unsigned area)
{
    char str[81];
    char ch;

    tbar(4,ypos,77,ypos,color[col_area_name]);
    if ((iniarea[area-1] & 32767) > 0)
        writechr(4,ypos,'',color[col_area_tagged2]);
    if ((iniarea[area-1] & 32768) > 0)
        writechr(5,ypos,'',color[col_area_tagged]);
    strcpy(str, bw->get_area_number(bw, area));
    
    cwritexy(10-strlen(str),ypos,str,color[col_area_number]);
    if (bw->info.ver == 0)
        cwritexy(11,ypos,"QWK",color[col_area_type]);
    else {
        ch = bw->area_type(area);
        if (ch & TYPE_ECHO)
            if (ch & TYPE_NET)
                cwritexy(11,ypos,"Net",color[col_area_type]);
            else
                cwritexy(11,ypos,"Echo",color[col_area_type]);
        else
            if (bw->info.ver == 253)
                cwritexy(11,ypos,"OMEN",color[col_area_type]);
            else
                cwritexy(11,ypos,"Local",color[col_area_type]);
    }
    
    strcpy(str,bw->get_area_name(area)); str[44] = 0;
    cwritexy(17,ypos,str,color[col_area_name]);
    strcpy(str,bw->get_area_tag(area)); str[15] = 0;
    cwritexy(62,ypos,str,color[col_area_tagname]);
}

void delete_area(unsigned area)
{
    fpos_t fsize;

    fseek(Fini,0,SEEK_END);
    fgetpos(Fini,&fsize);
    delete_space(Fini,(unsigned long) area*sizeof(PrefsRecord),sizeof(PrefsRecord),fsize);
    ftrunc(Fini,fsize-sizeof(PrefsRecord));
    reread_ini();
}

void area_list(char *pypos, unsigned *pupy)
{
    char ch,quit,way;
    unsigned num;

    char ypos = *pypos;
    unsigned upy = *pupy;

    quit = 0;
    way = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$': shell_dos(); break;
                        case 'S':
                            if (iniarea[ypos+upy-1] > 0)
                            {
                                delete_area(iniarea[ypos+upy-1] & 32767);
                                iniarea[ypos+upy-1] &= 32768;
                                draw_line(ypos+5,ypos+upy);
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                                if (way == 1) goto __up; else goto __down;
                            }
                            break;
                        case 'G':
                            if (ypos+upy > 1)
                            {
                                draw_line(ypos+5,ypos+upy);
                                ypos = 1;
                                if (upy > 0) {
                                    upy = 0;
                                    for (ch=1; ch<=scrsize-7; ch++)
                                        draw_line(ch+5,ch);
                                }
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'O':
                            if (ypos+upy < bw->areas)
                            {
                                draw_line(ypos+5,ypos+upy);
                                if (bw->areas < scrsize-7)
                                    ypos = bw->areas;
                                else
                                {
                                    ypos = scrsize-7;
                                    if (bw->areas-ypos > upy)
                                    {
                                        upy = bw->areas-ypos;
                                        for (ch=1; ch<=scrsize-7; ch++)
                                            draw_line(ch+5,ch+upy);
                                    }
                                }
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'Q':
                            if (ypos+upy < bw->areas)
                            {
                                draw_line(ypos+5,ypos+upy);
                                if (bw->areas < scrsize-7)
                                    ypos = bw->areas;
                                else
                                    if (ypos < scrsize-7)
                                        ypos = scrsize-7;
                                    else {
                                        upy += scrsize-8;
                                        if (bw->areas < ypos+upy)
                                            upy = bw->areas-(scrsize-7);
                                        for (ch=1; ch<=scrsize-7; ch++)
                                            draw_line(ch+5,ch+upy);
                                    }
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'I':
                            if (ypos+upy > 1)
                            {
                                draw_line(ypos+5,ypos+upy);
                                if (ypos > 1)
                                    ypos = 1;
                                else
                                {
                                    if ((int) (upy-scrsize+8) < 0)
                                        upy = 0;
                                    else
                                        upy -= scrsize-8;
                                    for (ch=1; ch<=scrsize-7; ch++)
                                        draw_line(ch+5,ch+upy);
                                }
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'H':
                        __up:
                            if (ypos+upy > 1)
                            {
                                way = 1;
                                draw_line(ypos+5,ypos+upy);
                                if (ypos == 1)
                                {
                                    upy--;
                                    scroll_down(4,6,77,scrsize-2);
                                    draw_line(ypos+5,ypos+upy);
                                } else ypos--;
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'P':
                        __down:
                            if (ypos+upy < bw->areas)
                            {
                                way = 0;
                                draw_line(ypos+5,ypos+upy);
                                if (ypos == scrsize-7)
                                {
                                    upy++;
                                    scroll_up(4,6,77,scrsize-2);
                                    draw_line(ypos+5,ypos+upy);
                                } else ypos++;
                                tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                    }
                    break;
                case ' ': 
                    iniarea[ypos+upy-1] ^= 32768;
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                    if (way == 1) goto __up; else goto __down;
                case '*':
                    for (num=0; num<bw->areas; num++)
                        iniarea[num] ^= 32768;
                    for (num=0; num<max; num++)
                        if (iniarea[num+upy] & 32768)
                            writechr(5,num+5,'',color[col_area_tagged]);
                        else
                            writechr(5,num+5,' ',color[col_area_tagged]);
                        draw_line(ypos+5,ypos+upy);
                        tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                        break;
                case '-':
                    for (num=0; num<bw->areas; num++)
                        iniarea[num] &= 32767;
                    for (num=0; num<max; num++)
                        writechr(5,num+5,' ',color[col_area_tagged]);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                    break;
                case '+':
                    for (num=0; num<bw->areas; num++)
                        iniarea[num] |= 32768;
                    for (num=0; num<max; num++)
                        writechr(5,num+5,'',color[col_area_tagged]);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,77,ypos+5,color[col_area_selectbar]);
                    break;
                case 13:
                    quit = 1; break;
                case 27:
                    quit = 1; ypos = 0; break;
            }
        } else give_timeslice();
    }
    *pypos = ypos;
    *pupy = upy;
}

void select_area(void)
{
    unsigned short cx,cy;
    char *oldscr;
    
    char ypos;
    unsigned upy, pos;
    
    char tmp[256];
    
    
    if ((bw = new bw_packet) == NULL)
    {
        err_box("Not enough memory!");
        return;
    }
    
    bw->area_start = 65535;
    bw->area_end = 0;
    sprintf(tmp, "%s%s.inf", setup.datapath, mailpkt);
    if ((bw->Finfo = fopen_ign(tmp, "rb")) == NULL)
    {
        err_box("Can't open .inf file!");
        delete bw;
        return;
    }
    fseek(bw->Finfo,0,SEEK_END);
    bw->areas = (ftell(bw->Finfo)-sizeof(INF_HEADER)) / sizeof(INF_AREA_INFO);
    fseek(bw->Finfo,0,SEEK_SET);

    sprintf(tmp, "%s%s.ini", setup.datapath, mailpkt);
    if ((Fini = fopen_ign(tmp,"r+b")) == NULL)
        if ((Fini = FileOpen(tmp,"w+b")) == NULL)
        {
            err_box("Can't create .ini file!");
            fclose(bw->Finfo);
            delete bw;
            return;
        }
    if (fread(&bw->info,sizeof(INF_HEADER),1,bw->Finfo) != 1)
    {
        err_box("Can't read .inf file!");
        fclose(bw->Finfo);
        fclose(Fini);
        delete bw;
        return;
    }
    
    if (bw->info.inf_header_len < ORIGINAL_INF_HEADER_LEN)
        bw->inf_header_slen = ORIGINAL_INF_HEADER_LEN;
    else
        bw->inf_header_slen = bw->info.inf_header_len;
    
    if (bw->info.inf_areainfo_len < ORIGINAL_INF_AREA_LEN)
        bw->inf_area_slen = ORIGINAL_INF_AREA_LEN;
    else
        bw->inf_area_slen = bw->info.inf_areainfo_len;

    if (bw->areas < MAX_AREAS)
        bw->abufsize = bw->areas;
    else
        bw->abufsize = MAX_AREAS;
    
    if ((bw->area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*bw->abufsize)) == NULL)
    {
        err_box("Not enough memory!");
        return;
    }
    if ((iniarea = (unsigned short *) malloc(sizeof(unsigned short)*bw->areas)) == NULL)
    {
        err_box("Not enough memory!");
        return;
    }
    
    useiniarea = 1;
    memset(iniarea,0,bw->areas*sizeof(unsigned short));
    
    ypos = 1; upy = 0;
__draw_again:
    save_scr(&cx,&cy,&oldscr);
    
    draw_shaded_box(3,3,78,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4," Area Type  Description                                  Area tag",color[col_area_help]);
    draw_hline(3,78,5,color[col_area_frame]);
    reread_ini();
    
    max = scrsize-7;
    if (bw->areas-upy < max) max = bw->areas-upy;
    for (pos=1; pos<=max; pos++)
        draw_line(5+pos, upy+pos);
    tattrbar(4,5+ypos,77,5+ypos,color[col_area_selectbar]);
    area_list(&ypos,&upy);
    fclose(Fini);
    if (ypos > 0) {
        old_scr(cx,cy,&oldscr);
        if (bw->info.ver == 254)
            setup_preferences_default(OPTIONS_AREAOVRRIDE,bw->get_area_name(ypos+upy));
        else
            setup_preferences_default(OPTIONS_AREAOVRRIDE,bw->get_area_tag(ypos+upy));
        if ((Fini = FileOpen(strcat(strcat(strcpy(tmp,setup.datapath),mailpkt),".ini"),"r+b")) != NULL)
            goto __draw_again;
        if ((Fini = FileOpen(tmp,"w+b")) != NULL)
            goto __draw_again;
    }
    old_scr(cx,cy,&oldscr);
    fclose(bw->Finfo);
    
    free(bw->area_buf);
    free(iniarea);
    delete bw;
    useiniarea = 0;
}
