/* Number of lines in language file and color configuration */
/* Muista pivitt nm mys install.cpp:st!!!!! */
/* jossain tuolta pit poistaa ett voi pit pakkaamattomia pakuja! */
#define LangLines 334
#define NumColors 126

/*char ncrc_start[] = { 128,31,38,192,128,51,124,19,35,117,184,37,249,91 };
char ncrc_end[] = { 161,24,31,235,51,231,53,145,4,63,63,45,217,57,231 };

extern "C"
{
    extern unsigned char *crcstring1;
};*/

#ifdef __OS2__
#  define INCL_VIO
#  define INCL_DOS
#  define INCL_KBD
#  include <os2.h>
#elif defined (__NT__)
#  include <windows.h>
extern HANDLE scrHandle;
#elif !defined (__linux__)
#  define __MSDOS__
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <signal.h>

#ifdef __linux__
#  include <unistd.h>
#else
#  include <direct.h>
#endif

#include "files.h"
#include "vars.h"
#include "screen.h"
#include "scrsaver.h"
#include "openmail.h"
#include "setup.h"
#include "readsets.h"
#include "shell.h"
#include "general.h"
#include "keyb.h"
#include "replymgr.h"
#include "version.h"

/*#ifndef __linux__
#define CRCSTRING crcstring1
#include "checkcrc.h"
#endif*/

int checkkeyfile(char *regname);

#ifdef __linux__
char *home;
#endif

char keep_video_mode;

#if defined (__MSDOS__) && !defined (__386__)
#  include "spawno.h"
#endif

int read_language_file(void)
{
    FILE *Flang;
    char str[256];
    int line;

    line = 0;

    if ((lang = (LangType *) malloc(sizeof(LangType)*LangLines)) == NULL)
    {
        err_box("Not enough memory!");
        return 0;
    }

#ifdef __linux__
    if ((Flang = FileOpen("~/.skyreader/language.dat","rt")) == NULL)
    {
        err_box("Language file '~/.skyreader/language.dat' not found!");
        return 0;
    }
#else
    if ((Flang = FileOpen("language.dat","rt")) == NULL)
    {
        err_box("Language file 'language.dat' not found!");
        return 0;
    }
#endif

    do
    {
        _fgets(str,sizeof(str),Flang);

        if (str[0] != ';' && str[0] != '\0') {
            strncpy(lang[line], str, 80); lang[line][80] = 0;
            line++;
        }

        if ((feof(Flang)) && (line < LangLines)) {
            err_box("Corrupted language file (lines missing)!");
            return 0;
        }
    } while (line != LangLines);

    fclose(Flang);

    /* Get month names */
    if (sscanf(lang[8],"%s %s %s %s %s %s %s %s %s %s %s %s",
               month[0],month[1],month[2],month[3],month[4],month[5],
               month[6],month[7],month[8],month[9],month[10],month[11]) < 12)
    {
        err_box("Corrupted language file: Something wrong with month names");
        return 0;
    }

    return 1;
}

int read_color_file(void)
{
    unsigned short cx,cy;
    char *oldscr;

    FILE *Fcol;
    long line;
    char str[256];
    int fore,back;

    line = 0;
#ifdef __linux__
    Fcol = FileOpen("~/.skyreader/colors.cfg","rt");
#else
    Fcol = FileOpen("colors.cfg","rt");
#endif
    if (Fcol == NULL)
    {
        save_scr(&cx,&cy,&oldscr);
#ifdef __linux__
        draw_shaded_box(scrwidth/2-31,10,scrwidth/2+31,14,(4<<4)+12,(4<<4)+15,NULL);
        cmiddle(12,"Color configuration file '~/.skyreader/colors.cfg' not found!",(4<<4)+15);
#else
        draw_shaded_box(scrwidth/2-25,10,scrwidth/2+26,14,(4<<4)+12,(4<<4)+15,NULL);
        cmiddle(12,"Color configuration file 'colors.cfg' not found!",(4<<4)+15);
#endif
        if (sk_getch() == 0) sk_getch();
        old_scr(cx,cy,&oldscr);
        return 0;
    }

    while (line < NumColors)
    {
        if (_fgets(str,sizeof(str),Fcol) == NULL)
        {
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(scrwidth/2-27,10,scrwidth/2+27,14,(4<<4)+12,(4<<4)+15,NULL);
            cmiddle(12,"Corrupted color configuration file (lines missing)!",(4<<4)+15);
            if (sk_getch() == 0) sk_getch();
            old_scr(cx,cy,&oldscr);
            return 0;
        }

        if (str[0] == '\0' || str[0] == ';') continue;

        if (sscanf(str,"%d %d",&fore,&back) == 2)
        {
            color[line] = (unsigned char) (fore+back*16);
            line++;
        }
    }

    fclose(Fcol);

    return 1;
}

static void clropt(int y, int box_end)
{
    tattrbar(9,y+5,box_end-1,y+5,color[col_box_text]);
    writechr(10+keypos[y-1]-1,y+5,keys[y-1],color[col_box_hilight]);
}

void GetDefaultConfig(void)
{
    char path[256],*pstr;
    int slen;

    getcwd(path,sizeof(path)-1); slen = strlen(path); path[slen] = SLASH; path[slen+1] = 0;
    memset(&setup,0,sizeof(setup));
#ifdef __OS2__
    strcpy(setup.zip_cmd,"zip.exe -juk9D");
    strcpy(setup.unzip_cmd,"unzip.exe -j");
    strcpy(setup.arj_cmd,"arj.exe u -jm");
    strcpy(setup.unarj_cmd,"arj.exe e");
    strcpy(setup.rar_cmd,"rar.exe u -m5 -std");
    strcpy(setup.unrar_cmd,"rar.exe e");
    strcpy(setup.uc2_cmd,"uc2.exe a !NEWER -tt");
    strcpy(setup.unuc2_cmd,"uc2.exe e");
    strcpy(setup.lha_cmd,"lh.exe u /i");
    strcpy(setup.unlha_cmd,"lh.exe x");

    strcpy(setup.editor,"!");

    setup.modenum = 1;
    setup.scrmode[0].columns = 80;
    setup.scrmode[0].rows = 25;
    setup.scrmode[0].hres = 720;
    setup.scrmode[0].vres = 400;
    setup.scrmode[1].columns = 80;
    setup.scrmode[1].rows = 50;
    setup.scrmode[1].hres = 720;
    setup.scrmode[1].vres = 400;
    setup.scrmode[2].columns = 80;
    setup.scrmode[2].rows = 60;
    setup.scrmode[2].hres = 720;
    setup.scrmode[2].vres = 480;
    setup.scrmode[3].columns = 132;
    setup.scrmode[3].rows = 44;
    setup.scrmode[3].hres = 1056;
    setup.scrmode[3].vres = 396;
    setup.scrmode[4].columns = 132;
    setup.scrmode[4].rows = 60;
    setup.scrmode[4].hres = 1056;
    setup.scrmode[4].vres = 480;
#else
#ifdef __linux__
    strcpy(setup.zip_cmd,"zip -juk9D");
    strcpy(setup.unzip_cmd,"unzip -j");
    strcpy(setup.arj_cmd,"arj.exe u -jm");
    strcpy(setup.unarj_cmd,"unarj e");
    strcpy(setup.rar_cmd,"rar u -m5 -std");
    strcpy(setup.unrar_cmd,"rar e -c- -o+ -ep");
    strcpy(setup.uc2_cmd,"uc2.exe a !NEWER -tt");
    strcpy(setup.unuc2_cmd,"uc2.exe e");
    strcpy(setup.lha_cmd,"lha uo");
    strcpy(setup.unlha_cmd,"lha e");

    pstr = getenv("EDITOR");
    if (pstr == NULL)
        strcpy(setup.editor, "!");
    else
        strcpy(setup.editor, pstr);
#else
    strcpy(setup.zip_cmd,"pkzip.exe -u -ex");
    strcpy(setup.unzip_cmd,"pkunzip.exe");
    strcpy(setup.arj_cmd,"arj.exe u -jm");
    strcpy(setup.unarj_cmd,"arj.exe e");
    strcpy(setup.rar_cmd,"rar.exe u -m5");
    strcpy(setup.unrar_cmd,"rar.exe e");
    strcpy(setup.uc2_cmd,"uc2.exe a !NEWER -tt");
    strcpy(setup.unuc2_cmd,"uc2.exe e");
    strcpy(setup.lha_cmd,"lha.exe u");
    strcpy(setup.unlha_cmd,"lha.exe e");

    strcpy(setup.editor,"!");
#endif

    setup.modenum = 1;
    setup.scrmode[0].columns = 80;
    setup.scrmode[0].rows = 25;
#ifndef __NT__
    setup.scrmode[0]._ax = 3;
    setup.scrmode[0]._bx = 0;
#endif
    setup.scrmode[1].columns = 80;
    setup.scrmode[1].rows = 50;
#ifndef __NT__
    setup.scrmode[1]._ax = 0x1112;
    setup.scrmode[1]._bx = 0;
#endif
    setup.scrmode[2].columns = 80;
    setup.scrmode[2].rows = 60;
#ifndef __NT__
    setup.scrmode[2]._ax = 0x4f02;
    setup.scrmode[2]._bx = 0x108;
#endif
    setup.scrmode[3].columns = 132;
    setup.scrmode[3].rows = 43;
#ifndef __NT__
    setup.scrmode[3]._ax = 0x4f02;
    setup.scrmode[3]._bx = 0x10a;
#endif
    setup.scrmode[4].columns = 132;
    setup.scrmode[4].rows = 60;
#ifndef __NT__
    setup.scrmode[4]._ax = 0x4f02;
    setup.scrmode[4]._bx = 0x10c;
#endif
#endif

#ifdef __linux__
    strcpy(setup.datapath,"~/.skyreader/data");
    strcpy(setup.workpath,"~/.skyreader/work");
    strcpy(setup.replypath,"~/.skyreader/reply");
    strcpy(setup.uppath,"~/.skyreader/upload");
    strcpy(setup.downpath,"~/.skyreader/download");
    strcpy(setup.datapath,"~/.skyreader/data");
    strcpy(setup.packetpath,"~/.skyreader/packets");
    strcpy(setup.oldpktpath,"~/.skyreader/oldpkts");
#else
    strcat(strcpy(setup.datapath,path),"data");
    strcat(strcpy(setup.workpath,path),"work");
    strcat(strcpy(setup.replypath,path),"reply");
    strcat(strcpy(setup.uppath,path),"upload");
    strcat(strcpy(setup.downpath,path),"download");
    strcat(strcpy(setup.packetpath,path),"packets");
    strcat(strcpy(setup.oldpktpath,path),"oldpkts");
#endif

    pstr = getenv("PGPPATH");
    if (pstr != NULL)
        strcpy(setup.PGPPath,pstr);
    else
        setup.PGPPath[0] = 0;

    setup.left_margin = 1;
    setup.right_margin = 0;
    setup.justify = JUSTIFY_NONE;

    strcpy(setup.msgpktmask,"*.QW? OMEN*.* *.MO? *.TU? *.WE? *.TH? *.FR? *.SA? *.SU?");
    setup.misc_flags = MISC_SHOW_TIME | MISC_APPEND_SAVEFILE | MISC_ASK_APPEND | MISC_SHOW_SCROLLBAR;
    setup.scrsaver = 300;
    setup.packetsort = PKTSORT_DATE;
    setup.packet_flags = PKT_SAVE_BOOK | PKT_REN_PACKET | PKT_KEEP_PACKED;
    strcpy(setup.tearline, "SkyReader/@LONGOS@");
    strcpy(setup.vernum, "@VER@");
    strcpy(setup.msgtxt,"msgtemp.txt");
    strcpy(setup.title,"SkyReader/@OS@ - @BBS@");
}

static void AddSlash(char *txt)
{
    int slen;

    slen = strlen(txt);
    if ((slen > 0) && (txt[slen-1] != SLASH))
    {
        txt[slen] = SLASH;
        txt[slen+1] = 0;
    }
}

/*static void MDFile (char *filename)
{
    FILE *inFile = fopen (filename, "rb");
    MD5_CTX mdContext;
    int bytes;
    unsigned char data[1024]; 

    if (inFile == NULL)
    {
        printf ("%s can't be opened.\n", filename);
        return;
    }

    MD5Init (&mdContext);
    while ((bytes = fread (data, 1, 1024, inFile)) != 0) 
        MD5Update (&mdContext, data, bytes);
    MD5Final (&mdContext);

    for (i = 0; i < 16; i++)
        printf ("%02x", mdContext->digest[i]);

    fclose (inFile);
}*/

void reader_info(void)
{
    unsigned short cx, cy;
    char *oldscr;

    save_scr(&cx, &cy, &oldscr);
    draw_shaded_box(scrwidth/2-30, 5, scrwidth/2+30, 16, color[col_info_frame], color[col_info_title], NULL);
    cmiddle(7, Reader_Name" v"version, color[col_info_text]);
    cmiddle(8, COPYRIGHT, color[col_info_text]);
    cmiddle(9, "All rights reserved", color[col_info_text]);

    if (registered)
        cmiddle(11, "Registered version", color[col_info_hilight]);
    else
        cmiddle(11, "Unregistered version", color[col_info_hilight]);

#ifdef __linux__
    int f, len, slen;
    char str[256];

    f = open("/proc/sys/kernel/ostype", O_RDONLY);
    if (f != -1)
    {
        strcpy(str, "Running under ");
        len = read(f, str+14, 50);
        while (len > 0 && (str[14+len-1] == 13 || str[14+len-1] == 10)) len--;
        str[len+14] = '\0';
        close(f);
        f = open("/proc/sys/kernel/osrelease", O_RDONLY);
        if (f != -1)
        {
            sprintf(str+strlen(str), " kernel version ");
            slen = strlen(str); len = read(f, str+slen, 50);
            while (len > 0 && (str[slen+len-1] == 13 || str[slen+len-1] == 10)) len--;
            str[len+slen] = '\0';
            close(f);
        }
        cmiddle(13, str, color[col_info_text]);
    }
    conv_macros("Uptime @UPTIME_DAYS@ days and @UPTIME_HOURS@ hours", str);
    cmiddle(14, str, color[col_info_text]);
#elif defined (__OS2__)
    char str[256];
    conv_macros("OS/2 Uptime @UPTIME_DAYS@ days and @UPTIME_HOURS@ hours", str);
    cmiddle(14, str, color[col_info_text]);
#elif defined (__NT__)
    char str[256];
    conv_macros("Uptime @UPTIME_DAYS@ days and @UPTIME_HOURS@ hours", str);
    cmiddle(14, str, color[col_info_text]);
#endif

    while (!sk_kbhit()) give_timeslice();
    if (sk_getch() == 0) sk_getch();

    old_scr(cx, cy, &oldscr);
}

int main(int args, char *argv[])
{
#ifdef __OS2__
    VIOMODEINFO VioMode;
    VIOMODEINFO OldMode;
    VIOCURSORINFO vio_curs;
#else
    char cstart,cend;
#if !defined (__NT__) && !defined (__linux__)
    union REGS regs;
    unsigned oldmode;
    unsigned short old_c_height;
#endif
#endif

    char title[256],tmp[256],openpkt[13];
    int x,y;

    unsigned short ox,oy;
    char *oldscr;

    char quit;
    unsigned ypos,slen,box_end,start,end;
    int ch;
    char register_name[50];
    struct find_t sr;

    FILE *F;

    printf("SkyReader v"version" - "COPYRIGHT"\n");
#if 0
    if (!checkcrc())
    {
        printf("Wrong CRC in SkyReader's executable! Please don't use any executable\n");
        printf("packers (like lxlite, pklite, etc.), SkyReader won't work with them.\n");
        printf("If you think haven't done anything to this executable, this is probably\n");
        printf("infected by virus or something. Please get yourself a working executable..\n");
        return 1;
    }
#endif

/*#ifdef __linux__
    struct stat statbuf;

    if (stat("/usr/share/terminfo", &statbuf) != 0)
    {
        printf("\n/usr/share/terminfo does not exist - type:\n");
        printf("ln -s /usr/lib/terminfo /usr/share/terminfo\n\n");
        return 1;
    }
#endif*/
    registered = (char) checkkeyfile(register_name);

#ifdef __linux__
    home = getenv("HOME");
    if (home == NULL)
    {
        printf("HOME environment variable not found.\n");
        return 1;
    }
#else
    _grow_handles(30);
    putenv("TZ=UTC00");
    tzset();
#endif

    showclock = 0;
    keep_video_mode = 0;
    chg_title = 1;

    printf("starting up...\n");
#ifdef __NT__
    /* Initialise screen and keyboard */
    KbdInit();
    InitScreen();
    scrwidth = 80;
    scrsize = 25;
#elif defined (__OS2__)
    OldMode.cb = sizeof(VIOMODEINFO);
    VioGetMode(&OldMode,0);
    scrsize = OldMode.row;
    scrwidth = OldMode.col;
#elif defined (__linux__)
    InitScreen();
    scrwidth = COLS;
    scrsize = LINES;
#else
    /* Detect operating system */
    opsysDetect();

    /* Get screen width */
    regs.h.ah = 0x0f;
#ifdef __386__
    int386(0x10,&regs,&regs);
#else
    int86(0x10,&regs,&regs);
#endif
    scrwidth = regs.h.ah;
    scrsize = 25;
#endif

    /* Read color configuration */
    if (!read_color_file())
    {
#ifdef __linux__
        endwin();
#endif
        return 1;
    }

    highwrite_hicol = color[col_box_hilight];
    highwrite_locol = color[col_box_text];
    clockcolor = color[col_clock];

    strcpy(cfgfile,DEF_CFG_FILE);

    /* Parse command line arguments */
    openpkt[0] = 0;
    for (x=1; x<args; x++)
    {
        if ((argv[x][0] == '/') || (argv[x][0] == '-'))
        {
            switch (toupper(argv[x][1]))
            {
                case 'C':
                    strcpy(cfgfile,&argv[x][2]);
                    break;
                case 'V':
                    keep_video_mode = 1;
                    break;
                case 'T':
                    chg_title = 0;
                    break;
                case 'M':
#if !defined (__linux__) && !defined (__NT__) && !defined (__OS2__)
#ifndef __386__
                    s_screen = (char far *) 0xb0000000;
                    screen = (unsigned short far *) 0xb0000000;
#else
                    s_screen = (char *) 0xb0000;
                    screen = (unsigned short *) 0xb0000;
#endif
#endif
                    break;
                default:
                __help:
                    sprintf(tmp,Reader_Name" v"version" - Command line help");
                    save_scr(&ox,&oy,&oldscr);
                    draw_shaded_box(scrwidth/2-32,7,scrwidth/2+32,19,color[col_info_frame],color[col_info_title],tmp);
#ifdef __OS2__
                    cmiddle(9,"sky2.exe [/v] [/c<fname>] [/t] [packet.000]",color[col_info_hilight]);
#elif defined (__NT__)
                    cmiddle(9,"skyw32.exe [/v] [/c<fname>] [packet.000]",color[col_info_hilight]);
#elif defined (__linux__)
                    cmiddle(9,"sky [/v] [/c<fname>] [packet.000]",color[col_info_hilight]);
#elif defined (__386__)
                    cmiddle(9,"sky386.exe [/v] [/c<fname>] [/m] [packet.000]",color[col_info_hilight]);
#else
                    cmiddle(9,"skyread.exe [/v] [/c<fname>] [/m] [packet.000]",color[col_info_hilight]);
#endif
                    cwritexy(scrwidth/2-30,11,"packet.000 : You can immediately open mail packet by entering",color[col_info_text]);
                    cwritexy(scrwidth/2-30,12,"             it's name to command line",color[col_info_text]);
                    cwritexy(scrwidth/2-30,14,"/v : Keep startup video mode. Usable when you have messed up",color[col_info_text]);
                    cwritexy(scrwidth/2-30,15,"     SkyReader's video modes.",color[col_info_text]);
                    cwritexy(scrwidth/2-30,16,"/c : Read configuration from file <fname> instead of the",color[col_info_text]);
                    cwritexy(scrwidth/2-30,17,"     default "DEF_CFG_FILE".",color[col_info_text]);
#ifdef __OS2__
                    cwritexy(scrwidth/2-30,18,"/t : Don't change title name in OS/2 version",color[col_info_text]);
#elif !defined (__linux__) && !defined (__NT__)
                    cwritexy(scrwidth/2-30,18,"/m : Use with MDA (display adapter)",color[col_info_text]);
#endif
                    if (sk_getch() == 0) sk_getch();
                    old_scr(ox,oy,&oldscr);
                    return 0;
            }
        } else {
            if (strlen(argv[x]) > 12) goto __help;
            strcpy(openpkt,argv[x]);
        }
    }

    /* Disable Ctrl-C and Ctrl-Break */
#ifndef __linux__
    signal(SIGBREAK,SIG_IGN);
    signal(SIGINT,SIG_IGN);
#endif

#ifdef __OS2__
    /* Set keyboard to binary mode */
    KBDINFO kbstInfo;
    kbstInfo.cb = sizeof(kbstInfo);
    KbdGetStatus(&kbstInfo,0);
    kbstInfo.fsMask &= ~KEYBOARD_ASCII_MODE;
    kbstInfo.fsMask |= KEYBOARD_BINARY_MODE;
    KbdSetStatus(&kbstInfo,0);
#endif

#if defined (__MSDOS__) && !defined (__386__)
    init_SPAWNO(".",SWAP_DISK | SWAP_EMS | SWAP_XMS);
#endif

    if (!read_language_file())
    {
#ifdef __linux__
        endwin();
#endif
        return 1;
    }

    /* Read configuration */
    if ((F = FileOpen(cfgfile,"r+b")) != NULL)
    {
        if (fread(&setup,sizeof(setup),1,F) == 0)
        {
            fclose(F);
            F = NULL;
        }
        else
            fclose(F);
    }

    if (F == NULL)
    {
        GetDefaultConfig();
        if ((F = FileOpen(cfgfile,"w+b")) != NULL)
        {
            fwrite(&setup,sizeof(setup),1,F);
            fclose(F);
        }
        F = NULL;
    }
    read_setup(NULL);

    // t poista joskus!
    setup.packet_flags &= ~PKT_SAVE_UNPACKED;

    AddSlash(setup.datapath);
    AddSlash(setup.downpath);
    AddSlash(setup.uppath);
    AddSlash(setup.workpath);
    AddSlash(setup.replypath);
    AddSlash(setup.packetpath);
    AddSlash(setup.oldpktpath);

    if (!keep_video_mode)
    {
        /* Set video mode */
#ifdef __OS2__
        memcpy(&VioMode,&OldMode,sizeof(VioMode));
        VioMode.col = setup.scrmode[setup.modenum-1].columns;
        VioMode.row = setup.scrmode[setup.modenum-1].rows;
        VioMode.hres = setup.scrmode[setup.modenum-1].hres;
        VioMode.vres = setup.scrmode[setup.modenum-1].vres;

        if (VioSetMode(&VioMode, 0)) {
            scrsize = OldMode.row;
            scrwidth = OldMode.col;
            c_height = OldMode.vres / scrsize;
            sprintf(tmp,"Sorry, can't initialize mode %i (%ix%i)",setup.modenum,
                    setup.scrmode[setup.modenum-1].columns,setup.scrmode[setup.modenum-1].rows);
            err_box(tmp);
        }
        else
        {
            scrsize = VioMode.row;
            scrwidth = VioMode.col;
            c_height = setup.scrmode[setup.modenum-1].vres / scrsize;
        }
#elif defined (__NT__)
        COORD Coord;

        c_height = 16;
        Coord.X = setup.scrmode[setup.modenum-1].columns;
        Coord.Y = setup.scrmode[setup.modenum-1].rows;
        if (SetConsoleScreenBufferSize(scrHandle,Coord) == TRUE)
        {
            scrwidth = Coord.X;
            scrsize = Coord.Y;
        }
        else
        {
            scrwidth = 80;
            scrsize = 25;
            sprintf(tmp,"Sorry, can't initialize mode %i (%ix%i)",setup.modenum,
                    setup.scrmode[setup.modenum-1].columns,setup.scrmode[setup.modenum-1].rows);
            err_box(tmp);
        }
#elif !defined (__linux__)
        if ((setup.scrmode[setup.modenum-1]._ax > 1) && (setup.scrmode[setup.modenum-1].columns >= 80))
        {
            regs.h.ah = 0x0f;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            oldmode = regs.h.al & 0x7f;

            regs.w.ax = 0x1130;
            regs.w.bx = 0;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            old_c_height = regs.w.cx;

            scrwidth = setup.scrmode[setup.modenum-1].columns;
            scrsize = setup.scrmode[setup.modenum-1].rows;

            regs.w.ax = setup.scrmode[setup.modenum-1]._ax;
            regs.w.bx = setup.scrmode[setup.modenum-1]._bx;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
        }
        else
        {
            keep_video_mode = 1;
        }
#endif
    }

#ifdef __MSDOS__
    regs.w.ax = 0x1130;
    regs.w.bx = 0;
#ifdef __386__
    int386(0x10,&regs,&regs);
#else
    int86(0x10,&regs,&regs);
#endif
    c_height = regs.w.cx;
#endif

    ctrl_keys = 0;

    /* Save cursor size */
#ifndef __OS2__
    getcursorsize(&cstart,&cend);
#else
    VioGetCurType(&vio_curs,0);
#endif

    gettitle(title);
    settitle(Reader_Name);
    nocursor();
    tclrscr();

    tbar(1,1,scrwidth,1,color[col_title]);
    cmiddle(1," "Reader_Name" v"version" ",color[col_title]);
    draw_clock();

    showclock = 1;
#ifdef __linux__
    for (y=2; y<=(int) scrsize; y++)
    {
        for (x=1; x<=(int) scrwidth; x++)
        {
            writechr(x,y,ACS_CKBOARD,color[col_background]);
        }
    }
#else
    memset(tmp,'',scrwidth);
    tmp[scrwidth] = '\0';
    for (y=2; y<=scrsize; y++)
        cwritexy(1,y,tmp,color[col_background]);
#endif

    draw_shaded_box(scrwidth/2-35,15,scrwidth/2+36,21,color[col_box_frame],color[col_box_title],""Reader_Name" v"version"");
    cmiddle(17,"Blue Wave, QWK, OMEN, SOUP & Hippo v2 Compatible Offline Mail Reader",color[col_box_text]);
    cmiddle(19,COPYRIGHT,color[col_box_hilight]);

    if (registered)
    {
        sprintf(tmp, "Registered to %s", register_name);
        cmiddle(20, tmp, color[col_box_title]);
    }
    else
    {
        cmiddle(20, "[UNREGISTERED]", color[col_box_title]);
    }

    if (!isdir(setup.datapath)) ask_mkdir(setup.datapath);
    if (!isdir(setup.downpath)) ask_mkdir(setup.downpath);
    if (!isdir(setup.uppath)) ask_mkdir(setup.uppath);
    if (!isdir(setup.workpath)) ask_mkdir(setup.workpath);
    if (!isdir(setup.replypath)) ask_mkdir(setup.replypath);
    if (!isdir(setup.packetpath)) ask_mkdir(setup.packetpath);
    if (!isdir(setup.oldpktpath)) ask_mkdir(setup.oldpktpath);

#ifdef alphaversion
    /* Alpha version notice */
    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-30,5,scrwidth/2+31,12,color[col_warn_frame],color[col_warn_title],"Alpha information");
    cmiddle(7,"This is an ALPHA version of SkyReader.",color[col_warn_text]);
    cmiddle(8,"Please don't distribute at least not much!",color[col_warn_text]);
    sprintf(tmp,"Compiled %s %s",__DATE__,__TIME__);
    cmiddle(10,tmp,color[col_warn_hilight]);
    try_key(10);
    old_scr(ox,oy,&oldscr);
#elif defined (betaversion)
    /* Beta version notice */
    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-30,5,scrwidth/2+31,12,color[col_warn_frame],color[col_warn_title],"Public beta version info");
    cmiddle(7,"This is a public _beta_ version of SkyReader.",color[col_warn_text]);
    cmiddle(8,"Please report all bugs found to the author!",color[col_warn_text]);
    sprintf(tmp,"Compiled %s %s",__DATE__,__TIME__);
    cmiddle(10,tmp,color[col_warn_hilight]);
    try_key(10);
    old_scr(ox,oy,&oldscr);
#else
    /* Unregistered version nagging */
    if (!registered)
    {
        save_scr(&ox,&oy,&oldscr);
        draw_shaded_box(scrwidth/2-30,5,scrwidth/2+31,12,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(7,"This is an UNREGISTERED version of SkyReader.",color[col_warn_text]);
        cmiddle(8,"Please support shareware and register!",color[col_warn_text]);
        sprintf(tmp,"Compiled %s %s",__DATE__,__TIME__);
        cmiddle(10,tmp,color[col_warn_hilight]);
        try_key(10);
        old_scr(ox,oy,&oldscr);
    }
#endif

    for (y=0; y<=255; y++)
    {
        inbound[y] = (unsigned char) y;
        outbound[y] = (unsigned char) y;
    }

    if (setup.msgtxt[0] == '\0') strcpy(setup.msgtxt,"msgtemp.txt");

    if (F == NULL)
    {
        /* Done waay much upper */
        save_scr(&ox,&oy,&oldscr);
        draw_shaded_box(scrwidth/2-33,7,scrwidth/2+33,11,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(9,"Configuration file not found, created new with default settings",color[col_warn_hilight]);
        try_key(5);
        old_scr(ox,oy,&oldscr);
    }

    sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
    Fsky = FileOpen(tmp,"r+b");
    if (Fsky != NULL)
    {
        fread(pktname,13,1,Fsky);
        fread(&arcfmt,1,1,Fsky);
        fread(&replyopen,1,1,Fsky);
        fread(&replymgr,1,1,Fsky);
        fclose(Fsky);

        if (replymgr) reply_mgr(1);
    }
    else
    {
        sprintf(tmp, "%s*.upl", setup.replypath);
        if (_dos_findfirst(tmp, 0, &sr) == 0)
        {
            /* .upl file found from reply path */
            slen = (int) (strchr(sr.name, '.')-sr.name);
            memcpy(pktname, sr.name, slen); pktname[slen] = '\0';
            sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
            Fsky = FileOpen(tmp, "w+b");
            fread(pktname,13,1,Fsky);
            fread(&arcfmt,1,1,Fsky);
            fread("\x01",1,1,Fsky);
            fread("\x01",1,1,Fsky);
            fclose(Fsky);

            reply_mgr(1);
        }
    }

    ypos = 1;
again:
    if (openpkt[0] == '\0')
    {
        box_end = get_max_langtext_len(0,4)+10;
        draw_shaded_box(8,5,box_end,10,color[col_box_frame],color[col_box_title],lang[0]);

        for (y=0; y<4; y++)
            keys[y] = toupper(highwrite(10,y+6,lang[y+1],&keypos[y]));

        quit = 0;
        tattrbar(9,5+ypos,box_end-1,5+ypos,color[col_box_select]);
    }
    else
    {
        box_end = 0;
        quit = 1;
    }

    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = toupper(sk_getch());
            if (ch == keys[0])
            {
                clropt(ypos,box_end);
                quit = 1; ypos = 1;
                tattrbar(9,6,box_end-1,6,color[col_box_select]);
                continue;
            }
            if (ch == keys[1])
            {
                clropt(ypos,box_end);
                quit = 1; ypos = 2;
                tattrbar(9,7,box_end-1,7,color[col_box_select]);
                continue;
            }
            if (ch == keys[2])
            {
                clropt(ypos,box_end);
                quit = 1; ypos = 3;
                tattrbar(9,8,box_end-1,8,color[col_box_select]);
                continue;
            }
            if ((ch == keys[3]) || (ch == 27))
            {
                clropt(ypos,box_end);
                quit = 1; ypos = 4;
                tattrbar(9,9,box_end-1,9,color[col_box_select]);
                continue;
            }
            if (ch == 13)
            {
                quit = 1;
            }
            else if (ch == 0)
            {
                ch = sk_getch();
                switch (ch)
                {
                    case '$':
                        shell_dos(); break;
                    case 'P':
                        clropt(ypos,box_end);
                        ypos++;
                        if (ypos == 5) ypos = 1;
                        tattrbar(9,5+ypos,box_end-1,5+ypos,color[col_box_select]);
                        break;
                    case 'H':
                        clropt(ypos,box_end);
                        ypos--;
                        if (ypos == 0) ypos = 4;
                        tattrbar(9,5+ypos,box_end-1,5+ypos,color[col_box_select]);
                        break;
                }
            }
        }
        else
        {
            give_timeslice();
        }
    }

    if ((openpkt[0] != 0) && (!exists(strcat(strcpy(tmp,setup.downpath),openpkt))))
    {
        slen = strlen(lang[214])/2;
        if (strlen(openpkt) > slen) slen = strlen(openpkt);
        draw_shaded_box(scrwidth/2-slen-2,7,scrwidth/2+slen+2,11,color[col_warn_frame],color[col_warn_title],openpkt);
        cmiddle(9,lang[214],color[col_warn_hilight]);
        try_key(3);
    }
    else
    {
        switch (ypos)
        {
            case 1:
                open_mailpacket(openpkt);
                if (openpkt[0] != 0) break;
                goto again;
            case 2:
                reply_mgr(0);
                goto again;
            case 3:
                run_setup();
                goto again;
        }
    }

    if (openpkt[0] == 0)
    {
        /* Quit SkyReader? */
        save_scr(&ox,&oy,&oldscr);
        slen = get_max_langtext_len(5,7);

        start = (scrwidth/2)-slen/2-2-(slen & 1);
        end = (scrwidth/2)+(slen/2)+3;

        draw_shaded_box(start,10,end,13,color[col_warn_frame],color[col_warn_title],lang[5]);
        highwrite_hicol = color[col_warn_hilight];
        highwrite_locol = color[col_warn_text];
        keys[0] = toupper(highwrite(start+(end-start+1)/2-strlen(lang[6])/2,11,lang[6],&keypos[0]));
        keys[1] = toupper(highwrite(start+(end-start+1)/2-strlen(lang[7])/2,12,lang[7],&keypos[1]));
        highwrite_hicol = color[col_box_hilight];
        highwrite_locol = color[col_box_text];

        quit = 0; ypos = 0;
        tattrbar(start+1,ypos+11,end-1,ypos+11,color[col_warn_selectbar]);

        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = toupper(sk_getch());
                if (ch == keys[0])
                {
                    ypos = 0;
                    quit = 1;
                }
                if ((ch == keys[1]) || (ch == 27)) {
                    
                    ypos = 1;
                    quit = 1;
                }
                if (ch == 13) quit = 1;
                if (ch == 0)
                {
                    ch = sk_getch();
                    if ((ch == 'P') || (ch == 'H'))
                    {
                        tattrbar(start+1,ypos+11,end-1,ypos+11,color[col_warn_text]);
                        writechr(start+(end-start+1)/2-strlen(lang[6+ypos])/2+keypos[ypos]-1,ypos+11,keys[ypos],color[col_warn_hilight]);
                        ypos = 1-ypos;
                        tattrbar(start+1,ypos+11,end-1,ypos+11,color[col_warn_selectbar]);
                    }
                }
            } else give_timeslice();
        }
        old_scr(ox,oy,&oldscr);
        if (ypos == 1) goto again;
    }

#ifdef __OS2__
    if (!keep_video_mode)
        VioSetMode(&OldMode, 0);
#elif !defined (__NT__) && !defined (__linux__)
    if (!keep_video_mode) {
        regs.w.ax = oldmode;
#ifdef __386__
        int386(0x10,&regs,&regs);
#else
        int86(0x10,&regs,&regs);
#endif
        if ((oldmode == 3) && (old_c_height == 8)) {
            regs.w.ax = 0x1112;
            regs.w.bx = 0;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
        }
    }
#endif
    tclrscr();
    printf("Thanks for using "Reader_Name"!\n");

    settitle(title);

    /* Cursor size back */
#ifndef __OS2__
    cursorsize(cstart,cend);
#else
    VioSetCurType(&vio_curs,0);
#endif

#ifdef __NT__
    KbdDeInit();
#endif
#ifdef __linux__
    endwin();
#endif

    free(lang);
    return 0;
}
